/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 

#ifndef VDKCSORTLIST_H
#define VDKCSORTLIST_H
#include <vdk/vdkclist.h>

/*!
  \class VDKCustomSortedList
  This class provides a sorted custom list

  \par Programming tips
  All methods act like in VDKCustomList but inserting rows in 
  ascending order using a column as key. Currently only char* keys
  are supported.

  \par EXAMPLES
  ./testvdk/sortlistwin.cc
*/
class VDKCustomSortedList: public VDKCustomList
{
 protected:
 int keypos;
 char *oldkey;
 public:
 // properties
 /*!
   Setting Unique to true (false is the default) forces the list to do not
   insert duplicate keys.
  */
 bool Unique;
 /*!
   Constructor
   \param owner
   \param keyPos represent key column pos
   \param titles string array of column titles
   \param mode selection mode
  */
 VDKCustomSortedList(VDKForm* owner,
		     int keyPos,
		     int columns = 1,
		     char **titles = NULL,
		     GtkSelectionMode mode = GTK_SELECTION_SINGLE);
 /*!
   Destructor 
  */
 ~VDKCustomSortedList() {}
 /*!
   Adds a row in ascending order respect to a key
   \param s a strin array
   \param pixdata a pixmap
   \param col pixmap column position
  */
 bool AddKey(char **s, char** pixdata = NULL, int col = 0);
 /*!
   Updates row containg <key>
   \param key key value to be updated
   \param s string array
   \param pixdata a pixmap
   \col pixmap column
  */
 void UpdateKey(const char* key, char** s, 
		char** pixdata = NULL, int col = 0);
 /*!
   Update a single cell at row containing <key>
   \param key key value to be updated
   \param col column position of the cell to be updated
   \param pixdata a pixmap
  */
 void UpdateCellKey(const char* key, int col, 
		    const char* s, char** pixdata = NULL);
 /*!
   Remove the row containing <key>
   \param key key to be removed
  */
 void RemoveKey(const char* key);
 /*!
   Returns row containing <key>, -1 if not found
  */
 int FindKey(const char* key);
 /*!
   Return key column position
  */
 int KeyPos() { return keypos; }
};
#endif
