#!/usr/local/bin/perl


print "1..1\n";

use Wise2;
&Wise2::change_max_BaseMatrix_kbytes(20000);
$cm   = &Wise2::CompMat::read_Blast_file_CompMat("blosum62.bla");
$seq1 = &Wise2::new_Sequence_from_strings("one","WLGQRNLVSSTGGNLLNVWLKDW");
$seq2 = &Wise2::new_Sequence_from_strings("two","WMGNRNVVNLLNVWFRDW");

$alb = &Wise2::Align_Sequences_ProteinSmithWaterman($seq1,$seq2,$cm,-12,-2);

&Wise2::write_pretty_str_align($alb,$seq1->name,$seq1->seq,$seq2->name,$seq2->seq,15,50,STDERR);

$gene = new Wise2::Gene;
$gene->set_start(140);
$gene->set_end(180);
$tr = new Wise2::Transcript;

$ex = new Wise2::Exon;

$ex->set_start(0);
$ex->set_end(12);

$tra = new Wise2::Translation;
$tra->set_start(3);
$tra->set_end(9);

$tr->add_exon($ex);   
$tr->add_translation($tra);

$gene->add_transcript($tr);
$gene->add_transcript($tr);

$gene->show_pretty_Gene(\*STDOUT);

foreach $tr ( $gene->each_transcript() ) {
	print STDERR sprintf(" Tr was $tr with  exons %d\n",$tr->length_exon());
}

#
# build a sequence from raw memory
#

$seq = &Wise2::new_Sequence_from_strings("A1-drome","MVNSNQNQNGNSNGHDDDFPQDSITEPEHMRKLFIGGLDYRTTDENLKAHFEKWGNIVDVVVMKDPRTKRSRGFGFITYSHSSMIDEAQKSRPHKIDGRVVEPKRAVPRQDIDSPNAGATVKKLFVGALKDDHDEQSIRDYFQHFGNIVDINIVIDKETGKKRGFAFVEFDDYDPVDKVVLQKQHQLNGKMVDVKKALPKQNDQQGGGGGRGGPGGRAGGNRGNMGGGNYGNQNGGGNWNNGGNNWGNNRGGNDNWGNNSFGGGGGGGGGYGGGNNSWGNNNPWDNGNGGGNFGGGGNNWNNGGNDFGGYQQNYGGGPQRGGGNFNNNRMQPYQGGGGFKAGGGNQGNYGGNNQGFNNGGNNRRY");

#
# Map it to a 'typed' sequence object
#

$pro  = &Wise2::Protein::Protein_from_Sequence($seq);


#
# read a sequence file from a file - inbuilt data file handle!
#

$seq2 = &Wise2::Sequence::read_fasta_Sequence(DATA);

#
# Map to 'typed' sequence object
# 

$gen  = &Wise2::Genomic_from_Sequence($seq2);


#
# Make necessary gene object things for algorithm. There should be
# an easier way of doing this.
#

# these are for the gene model
$gf   = &Wise2::read_GeneFrequency21_file("human.gf");
$ct   = &Wise2::CodonTable::read_CodonTable_file("codon.table");
$rmd  = &Wise2::RandomModelDNA_std();
#
$gp   = &Wise2::GeneParameter21_wrap($gf,0.00001,0.000001,$rmd,0,1,1,$ct,0.999,0.99,0.8,0.99,0.4);

$gf = 0;

&Wise2::error_on(16);

#these are for the proteins...


$rm   = &Wise2::default_RandomModel();


$type = &Wise2::gwrap_alg_type_from_string("623");

$seq2 = $pro->baseseq(); # gets base sequence class

$seq2->set_name("NewName");

# print STDERR "Comp mat is $cm and gf is $gf\n";

$pg = new Wise2::PotentialGene;

$alb  = &Wise2::AlnBlock_from_protein_genewise_wrap($pro,$gen,$cm,-12,-2,$gp,$rmd,$rmd,$type,0,1,$rm,0.9,$pg);

&Wise2::protein2genomic_ascii_display($alb,$pro,$gen,$ct,15,50,STDERR);

for($alc=$alb->start();1;) {
    print STDERR sprintf("Got %s at %d-%d\n",$alc->alu(1)->text_label,$alc->alu(1)->start,$alc->alu(1)->end);
    if( $alc->at_end() == 1) {
	last;
    }
    $alc2 = $alc->next();
    $alc  = $alc2;
}

__END__
>HSHNRNPA
TCGCCATTTTACTACACGTGCGGTCAACAAGAGTTCATTGCAAAAAAATTGTTACCTCCT
AGCTGCTTGTCTAATACATAGTGTTAATCATGCTTTGCCAAGCGACTTGACTGTAATATT
TGCGCGTGGAAGATTAAAAAGATGTTAAACACCCAAGGTAGATTCAAATGTGAATGATTG
GTCGGTTGGCCAATCAGACTGGTTAACAATAACATTACTCGGGAACCAATGGACTCCAAG
GGGTGGAGACGGCGTAGAACGACCGAAGGAATGACGTTACACAGCAATGTGGCACCACAG
GCCAATAGCAGGGGGAAGCGATTTCAAGTATCCAATCAGAGCTGTTCTAGGGCGGAGTCT
ACCAATGCCGAAAGCGAGGAGGCGGGGTAAAAAAGAGAGGGCGAAGGTAGGCTGGCAGAT
ACGTTCGTCAGCTTGCTCCTTTCTGCCCGTGGACGCCGCCGAAGAAGCATCGTTAAAGTC
TCTCTTCACCCTGCCGTCATGTCTAAGTCAGAGGTGAGTTAGGCGCGCTTTCCCACTTGA
ATTTTTTCCTCTCCCTTTCCTGAATCGGTAAGATGCTGCTGGGTTTCGTTCCTTGCACCA
GCCCATTCTACAGTTCCTTCGGTCGCTGCCACGGCCTACCCCTCCCAAAGTTCAAGTCGC
CATTTTGTCCTCTTGATCGCCATGAGGCCGCTCTCCGCCAACCATGTGTTATCATGCGGG
ACTCGTTACTCGTAGCAAAATTCTTAGGCACACAGGATCTTTGTCTTTTTTTAAACCTTG
CCTTGGTGAGCGAGTTTTCTAAAGAGCGATTAGTCCCATTGTGGAGATGCACCCCTACCG
CCCAAGCCTTTGTTGCGCGTGCGTCGGAAGGCGACTAGGGACGCATGCGCTTGCGATTTC
CTAGCACTCCCAACTCCAGCATACGGCCTCCCTTGATAGGCAGAAGCACGTGTCTTGTTG
CGACCTGAACGAACAATAAGTGCTAGGTACACAGTTGGTGTCTAGTTTTTCTTTTCCTCG
ATGGAAATTGTTTCGTGTTGTAGCCCATTTAACACTTCCCCCTCCCCCCACTCTAGTCTC
CTAAAGAGCCCGAACAGCTGAGGAAGCTCTTCATTGGAGGGTTGAGCTTTGAAACAACTG
ATGAGAGCCTGAGGAGCCATTTTGAGCAATGGGGAACGCTCACGGACTGTGTGGTAAGAT
TTGGAAGGGACAAAGCAGTAAAACAGCCGATTTCCTTGGCTTATCTTGGTGCAGTCTTCT
CCGAATGCTTATGAAAGTAGTTAATAGCATTATAGTTAGAGCTTTGTTGGCAAAGGAACG
TCCTGCTTTGATTTTAAAAGCTAACCTCTTAAATCTAAGGGTAGTGGGAAACTGGACGAA
CTTTTTATAAAAGGCTGGTGTAAAGTTTCCTATTGCCCTATTCAAAGTTAAAATAACAAA
AGCTTTTGCGGTCAGACTTTGTGTTACATAAATTAACACTGTTCTCAGGTAATGAGAGAT
CCAAACACCAAGCGCTCTAGGGGCTTTGGGTTTGTCACATATGCCACTGTGGAGGAGGTG
GATGCAGCTATGAATGCAAGGCCACACAAGGTGGATGGAAGAGTTGTGGAACCAAAGAGA
GCTGTCTCCAGAGAAGTGAGTGGGTTTTTTTTCTTCTTCTTCTTAAACTTACTTGGATAT
GTGCTGCTATGAACTTAAGATTCGGGAGTTTTCTAAACTTACCAAAATTTTTTATTCGAG
TATAGGCTTTGCTAATCTAAACCTATGGTTTTTCTCCTATTAGGATTCTCAAAGACCAGG
TGCCCACTTAACTGTGAAAAAGATATTTGTTGGTGGCATTAAAGAAGACACTGAAGAACA
TCACCTAAGAGATTATTTTGAACAGTATGGAAAAATTGAAGTGATTGAAATCATGACTGA
CCGAGGCAGTGGCAAGAAAAGGGGCTTTGCCTTTGTAACCTTTGACGACCATGACTCCGT
GGATAAGATTGTCAGTAAGTATCAGATAGTGGCATTTAGTAAGGGTTCCACAATCTGTAT
GGCATTCTAAACCCTGATACCATGTTGTATCTATGTTTTTTTTTTAGTTCAGAAATACCA
TACTGTGAATGGCCACAACTGTGAAGTTAGAAAAGCCCTGTCAAAGCAAGAGATGGCTAG
TGCTTCATCCAGCCAAAGAGGTATGCTTGTTGCTTAATTAAACCTTAAAGGTAACTTTGA
GTTACTCCAGTATGAATGATTTAATGCTTAAACTTCATGTCTTAAGGTCGAAGTGGTTCT
GGAAACTTTGGTGGTGGTCGTGGAGGTGGTTTCGGTGGGAATGACAACTTCGGTCGTGGA
GGAAACTTCAGTGGTCGTGGTATGTATGGTTTATCTACATGTAGTTCTGACTTCTCACCA
TCTTTGCTATGAAGATTTTACAGTACGGGAACTGCATTCAGAATGTCACTTTAAGTCCAA
GTCATACTTAAAACTTGAAACTTTTTCTTACAGGTGGCTTTGGTGGCAGCCGTGGTGGTG
GTGGATATGGTGGCAGTGGGGATGGCTATAATGGATTTGGCAATGATGGTAAGTTTTTTA
GGAATAAGTAGAGAAAAATTCCTGGCAACCTGGATCTTTAGAATAGGTTAGTAGAGACTA
AAATTCTGGTGCATGTCAAACTCAACTTTGCCCATAACACGCATGCTGTGAGCAGGCCTT
CAGCCGTTACACTTGCACAAGTTTTCATTGTCAAATACTTTTGTCTTATTGAGAAGAATT
GTATTCTTGTAGGTGGTTATGGAGGAGGCGGCCCTGGTTACTCTGGAGGAAGCAGAGGCT
ATGGAAGTGGTGGACAGGGTTATGGAAACCAGGGCAGTGGCTATGGCGGGAGTGGCAGCT
ATGACAGCTATAACAACGGAGGCGGAGGCGGCTTTGGCGGTGGTAGTGGTAGGTATCCAG
TGATCCAAGTACTTGGTGTGACAGCTAGATTAGCCTTTTAGAGCTTGGGTTCTGGTGCTG
TTGAAGCATTGTGTGGTACACTGCATGGTATATTAAAAACAAATGGGCTTGCTATGCTAC






