/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.diff;

import java.util.Collections;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xmlunit.diff.ChildNodeXPathContextProvider;
import org.xmlunit.diff.ElementSelectors;
import org.xmlunit.diff.XPathContext;
import org.xmlunit.util.IterableNodeList;
import org.xmlunit.util.Linqy;
import org.xmlunit.util.Mapper;
import org.xmlunit.util.Nodes;

public class RecursiveXPathBuilder
implements Mapper<Node, XPathContext> {
    private Map<String, String> uri2Prefix;

    public void setNamespaceContext(Map<String, String> uri2Prefix) {
        this.uri2Prefix = uri2Prefix == null ? Collections.emptyMap() : Collections.unmodifiableMap(uri2Prefix);
    }

    @Override
    public XPathContext apply(Node n) {
        if (n instanceof Attr) {
            return this.getXPathForAttribute((Attr)n);
        }
        return this.getXPathForNonAttribute(n);
    }

    private XPathContext getXPathForNonAttribute(Node n) {
        Node parent = n.getParentNode();
        if (parent == null || parent instanceof Document) {
            return new XPathContext(this.uri2Prefix, n);
        }
        XPathContext parentContext = this.getXPathForNonAttribute(parent);
        IterableNodeList nl = new IterableNodeList(parent.getChildNodes());
        parentContext.setChildren(Linqy.map(nl, ElementSelectors.TO_NODE_INFO));
        ChildNodeXPathContextProvider cn = new ChildNodeXPathContextProvider(parentContext, nl);
        return cn.apply(n);
    }

    private XPathContext getXPathForAttribute(Attr a) {
        XPathContext elementContext = this.getXPathForNonAttribute(a.getOwnerElement());
        QName q = Nodes.getQName(a);
        elementContext.addAttribute(q);
        elementContext.navigateToAttribute(q);
        return elementContext;
    }
}

