/*	Copyright (C) 2018-2024 Martin Guy <martinwguy@gmail.com>
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* lib_sox.h: Interface to lib_sox.c */

#ifndef LIBSOX_H
#define LIBSOX_H 1

#if HAVE_LIBSOX

#include "a_file.h"		/* for af_format_t */

extern bool libsox_open(audio_file_t *af, char *filename);
extern bool libsox_seek(audio_file_t *af, int start);
extern int  libsox_read_frames(audio_file_t	*af,
			       void		*write_to,
			       frames_t	frames_to_read,
			       af_format_t	format);
extern void libsox_close(audio_file_t *af);

#endif /* HAVE_LIBSOX */

#endif /* LIBSOX_H */
