/*	Copyright (C) 2018-2024 Martin Guy <martinwguy@gmail.com>
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* libav.h: Interface to libav.c */

#ifndef LIBAV_H

# include "a_file.h"

# if HAVE_LIBAV
extern bool libav_open(audio_file_t *af, char *filename);
extern int libav_read_frames(audio_file_t *af,
			     void *write_to,
			     frames_t start,
			     frames_t frames_to_read,
			     af_format_t format);
extern void libav_close(audio_file_t *af);
# endif

# define LIBAV_H 1
#endif
