#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include "main.h"

void
on_load_settings_filesel_but_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkEntry *text = GTK_ENTRY (gtk_builder_get_object (builder, "load_file_name_text"));
    GtkFileChooserDialog *chooser = gtk_file_chooser_dialog_new(
        "Select File to load settings from",
        GTK_WINDOW(window1),
        GTK_FILE_CHOOSER_ACTION_OPEN,
        GTK_STOCK_OPEN,
        GTK_RESPONSE_ACCEPT,
        GTK_STOCK_CANCEL,
        GTK_RESPONSE_CANCEL,
        NULL
    );
    gint result = gtk_dialog_run( GTK_DIALOG(chooser) );

    switch (result)
    {
    case GTK_RESPONSE_ACCEPT:
       gtk_entry_set_text(text, gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(chooser)) );
       break;
    default:
       // do_nothing_since_dialog_was_cancelled ();
       break;
     }
    gtk_widget_destroy( GTK_WIDGET(chooser) );
}


void
on_save_settings_filesel_but_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkEntry *text = GTK_ENTRY (gtk_builder_get_object (builder, "save_file_name_text"));
    GtkFileChooserDialog *chooser = gtk_file_chooser_dialog_new(
        "Select File to Save settings to",
        GTK_WINDOW(window1),
        GTK_FILE_CHOOSER_ACTION_SAVE,
        GTK_STOCK_SAVE,
        GTK_RESPONSE_ACCEPT,
        GTK_STOCK_CANCEL,
        GTK_RESPONSE_CANCEL,
        NULL
    );
    gint result = gtk_dialog_run( GTK_DIALOG(chooser) );

    switch (result)
    {
    case GTK_RESPONSE_ACCEPT:
       gtk_entry_set_text(text, gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(chooser)) );
       break;
    default:
       // do_nothing_since_dialog_was_cancelled ();
       break;
     }
    gtk_widget_destroy( GTK_WIDGET(chooser) );
}


void
on_load_settings_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
    int ret=0;
    const char *s;
    GtkEntry *text = GTK_ENTRY (gtk_builder_get_object (builder, "load_file_name_text"));
    char *b;
    s = gtk_entry_get_text(text);
    b = malloc (strlen(s)+strlen(getenv("HOME"))+2);


    if (s && *s) {
	if (s[0] == '~') {
	    sprintf(b, "%s%s", getenv("HOME"), s+1);
	    ret = read_config_file(&xcfg, b, 1);
	} else {
	    ret = read_config_file(&xcfg, (char *)s, 1);
	}

    }

    if (!ret) {
	GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(window1),
		GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
		"Cannot read config from '%s': %s", s, "Syntax error");
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
    } else {
	xvidcfg2window();
    }

    free(b);
}


void
on_save_settings_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
    int ret;
    GtkEntry *text = GTK_ENTRY (gtk_builder_get_object (builder, "save_file_name_text"));
    char *b;
    const char *s =  gtk_entry_get_text(text);

    b = malloc (strlen(s)+strlen(getenv("HOME"))+2);

    window2xvidcfg();

    if (s && *s) {
	if (s[0] == '~') {
	    sprintf(b, "%s%s", getenv("HOME"), s+1);
	    ret = read_config_file(&xcfg, b, 0);
	} else {
	    ret = read_config_file(&xcfg, (char *)s, 0);
	}

    }

    if (!ret) {
	GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(window1),
		GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
		"Cannot save config to '%s'", s);
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
    }
}


void
on_restore_defaults_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
    memcpy (&xcfg, &xcfg_sav, sizeof xcfg );
    xvidcfg2window();
}


void
on_save_defaults_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
    window2xvidcfg();
    memcpy (&xcfg_sav, &xcfg, sizeof xcfg );
}


void
on_matrix_editor_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  matrix_edit_dlg = GTK_WIDGET (gtk_builder_get_object(builder, "matrix_edit_dlg"));
  gtk_widget_show(matrix_edit_dlg);
}



void
on_save_matrix_edit_but_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{

    int matrix[64];
    int i;
    const char *s;
    FILE *f;
    GtkEntry *text = GTK_ENTRY (gtk_builder_get_object (builder, "matrix_edit_file"));
    s = gtk_entry_get_text(text);

    window2matrix(matrix);

    if (s && *s) {
	if ((f = fopen (s, "w")) == NULL) {
	    GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(matrix_edit_dlg),
		    GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
		    "Cannot write to '%s': %s", s, g_strerror (errno));
	    gtk_dialog_run (GTK_DIALOG (dialog));
	    gtk_widget_destroy (dialog);
	} else {
	    for (i=1; i<65; i++) {
		fprintf (f, "%3d ", matrix[i-1]);
		if ((i%8) == 0)
		    fprintf(f, "\n");
	    }
	}
	if (f) fclose(f);
    } else {
	GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(matrix_edit_dlg),
		GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
		"You must enter a filename to save to");
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
    }

}


void
on_load_matrix_edit_but_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
    int matrix[64];
    int ret=1;
    const char *s;
    GtkEntry *text = GTK_ENTRY (gtk_builder_get_object (builder, "matrix_edit_file"));
    s = gtk_entry_get_text(text);

    if (s && *s)
	ret = read_matrix(matrix, s);

    if (ret == 1) {
	GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(matrix_edit_dlg),
		GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
		"Cannot read '%s': %s", s, "No such file");
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
    } else if (ret == 2) {
	GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(matrix_edit_dlg),
		GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
		"Error while reading matrix file '%s': Syntax error", s);
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
    } else 
	matrix2window(matrix);

}


void
on_open_matrix_file_dlg_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkEntry *text = GTK_ENTRY (gtk_builder_get_object (builder, "matrix_edit_file"));
    GtkFileChooserDialog *chooser = gtk_file_chooser_dialog_new(
        "Select Matrix File",
        GTK_WINDOW(window1),
        GTK_FILE_CHOOSER_ACTION_OPEN,
        GTK_STOCK_OPEN,
        GTK_RESPONSE_ACCEPT,
        GTK_STOCK_CANCEL,
        GTK_RESPONSE_CANCEL,
        NULL
    );
    gint result = gtk_dialog_run( GTK_DIALOG(chooser) );

    switch (result)
    {
    case GTK_RESPONSE_ACCEPT:
       gtk_entry_set_text(text, gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(chooser)) );
       break;
    default:
       // do_nothing_since_dialog_was_cancelled ();
       break;
     }
    gtk_widget_destroy( GTK_WIDGET(chooser) );
}


void
on_clear_matrix_but_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *c;
    char field[128];
    int i, j;

    for (j = 0; j<8; j++) {
	for (i = 0; i<8; i++) {
	    sprintf(field, "a%d%d", i, j);
	    c = gtk_builder_get_object (builder, field);
	    gtk_entry_set_text(GTK_ENTRY(c), "");
	}
    }
}


void
on_load_intra_matrix_file_but_clicked  (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkEntry *text = GTK_ENTRY (gtk_builder_get_object (builder, "quant_intra_matrix"));
    GtkFileChooserDialog *chooser = gtk_file_chooser_dialog_new(
        "Select File for the INTRA matrix",
        GTK_WINDOW(window1),
        GTK_FILE_CHOOSER_ACTION_OPEN,
        GTK_STOCK_OPEN,
        GTK_RESPONSE_ACCEPT,
        GTK_STOCK_CANCEL,
        GTK_RESPONSE_CANCEL,
        NULL
    );
    gint result = gtk_dialog_run( GTK_DIALOG(chooser) );

    switch (result)
    {
    case GTK_RESPONSE_ACCEPT:
       gtk_entry_set_text(text, gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(chooser)) );
       break;
    default:
       // do_nothing_since_dialog_was_cancelled ();
       break;
     }
    gtk_widget_destroy( GTK_WIDGET(chooser) );
}


void
on_load_inter_matrix_file_but_clicked  (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkEntry *text = GTK_ENTRY (gtk_builder_get_object (builder, "quant_inter_matrix"));
    GtkFileChooserDialog *chooser = gtk_file_chooser_dialog_new(
        "Select File to read INTER matrix from",
        GTK_WINDOW(window1),
        GTK_FILE_CHOOSER_ACTION_OPEN,
        GTK_STOCK_OPEN,
        GTK_RESPONSE_ACCEPT,
        GTK_STOCK_CANCEL,
        GTK_RESPONSE_CANCEL,
        NULL
    );
    gint result = gtk_dialog_run( GTK_DIALOG(chooser) );

    switch (result)
    {
    case GTK_RESPONSE_ACCEPT:
       gtk_entry_set_text(text, gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(chooser)) );
       break;
    default:
       // do_nothing_since_dialog_was_cancelled ();
       break;
     }
    gtk_widget_destroy( GTK_WIDGET(chooser) );
}


void
on_max_bframes_value_changed           (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
    static int is_enabled = 0;
    GtkWidget *c;
    int val;

    c = GTK_WIDGET(gtk_builder_get_object (builder, "max_bframes"));
    val = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));
    if (val>0 && !is_enabled) {
	is_enabled = 1;

	c = GTK_WIDGET(gtk_builder_get_object (builder, "bquant_ratio_label")); gtk_widget_set_sensitive (c, TRUE);
	c = GTK_WIDGET(gtk_builder_get_object (builder, "bquant_offset_label")); gtk_widget_set_sensitive (c, TRUE);
	c = GTK_WIDGET(gtk_builder_get_object (builder, "bframe_threshold_label")); gtk_widget_set_sensitive (c, TRUE);

	c = GTK_WIDGET(gtk_builder_get_object (builder, "bquant_ratio")); gtk_widget_set_sensitive (c, TRUE);
	c = GTK_WIDGET(gtk_builder_get_object (builder, "bquant_offset")); gtk_widget_set_sensitive (c, TRUE);
	c = GTK_WIDGET(gtk_builder_get_object (builder, "bframe_threshold")); gtk_widget_set_sensitive (c, TRUE);

	c = GTK_WIDGET(gtk_builder_get_object (builder, "closed_gop")); gtk_widget_set_sensitive (c, TRUE);
	c = GTK_WIDGET(gtk_builder_get_object (builder, "packed")); gtk_widget_set_sensitive (c, TRUE);

	c = GTK_WIDGET(gtk_builder_get_object (builder, "bquant_min_max_label"));  gtk_widget_set_sensitive (c, TRUE);
	c = GTK_WIDGET(gtk_builder_get_object (builder, "min_bquant"));  gtk_widget_set_sensitive (c, TRUE);
	c = GTK_WIDGET(gtk_builder_get_object (builder, "max_bquant"));  gtk_widget_set_sensitive (c, TRUE);

	//c = gtk_builder_get_object (builder, "quarterpel"); gtk_widget_set_sensitive (c, TRUE);
	//c = gtk_builder_get_object (builder, "gmc"); gtk_widget_set_sensitive (c, TRUE);

    } else if (val == 0) {
	is_enabled = 0;

	c = GTK_WIDGET(gtk_builder_get_object (builder, "bquant_ratio_label")); gtk_widget_set_sensitive (c, FALSE);
	c = GTK_WIDGET(gtk_builder_get_object (builder, "bquant_offset_label")); gtk_widget_set_sensitive (c, FALSE);
	c = GTK_WIDGET(gtk_builder_get_object (builder, "bframe_threshold_label")); gtk_widget_set_sensitive (c, FALSE);

	c = GTK_WIDGET(gtk_builder_get_object (builder, "bquant_ratio")); gtk_widget_set_sensitive (c, FALSE);
	c = GTK_WIDGET(gtk_builder_get_object (builder, "bquant_offset")); gtk_widget_set_sensitive (c, FALSE);
	c = GTK_WIDGET(gtk_builder_get_object (builder, "bframe_threshold")); gtk_widget_set_sensitive (c, FALSE);

	c = GTK_WIDGET(gtk_builder_get_object (builder, "packed")); gtk_widget_set_sensitive (c, FALSE);
	c = GTK_WIDGET(gtk_builder_get_object (builder, "closed_gop")); gtk_widget_set_sensitive (c, FALSE);

	c = GTK_WIDGET(gtk_builder_get_object (builder, "bquant_min_max_label"));  gtk_widget_set_sensitive (c, FALSE);
	c = GTK_WIDGET(gtk_builder_get_object (builder, "min_bquant"));  gtk_widget_set_sensitive (c, FALSE);
	c = GTK_WIDGET(gtk_builder_get_object (builder, "max_bquant"));  gtk_widget_set_sensitive (c, FALSE);

	//c = gtk_builder_get_object (builder, "quarterpel"); gtk_widget_set_sensitive (c, FALSE);
	//c = gtk_builder_get_object (builder, "gmc"); gtk_widget_set_sensitive (c, FALSE);

    }
}


gboolean
on_window1_delete_event                (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  if (ofile) {
    int ret;
    GtkEntry *text = GTK_ENTRY (gtk_builder_get_object(builder, "save_file_name_text"));
    const char *s =  gtk_entry_get_text(text);

    window2xvidcfg();
    //read_config_file(&xcfg, NULL, 0);
    ret = read_config_file(&xcfg, (char *)s, 0);

    if (!ret) {
	GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(window1),
		GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
		"Cannot save config to '%s'", s);
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
    }
  }

  gtk_main_quit();

  return FALSE;
}

void
on_quit_delete_event                   (GtkButton       *button,
                                        gpointer         user_data)
{

  if (ofile) {
    int ret;
    GtkEntry *text = GTK_ENTRY (gtk_builder_get_object (builder, "save_file_name_text"));
    const char *s =  gtk_entry_get_text(text);

    window2xvidcfg();
    //read_config_file(&xcfg, NULL, 0);
    ret = read_config_file(&xcfg, (char *)s, 0);

    if (!ret) {
	GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(window1),
		GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
		"Cannot save config to '%s'", s);
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
    }
  }

  gtk_main_quit();

}

