; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+experimental-zvlsseg,+experimental-zfh \
; RUN:     -verify-machineinstrs < %s | FileCheck %s

declare void @llvm.riscv.vsseg2.nxv16i16(<vscale x 16 x i16>,<vscale x 16 x i16>, i16* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv16i16(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 16 x i1>, i32)

define void @test_vsseg2_nxv16i16(<vscale x 16 x i16> %val, i16* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vsseg2e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv16i16(<vscale x 16 x i16> %val,<vscale x 16 x i16> %val, i16* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv16i16(<vscale x 16 x i16> %val, i16* %base, <vscale x 16 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vsseg2e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv16i16(<vscale x 16 x i16> %val,<vscale x 16 x i16> %val, i16* %base, <vscale x 16 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg2.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i1>, i32)

define void @test_vsseg2_nxv1i8(<vscale x 1 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vsseg2e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv1i8(<vscale x 1 x i8> %val, i8* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vsseg2e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, i8* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg3.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg3.mask.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i1>, i32)

define void @test_vsseg3_nxv1i8(<vscale x 1 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg3_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vsseg3e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg3_mask_nxv1i8(<vscale x 1 x i8> %val, i8* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg3_mask_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vsseg3e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.mask.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, i8* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg4.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg4.mask.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i1>, i32)

define void @test_vsseg4_nxv1i8(<vscale x 1 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg4_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vsseg4e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg4_mask_nxv1i8(<vscale x 1 x i8> %val, i8* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg4_mask_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vsseg4e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.mask.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, i8* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg5.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg5.mask.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i1>, i32)

define void @test_vsseg5_nxv1i8(<vscale x 1 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg5_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vsseg5e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg5_mask_nxv1i8(<vscale x 1 x i8> %val, i8* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg5_mask_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vsseg5e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.mask.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, i8* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg6.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg6.mask.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i1>, i32)

define void @test_vsseg6_nxv1i8(<vscale x 1 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg6_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vsseg6e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg6_mask_nxv1i8(<vscale x 1 x i8> %val, i8* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg6_mask_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vsseg6e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.mask.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, i8* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg7.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg7.mask.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i1>, i32)

define void @test_vsseg7_nxv1i8(<vscale x 1 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg7_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vsseg7e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg7_mask_nxv1i8(<vscale x 1 x i8> %val, i8* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg7_mask_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vsseg7e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.mask.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, i8* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg8.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg8.mask.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i1>, i32)

define void @test_vsseg8_nxv1i8(<vscale x 1 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vsseg8e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg8_mask_nxv1i8(<vscale x 1 x i8> %val, i8* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg8_mask_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vsseg8e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.mask.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, i8* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg2.nxv16i8(<vscale x 16 x i8>,<vscale x 16 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv16i8(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 16 x i1>, i32)

define void @test_vsseg2_nxv16i8(<vscale x 16 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vsseg2e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv16i8(<vscale x 16 x i8> %val,<vscale x 16 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv16i8(<vscale x 16 x i8> %val, i8* %base, <vscale x 16 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vsseg2e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv16i8(<vscale x 16 x i8> %val,<vscale x 16 x i8> %val, i8* %base, <vscale x 16 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg3.nxv16i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg3.mask.nxv16i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 16 x i1>, i32)

define void @test_vsseg3_nxv16i8(<vscale x 16 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg3_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vsseg3e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.nxv16i8(<vscale x 16 x i8> %val,<vscale x 16 x i8> %val,<vscale x 16 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg3_mask_nxv16i8(<vscale x 16 x i8> %val, i8* %base, <vscale x 16 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg3_mask_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vsseg3e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.mask.nxv16i8(<vscale x 16 x i8> %val,<vscale x 16 x i8> %val,<vscale x 16 x i8> %val, i8* %base, <vscale x 16 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg4.nxv16i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg4.mask.nxv16i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 16 x i1>, i32)

define void @test_vsseg4_nxv16i8(<vscale x 16 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg4_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2_v14m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vsseg4e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.nxv16i8(<vscale x 16 x i8> %val,<vscale x 16 x i8> %val,<vscale x 16 x i8> %val,<vscale x 16 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg4_mask_nxv16i8(<vscale x 16 x i8> %val, i8* %base, <vscale x 16 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg4_mask_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2_v14m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vsseg4e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.mask.nxv16i8(<vscale x 16 x i8> %val,<vscale x 16 x i8> %val,<vscale x 16 x i8> %val,<vscale x 16 x i8> %val, i8* %base, <vscale x 16 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg2.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>, i32* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i1>, i32)

define void @test_vsseg2_nxv2i32(<vscale x 2 x i32> %val, i32* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg2e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, i32* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv2i32(<vscale x 2 x i32> %val, i32* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg2e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, i32* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg3.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32* , i32)
declare void @llvm.riscv.vsseg3.mask.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i1>, i32)

define void @test_vsseg3_nxv2i32(<vscale x 2 x i32> %val, i32* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg3_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg3e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, i32* %base, i32 %vl)
  ret void
}

define void @test_vsseg3_mask_nxv2i32(<vscale x 2 x i32> %val, i32* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg3_mask_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg3e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.mask.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, i32* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg4.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32* , i32)
declare void @llvm.riscv.vsseg4.mask.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i1>, i32)

define void @test_vsseg4_nxv2i32(<vscale x 2 x i32> %val, i32* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg4_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg4e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, i32* %base, i32 %vl)
  ret void
}

define void @test_vsseg4_mask_nxv2i32(<vscale x 2 x i32> %val, i32* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg4_mask_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg4e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.mask.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, i32* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg5.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32* , i32)
declare void @llvm.riscv.vsseg5.mask.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i1>, i32)

define void @test_vsseg5_nxv2i32(<vscale x 2 x i32> %val, i32* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg5_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg5e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, i32* %base, i32 %vl)
  ret void
}

define void @test_vsseg5_mask_nxv2i32(<vscale x 2 x i32> %val, i32* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg5_mask_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg5e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.mask.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, i32* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg6.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32* , i32)
declare void @llvm.riscv.vsseg6.mask.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i1>, i32)

define void @test_vsseg6_nxv2i32(<vscale x 2 x i32> %val, i32* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg6_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg6e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, i32* %base, i32 %vl)
  ret void
}

define void @test_vsseg6_mask_nxv2i32(<vscale x 2 x i32> %val, i32* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg6_mask_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg6e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.mask.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, i32* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg7.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32* , i32)
declare void @llvm.riscv.vsseg7.mask.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i1>, i32)

define void @test_vsseg7_nxv2i32(<vscale x 2 x i32> %val, i32* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg7_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg7e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, i32* %base, i32 %vl)
  ret void
}

define void @test_vsseg7_mask_nxv2i32(<vscale x 2 x i32> %val, i32* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg7_mask_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg7e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.mask.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, i32* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg8.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32* , i32)
declare void @llvm.riscv.vsseg8.mask.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i1>, i32)

define void @test_vsseg8_nxv2i32(<vscale x 2 x i32> %val, i32* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg8e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, i32* %base, i32 %vl)
  ret void
}

define void @test_vsseg8_mask_nxv2i32(<vscale x 2 x i32> %val, i32* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg8_mask_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg8e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.mask.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, i32* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg2.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>, i16* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 4 x i1>, i32)

define void @test_vsseg2_nxv4i16(<vscale x 4 x i16> %val, i16* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg2e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, i16* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv4i16(<vscale x 4 x i16> %val, i16* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg2e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, i16* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg3.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16* , i32)
declare void @llvm.riscv.vsseg3.mask.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 4 x i1>, i32)

define void @test_vsseg3_nxv4i16(<vscale x 4 x i16> %val, i16* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg3_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg3e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, i16* %base, i32 %vl)
  ret void
}

define void @test_vsseg3_mask_nxv4i16(<vscale x 4 x i16> %val, i16* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg3_mask_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg3e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.mask.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, i16* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg4.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16* , i32)
declare void @llvm.riscv.vsseg4.mask.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 4 x i1>, i32)

define void @test_vsseg4_nxv4i16(<vscale x 4 x i16> %val, i16* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg4_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg4e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, i16* %base, i32 %vl)
  ret void
}

define void @test_vsseg4_mask_nxv4i16(<vscale x 4 x i16> %val, i16* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg4_mask_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg4e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.mask.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, i16* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg5.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16* , i32)
declare void @llvm.riscv.vsseg5.mask.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 4 x i1>, i32)

define void @test_vsseg5_nxv4i16(<vscale x 4 x i16> %val, i16* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg5_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg5e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, i16* %base, i32 %vl)
  ret void
}

define void @test_vsseg5_mask_nxv4i16(<vscale x 4 x i16> %val, i16* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg5_mask_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg5e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.mask.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, i16* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg6.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16* , i32)
declare void @llvm.riscv.vsseg6.mask.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 4 x i1>, i32)

define void @test_vsseg6_nxv4i16(<vscale x 4 x i16> %val, i16* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg6_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg6e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, i16* %base, i32 %vl)
  ret void
}

define void @test_vsseg6_mask_nxv4i16(<vscale x 4 x i16> %val, i16* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg6_mask_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg6e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.mask.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, i16* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg7.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16* , i32)
declare void @llvm.riscv.vsseg7.mask.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 4 x i1>, i32)

define void @test_vsseg7_nxv4i16(<vscale x 4 x i16> %val, i16* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg7_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg7e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, i16* %base, i32 %vl)
  ret void
}

define void @test_vsseg7_mask_nxv4i16(<vscale x 4 x i16> %val, i16* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg7_mask_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg7e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.mask.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, i16* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg8.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16* , i32)
declare void @llvm.riscv.vsseg8.mask.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 4 x i1>, i32)

define void @test_vsseg8_nxv4i16(<vscale x 4 x i16> %val, i16* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg8e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, i16* %base, i32 %vl)
  ret void
}

define void @test_vsseg8_mask_nxv4i16(<vscale x 4 x i16> %val, i16* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg8_mask_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg8e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.mask.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, i16* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg2.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>, i32* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i1>, i32)

define void @test_vsseg2_nxv1i32(<vscale x 1 x i32> %val, i32* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg2e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, i32* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv1i32(<vscale x 1 x i32> %val, i32* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg2e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, i32* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg3.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32* , i32)
declare void @llvm.riscv.vsseg3.mask.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i1>, i32)

define void @test_vsseg3_nxv1i32(<vscale x 1 x i32> %val, i32* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg3_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg3e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, i32* %base, i32 %vl)
  ret void
}

define void @test_vsseg3_mask_nxv1i32(<vscale x 1 x i32> %val, i32* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg3_mask_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg3e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.mask.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, i32* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg4.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32* , i32)
declare void @llvm.riscv.vsseg4.mask.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i1>, i32)

define void @test_vsseg4_nxv1i32(<vscale x 1 x i32> %val, i32* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg4_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg4e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, i32* %base, i32 %vl)
  ret void
}

define void @test_vsseg4_mask_nxv1i32(<vscale x 1 x i32> %val, i32* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg4_mask_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg4e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.mask.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, i32* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg5.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32* , i32)
declare void @llvm.riscv.vsseg5.mask.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i1>, i32)

define void @test_vsseg5_nxv1i32(<vscale x 1 x i32> %val, i32* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg5_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg5e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, i32* %base, i32 %vl)
  ret void
}

define void @test_vsseg5_mask_nxv1i32(<vscale x 1 x i32> %val, i32* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg5_mask_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg5e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.mask.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, i32* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg6.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32* , i32)
declare void @llvm.riscv.vsseg6.mask.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i1>, i32)

define void @test_vsseg6_nxv1i32(<vscale x 1 x i32> %val, i32* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg6_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg6e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, i32* %base, i32 %vl)
  ret void
}

define void @test_vsseg6_mask_nxv1i32(<vscale x 1 x i32> %val, i32* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg6_mask_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg6e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.mask.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, i32* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg7.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32* , i32)
declare void @llvm.riscv.vsseg7.mask.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i1>, i32)

define void @test_vsseg7_nxv1i32(<vscale x 1 x i32> %val, i32* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg7_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg7e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, i32* %base, i32 %vl)
  ret void
}

define void @test_vsseg7_mask_nxv1i32(<vscale x 1 x i32> %val, i32* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg7_mask_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg7e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.mask.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, i32* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg8.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32* , i32)
declare void @llvm.riscv.vsseg8.mask.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i1>, i32)

define void @test_vsseg8_nxv1i32(<vscale x 1 x i32> %val, i32* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg8e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, i32* %base, i32 %vl)
  ret void
}

define void @test_vsseg8_mask_nxv1i32(<vscale x 1 x i32> %val, i32* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg8_mask_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg8e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.mask.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, i32* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg2.nxv8i16(<vscale x 8 x i16>,<vscale x 8 x i16>, i16* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv8i16(<vscale x 8 x i16>,<vscale x 8 x i16>, i16*, <vscale x 8 x i1>, i32)

define void @test_vsseg2_nxv8i16(<vscale x 8 x i16> %val, i16* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m2,ta,mu
; CHECK-NEXT:    vsseg2e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv8i16(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, i16* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv8i16(<vscale x 8 x i16> %val, i16* %base, <vscale x 8 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m2,ta,mu
; CHECK-NEXT:    vsseg2e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv8i16(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, i16* %base, <vscale x 8 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg3.nxv8i16(<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>, i16* , i32)
declare void @llvm.riscv.vsseg3.mask.nxv8i16(<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>, i16*, <vscale x 8 x i1>, i32)

define void @test_vsseg3_nxv8i16(<vscale x 8 x i16> %val, i16* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg3_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m2,ta,mu
; CHECK-NEXT:    vsseg3e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.nxv8i16(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, i16* %base, i32 %vl)
  ret void
}

define void @test_vsseg3_mask_nxv8i16(<vscale x 8 x i16> %val, i16* %base, <vscale x 8 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg3_mask_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m2,ta,mu
; CHECK-NEXT:    vsseg3e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.mask.nxv8i16(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, i16* %base, <vscale x 8 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg4.nxv8i16(<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>, i16* , i32)
declare void @llvm.riscv.vsseg4.mask.nxv8i16(<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>, i16*, <vscale x 8 x i1>, i32)

define void @test_vsseg4_nxv8i16(<vscale x 8 x i16> %val, i16* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg4_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2_v14m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m2,ta,mu
; CHECK-NEXT:    vsseg4e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.nxv8i16(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, i16* %base, i32 %vl)
  ret void
}

define void @test_vsseg4_mask_nxv8i16(<vscale x 8 x i16> %val, i16* %base, <vscale x 8 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg4_mask_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2_v14m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m2,ta,mu
; CHECK-NEXT:    vsseg4e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.mask.nxv8i16(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, i16* %base, <vscale x 8 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg2.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>, i8*, <vscale x 8 x i1>, i32)

define void @test_vsseg2_nxv8i8(<vscale x 8 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,m1,ta,mu
; CHECK-NEXT:    vsseg2e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv8i8(<vscale x 8 x i8> %val, i8* %base, <vscale x 8 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,m1,ta,mu
; CHECK-NEXT:    vsseg2e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, i8* %base, <vscale x 8 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg3.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg3.mask.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, i8*, <vscale x 8 x i1>, i32)

define void @test_vsseg3_nxv8i8(<vscale x 8 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg3_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,m1,ta,mu
; CHECK-NEXT:    vsseg3e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg3_mask_nxv8i8(<vscale x 8 x i8> %val, i8* %base, <vscale x 8 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg3_mask_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,m1,ta,mu
; CHECK-NEXT:    vsseg3e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.mask.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, i8* %base, <vscale x 8 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg4.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg4.mask.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, i8*, <vscale x 8 x i1>, i32)

define void @test_vsseg4_nxv8i8(<vscale x 8 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg4_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,m1,ta,mu
; CHECK-NEXT:    vsseg4e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg4_mask_nxv8i8(<vscale x 8 x i8> %val, i8* %base, <vscale x 8 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg4_mask_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,m1,ta,mu
; CHECK-NEXT:    vsseg4e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.mask.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, i8* %base, <vscale x 8 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg5.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg5.mask.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, i8*, <vscale x 8 x i1>, i32)

define void @test_vsseg5_nxv8i8(<vscale x 8 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg5_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,m1,ta,mu
; CHECK-NEXT:    vsseg5e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg5_mask_nxv8i8(<vscale x 8 x i8> %val, i8* %base, <vscale x 8 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg5_mask_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,m1,ta,mu
; CHECK-NEXT:    vsseg5e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.mask.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, i8* %base, <vscale x 8 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg6.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg6.mask.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, i8*, <vscale x 8 x i1>, i32)

define void @test_vsseg6_nxv8i8(<vscale x 8 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg6_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,m1,ta,mu
; CHECK-NEXT:    vsseg6e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg6_mask_nxv8i8(<vscale x 8 x i8> %val, i8* %base, <vscale x 8 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg6_mask_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,m1,ta,mu
; CHECK-NEXT:    vsseg6e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.mask.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, i8* %base, <vscale x 8 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg7.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg7.mask.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, i8*, <vscale x 8 x i1>, i32)

define void @test_vsseg7_nxv8i8(<vscale x 8 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg7_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,m1,ta,mu
; CHECK-NEXT:    vsseg7e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg7_mask_nxv8i8(<vscale x 8 x i8> %val, i8* %base, <vscale x 8 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg7_mask_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,m1,ta,mu
; CHECK-NEXT:    vsseg7e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.mask.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, i8* %base, <vscale x 8 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg8.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg8.mask.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, i8*, <vscale x 8 x i1>, i32)

define void @test_vsseg8_nxv8i8(<vscale x 8 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,m1,ta,mu
; CHECK-NEXT:    vsseg8e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg8_mask_nxv8i8(<vscale x 8 x i8> %val, i8* %base, <vscale x 8 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg8_mask_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,m1,ta,mu
; CHECK-NEXT:    vsseg8e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.mask.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, i8* %base, <vscale x 8 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg2.nxv8i32(<vscale x 8 x i32>,<vscale x 8 x i32>, i32* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv8i32(<vscale x 8 x i32>,<vscale x 8 x i32>, i32*, <vscale x 8 x i1>, i32)

define void @test_vsseg2_nxv8i32(<vscale x 8 x i32> %val, i32* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m4,ta,mu
; CHECK-NEXT:    vsseg2e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv8i32(<vscale x 8 x i32> %val,<vscale x 8 x i32> %val, i32* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv8i32(<vscale x 8 x i32> %val, i32* %base, <vscale x 8 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m4,ta,mu
; CHECK-NEXT:    vsseg2e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv8i32(<vscale x 8 x i32> %val,<vscale x 8 x i32> %val, i32* %base, <vscale x 8 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg2.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>, i8*, <vscale x 4 x i1>, i32)

define void @test_vsseg2_nxv4i8(<vscale x 4 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf2,ta,mu
; CHECK-NEXT:    vsseg2e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv4i8(<vscale x 4 x i8> %val, i8* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf2,ta,mu
; CHECK-NEXT:    vsseg2e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, i8* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg3.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg3.mask.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, i8*, <vscale x 4 x i1>, i32)

define void @test_vsseg3_nxv4i8(<vscale x 4 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg3_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf2,ta,mu
; CHECK-NEXT:    vsseg3e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg3_mask_nxv4i8(<vscale x 4 x i8> %val, i8* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg3_mask_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf2,ta,mu
; CHECK-NEXT:    vsseg3e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.mask.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, i8* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg4.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg4.mask.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, i8*, <vscale x 4 x i1>, i32)

define void @test_vsseg4_nxv4i8(<vscale x 4 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg4_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf2,ta,mu
; CHECK-NEXT:    vsseg4e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg4_mask_nxv4i8(<vscale x 4 x i8> %val, i8* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg4_mask_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf2,ta,mu
; CHECK-NEXT:    vsseg4e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.mask.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, i8* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg5.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg5.mask.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, i8*, <vscale x 4 x i1>, i32)

define void @test_vsseg5_nxv4i8(<vscale x 4 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg5_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf2,ta,mu
; CHECK-NEXT:    vsseg5e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg5_mask_nxv4i8(<vscale x 4 x i8> %val, i8* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg5_mask_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf2,ta,mu
; CHECK-NEXT:    vsseg5e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.mask.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, i8* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg6.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg6.mask.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, i8*, <vscale x 4 x i1>, i32)

define void @test_vsseg6_nxv4i8(<vscale x 4 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg6_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf2,ta,mu
; CHECK-NEXT:    vsseg6e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg6_mask_nxv4i8(<vscale x 4 x i8> %val, i8* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg6_mask_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf2,ta,mu
; CHECK-NEXT:    vsseg6e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.mask.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, i8* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg7.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg7.mask.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, i8*, <vscale x 4 x i1>, i32)

define void @test_vsseg7_nxv4i8(<vscale x 4 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg7_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf2,ta,mu
; CHECK-NEXT:    vsseg7e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg7_mask_nxv4i8(<vscale x 4 x i8> %val, i8* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg7_mask_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf2,ta,mu
; CHECK-NEXT:    vsseg7e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.mask.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, i8* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg8.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg8.mask.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, i8*, <vscale x 4 x i1>, i32)

define void @test_vsseg8_nxv4i8(<vscale x 4 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf2,ta,mu
; CHECK-NEXT:    vsseg8e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg8_mask_nxv4i8(<vscale x 4 x i8> %val, i8* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg8_mask_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf2,ta,mu
; CHECK-NEXT:    vsseg8e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.mask.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, i8* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg2.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>, i16* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>, i16*, <vscale x 1 x i1>, i32)

define void @test_vsseg2_nxv1i16(<vscale x 1 x i16> %val, i16* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg2e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, i16* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv1i16(<vscale x 1 x i16> %val, i16* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg2e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, i16* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg3.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, i16* , i32)
declare void @llvm.riscv.vsseg3.mask.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, i16*, <vscale x 1 x i1>, i32)

define void @test_vsseg3_nxv1i16(<vscale x 1 x i16> %val, i16* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg3_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg3e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, i16* %base, i32 %vl)
  ret void
}

define void @test_vsseg3_mask_nxv1i16(<vscale x 1 x i16> %val, i16* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg3_mask_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg3e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.mask.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, i16* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg4.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, i16* , i32)
declare void @llvm.riscv.vsseg4.mask.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, i16*, <vscale x 1 x i1>, i32)

define void @test_vsseg4_nxv1i16(<vscale x 1 x i16> %val, i16* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg4_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg4e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, i16* %base, i32 %vl)
  ret void
}

define void @test_vsseg4_mask_nxv1i16(<vscale x 1 x i16> %val, i16* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg4_mask_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg4e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.mask.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, i16* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg5.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, i16* , i32)
declare void @llvm.riscv.vsseg5.mask.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, i16*, <vscale x 1 x i1>, i32)

define void @test_vsseg5_nxv1i16(<vscale x 1 x i16> %val, i16* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg5_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg5e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, i16* %base, i32 %vl)
  ret void
}

define void @test_vsseg5_mask_nxv1i16(<vscale x 1 x i16> %val, i16* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg5_mask_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg5e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.mask.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, i16* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg6.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, i16* , i32)
declare void @llvm.riscv.vsseg6.mask.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, i16*, <vscale x 1 x i1>, i32)

define void @test_vsseg6_nxv1i16(<vscale x 1 x i16> %val, i16* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg6_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg6e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, i16* %base, i32 %vl)
  ret void
}

define void @test_vsseg6_mask_nxv1i16(<vscale x 1 x i16> %val, i16* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg6_mask_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg6e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.mask.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, i16* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg7.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, i16* , i32)
declare void @llvm.riscv.vsseg7.mask.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, i16*, <vscale x 1 x i1>, i32)

define void @test_vsseg7_nxv1i16(<vscale x 1 x i16> %val, i16* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg7_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg7e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, i16* %base, i32 %vl)
  ret void
}

define void @test_vsseg7_mask_nxv1i16(<vscale x 1 x i16> %val, i16* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg7_mask_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg7e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.mask.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, i16* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg8.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, i16* , i32)
declare void @llvm.riscv.vsseg8.mask.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, i16*, <vscale x 1 x i1>, i32)

define void @test_vsseg8_nxv1i16(<vscale x 1 x i16> %val, i16* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg8e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, i16* %base, i32 %vl)
  ret void
}

define void @test_vsseg8_mask_nxv1i16(<vscale x 1 x i16> %val, i16* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg8_mask_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg8e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.mask.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, i16* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg2.nxv32i8(<vscale x 32 x i8>,<vscale x 32 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv32i8(<vscale x 32 x i8>,<vscale x 32 x i8>, i8*, <vscale x 32 x i1>, i32)

define void @test_vsseg2_nxv32i8(<vscale x 32 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,m4,ta,mu
; CHECK-NEXT:    vsseg2e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv32i8(<vscale x 32 x i8> %val,<vscale x 32 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv32i8(<vscale x 32 x i8> %val, i8* %base, <vscale x 32 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,m4,ta,mu
; CHECK-NEXT:    vsseg2e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv32i8(<vscale x 32 x i8> %val,<vscale x 32 x i8> %val, i8* %base, <vscale x 32 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg2.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>, i8*, <vscale x 2 x i1>, i32)

define void @test_vsseg2_nxv2i8(<vscale x 2 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf4,ta,mu
; CHECK-NEXT:    vsseg2e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv2i8(<vscale x 2 x i8> %val, i8* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf4,ta,mu
; CHECK-NEXT:    vsseg2e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, i8* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg3.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg3.mask.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, i8*, <vscale x 2 x i1>, i32)

define void @test_vsseg3_nxv2i8(<vscale x 2 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg3_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf4,ta,mu
; CHECK-NEXT:    vsseg3e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg3_mask_nxv2i8(<vscale x 2 x i8> %val, i8* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg3_mask_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf4,ta,mu
; CHECK-NEXT:    vsseg3e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.mask.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, i8* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg4.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg4.mask.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, i8*, <vscale x 2 x i1>, i32)

define void @test_vsseg4_nxv2i8(<vscale x 2 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg4_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf4,ta,mu
; CHECK-NEXT:    vsseg4e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg4_mask_nxv2i8(<vscale x 2 x i8> %val, i8* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg4_mask_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf4,ta,mu
; CHECK-NEXT:    vsseg4e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.mask.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, i8* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg5.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg5.mask.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, i8*, <vscale x 2 x i1>, i32)

define void @test_vsseg5_nxv2i8(<vscale x 2 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg5_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf4,ta,mu
; CHECK-NEXT:    vsseg5e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg5_mask_nxv2i8(<vscale x 2 x i8> %val, i8* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg5_mask_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf4,ta,mu
; CHECK-NEXT:    vsseg5e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.mask.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, i8* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg6.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg6.mask.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, i8*, <vscale x 2 x i1>, i32)

define void @test_vsseg6_nxv2i8(<vscale x 2 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg6_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf4,ta,mu
; CHECK-NEXT:    vsseg6e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg6_mask_nxv2i8(<vscale x 2 x i8> %val, i8* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg6_mask_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf4,ta,mu
; CHECK-NEXT:    vsseg6e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.mask.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, i8* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg7.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg7.mask.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, i8*, <vscale x 2 x i1>, i32)

define void @test_vsseg7_nxv2i8(<vscale x 2 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg7_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf4,ta,mu
; CHECK-NEXT:    vsseg7e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg7_mask_nxv2i8(<vscale x 2 x i8> %val, i8* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg7_mask_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf4,ta,mu
; CHECK-NEXT:    vsseg7e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.mask.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, i8* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg8.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, i8* , i32)
declare void @llvm.riscv.vsseg8.mask.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, i8*, <vscale x 2 x i1>, i32)

define void @test_vsseg8_nxv2i8(<vscale x 2 x i8> %val, i8* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf4,ta,mu
; CHECK-NEXT:    vsseg8e8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, i8* %base, i32 %vl)
  ret void
}

define void @test_vsseg8_mask_nxv2i8(<vscale x 2 x i8> %val, i8* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg8_mask_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e8,mf4,ta,mu
; CHECK-NEXT:    vsseg8e8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.mask.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, i8* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg2.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>, i16* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>, i16*, <vscale x 2 x i1>, i32)

define void @test_vsseg2_nxv2i16(<vscale x 2 x i16> %val, i16* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg2e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, i16* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv2i16(<vscale x 2 x i16> %val, i16* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg2e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, i16* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg3.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, i16* , i32)
declare void @llvm.riscv.vsseg3.mask.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, i16*, <vscale x 2 x i1>, i32)

define void @test_vsseg3_nxv2i16(<vscale x 2 x i16> %val, i16* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg3_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg3e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, i16* %base, i32 %vl)
  ret void
}

define void @test_vsseg3_mask_nxv2i16(<vscale x 2 x i16> %val, i16* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg3_mask_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg3e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.mask.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, i16* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg4.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, i16* , i32)
declare void @llvm.riscv.vsseg4.mask.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, i16*, <vscale x 2 x i1>, i32)

define void @test_vsseg4_nxv2i16(<vscale x 2 x i16> %val, i16* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg4_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg4e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, i16* %base, i32 %vl)
  ret void
}

define void @test_vsseg4_mask_nxv2i16(<vscale x 2 x i16> %val, i16* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg4_mask_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg4e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.mask.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, i16* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg5.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, i16* , i32)
declare void @llvm.riscv.vsseg5.mask.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, i16*, <vscale x 2 x i1>, i32)

define void @test_vsseg5_nxv2i16(<vscale x 2 x i16> %val, i16* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg5_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg5e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, i16* %base, i32 %vl)
  ret void
}

define void @test_vsseg5_mask_nxv2i16(<vscale x 2 x i16> %val, i16* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg5_mask_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg5e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.mask.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, i16* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg6.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, i16* , i32)
declare void @llvm.riscv.vsseg6.mask.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, i16*, <vscale x 2 x i1>, i32)

define void @test_vsseg6_nxv2i16(<vscale x 2 x i16> %val, i16* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg6_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg6e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, i16* %base, i32 %vl)
  ret void
}

define void @test_vsseg6_mask_nxv2i16(<vscale x 2 x i16> %val, i16* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg6_mask_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg6e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.mask.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, i16* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg7.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, i16* , i32)
declare void @llvm.riscv.vsseg7.mask.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, i16*, <vscale x 2 x i1>, i32)

define void @test_vsseg7_nxv2i16(<vscale x 2 x i16> %val, i16* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg7_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg7e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, i16* %base, i32 %vl)
  ret void
}

define void @test_vsseg7_mask_nxv2i16(<vscale x 2 x i16> %val, i16* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg7_mask_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg7e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.mask.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, i16* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg8.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, i16* , i32)
declare void @llvm.riscv.vsseg8.mask.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, i16*, <vscale x 2 x i1>, i32)

define void @test_vsseg8_nxv2i16(<vscale x 2 x i16> %val, i16* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg8e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, i16* %base, i32 %vl)
  ret void
}

define void @test_vsseg8_mask_nxv2i16(<vscale x 2 x i16> %val, i16* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg8_mask_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg8e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.mask.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, i16* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg2.nxv4i32(<vscale x 4 x i32>,<vscale x 4 x i32>, i32* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv4i32(<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 4 x i1>, i32)

define void @test_vsseg2_nxv4i32(<vscale x 4 x i32> %val, i32* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vsseg2e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv4i32(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, i32* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv4i32(<vscale x 4 x i32> %val, i32* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vsseg2e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv4i32(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, i32* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg3.nxv4i32(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32* , i32)
declare void @llvm.riscv.vsseg3.mask.nxv4i32(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 4 x i1>, i32)

define void @test_vsseg3_nxv4i32(<vscale x 4 x i32> %val, i32* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg3_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vsseg3e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.nxv4i32(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, i32* %base, i32 %vl)
  ret void
}

define void @test_vsseg3_mask_nxv4i32(<vscale x 4 x i32> %val, i32* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg3_mask_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vsseg3e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.mask.nxv4i32(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, i32* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg4.nxv4i32(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32* , i32)
declare void @llvm.riscv.vsseg4.mask.nxv4i32(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 4 x i1>, i32)

define void @test_vsseg4_nxv4i32(<vscale x 4 x i32> %val, i32* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg4_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2_v14m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vsseg4e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.nxv4i32(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, i32* %base, i32 %vl)
  ret void
}

define void @test_vsseg4_mask_nxv4i32(<vscale x 4 x i32> %val, i32* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg4_mask_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2_v14m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vsseg4e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.mask.nxv4i32(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, i32* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg2.nxv16f16(<vscale x 16 x half>,<vscale x 16 x half>, half* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv16f16(<vscale x 16 x half>,<vscale x 16 x half>, half*, <vscale x 16 x i1>, i32)

define void @test_vsseg2_nxv16f16(<vscale x 16 x half> %val, half* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv16f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vsseg2e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv16f16(<vscale x 16 x half> %val,<vscale x 16 x half> %val, half* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv16f16(<vscale x 16 x half> %val, half* %base, <vscale x 16 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv16f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vsseg2e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv16f16(<vscale x 16 x half> %val,<vscale x 16 x half> %val, half* %base, <vscale x 16 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg2.nxv4f64(<vscale x 4 x double>,<vscale x 4 x double>, double* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv4f64(<vscale x 4 x double>,<vscale x 4 x double>, double*, <vscale x 4 x i1>, i32)

define void @test_vsseg2_nxv4f64(<vscale x 4 x double> %val, double* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv4f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e64,m4,ta,mu
; CHECK-NEXT:    vsseg2e64.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv4f64(<vscale x 4 x double> %val,<vscale x 4 x double> %val, double* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv4f64(<vscale x 4 x double> %val, double* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv4f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e64,m4,ta,mu
; CHECK-NEXT:    vsseg2e64.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv4f64(<vscale x 4 x double> %val,<vscale x 4 x double> %val, double* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg2.nxv1f64(<vscale x 1 x double>,<vscale x 1 x double>, double* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv1f64(<vscale x 1 x double>,<vscale x 1 x double>, double*, <vscale x 1 x i1>, i32)

define void @test_vsseg2_nxv1f64(<vscale x 1 x double> %val, double* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vsseg2e64.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv1f64(<vscale x 1 x double> %val,<vscale x 1 x double> %val, double* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv1f64(<vscale x 1 x double> %val, double* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vsseg2e64.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv1f64(<vscale x 1 x double> %val,<vscale x 1 x double> %val, double* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg3.nxv1f64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, double* , i32)
declare void @llvm.riscv.vsseg3.mask.nxv1f64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, double*, <vscale x 1 x i1>, i32)

define void @test_vsseg3_nxv1f64(<vscale x 1 x double> %val, double* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg3_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vsseg3e64.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.nxv1f64(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, double* %base, i32 %vl)
  ret void
}

define void @test_vsseg3_mask_nxv1f64(<vscale x 1 x double> %val, double* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg3_mask_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vsseg3e64.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.mask.nxv1f64(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, double* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg4.nxv1f64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, double* , i32)
declare void @llvm.riscv.vsseg4.mask.nxv1f64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, double*, <vscale x 1 x i1>, i32)

define void @test_vsseg4_nxv1f64(<vscale x 1 x double> %val, double* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg4_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vsseg4e64.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.nxv1f64(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, double* %base, i32 %vl)
  ret void
}

define void @test_vsseg4_mask_nxv1f64(<vscale x 1 x double> %val, double* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg4_mask_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vsseg4e64.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.mask.nxv1f64(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, double* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg5.nxv1f64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, double* , i32)
declare void @llvm.riscv.vsseg5.mask.nxv1f64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, double*, <vscale x 1 x i1>, i32)

define void @test_vsseg5_nxv1f64(<vscale x 1 x double> %val, double* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg5_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vsseg5e64.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.nxv1f64(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, double* %base, i32 %vl)
  ret void
}

define void @test_vsseg5_mask_nxv1f64(<vscale x 1 x double> %val, double* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg5_mask_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vsseg5e64.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.mask.nxv1f64(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, double* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg6.nxv1f64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, double* , i32)
declare void @llvm.riscv.vsseg6.mask.nxv1f64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, double*, <vscale x 1 x i1>, i32)

define void @test_vsseg6_nxv1f64(<vscale x 1 x double> %val, double* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg6_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vsseg6e64.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.nxv1f64(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, double* %base, i32 %vl)
  ret void
}

define void @test_vsseg6_mask_nxv1f64(<vscale x 1 x double> %val, double* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg6_mask_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vsseg6e64.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.mask.nxv1f64(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, double* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg7.nxv1f64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, double* , i32)
declare void @llvm.riscv.vsseg7.mask.nxv1f64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, double*, <vscale x 1 x i1>, i32)

define void @test_vsseg7_nxv1f64(<vscale x 1 x double> %val, double* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg7_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vsseg7e64.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.nxv1f64(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, double* %base, i32 %vl)
  ret void
}

define void @test_vsseg7_mask_nxv1f64(<vscale x 1 x double> %val, double* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg7_mask_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vsseg7e64.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.mask.nxv1f64(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, double* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg8.nxv1f64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, double* , i32)
declare void @llvm.riscv.vsseg8.mask.nxv1f64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, double*, <vscale x 1 x i1>, i32)

define void @test_vsseg8_nxv1f64(<vscale x 1 x double> %val, double* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg8_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vsseg8e64.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.nxv1f64(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, double* %base, i32 %vl)
  ret void
}

define void @test_vsseg8_mask_nxv1f64(<vscale x 1 x double> %val, double* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg8_mask_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vsseg8e64.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.mask.nxv1f64(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, double* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg2.nxv2f32(<vscale x 2 x float>,<vscale x 2 x float>, float* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv2f32(<vscale x 2 x float>,<vscale x 2 x float>, float*, <vscale x 2 x i1>, i32)

define void @test_vsseg2_nxv2f32(<vscale x 2 x float> %val, float* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg2e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv2f32(<vscale x 2 x float> %val,<vscale x 2 x float> %val, float* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv2f32(<vscale x 2 x float> %val, float* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg2e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv2f32(<vscale x 2 x float> %val,<vscale x 2 x float> %val, float* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg3.nxv2f32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, float* , i32)
declare void @llvm.riscv.vsseg3.mask.nxv2f32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, float*, <vscale x 2 x i1>, i32)

define void @test_vsseg3_nxv2f32(<vscale x 2 x float> %val, float* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg3_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg3e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.nxv2f32(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, float* %base, i32 %vl)
  ret void
}

define void @test_vsseg3_mask_nxv2f32(<vscale x 2 x float> %val, float* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg3_mask_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg3e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.mask.nxv2f32(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, float* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg4.nxv2f32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, float* , i32)
declare void @llvm.riscv.vsseg4.mask.nxv2f32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, float*, <vscale x 2 x i1>, i32)

define void @test_vsseg4_nxv2f32(<vscale x 2 x float> %val, float* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg4_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg4e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.nxv2f32(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, float* %base, i32 %vl)
  ret void
}

define void @test_vsseg4_mask_nxv2f32(<vscale x 2 x float> %val, float* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg4_mask_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg4e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.mask.nxv2f32(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, float* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg5.nxv2f32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, float* , i32)
declare void @llvm.riscv.vsseg5.mask.nxv2f32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, float*, <vscale x 2 x i1>, i32)

define void @test_vsseg5_nxv2f32(<vscale x 2 x float> %val, float* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg5_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg5e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.nxv2f32(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, float* %base, i32 %vl)
  ret void
}

define void @test_vsseg5_mask_nxv2f32(<vscale x 2 x float> %val, float* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg5_mask_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg5e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.mask.nxv2f32(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, float* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg6.nxv2f32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, float* , i32)
declare void @llvm.riscv.vsseg6.mask.nxv2f32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, float*, <vscale x 2 x i1>, i32)

define void @test_vsseg6_nxv2f32(<vscale x 2 x float> %val, float* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg6_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg6e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.nxv2f32(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, float* %base, i32 %vl)
  ret void
}

define void @test_vsseg6_mask_nxv2f32(<vscale x 2 x float> %val, float* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg6_mask_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg6e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.mask.nxv2f32(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, float* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg7.nxv2f32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, float* , i32)
declare void @llvm.riscv.vsseg7.mask.nxv2f32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, float*, <vscale x 2 x i1>, i32)

define void @test_vsseg7_nxv2f32(<vscale x 2 x float> %val, float* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg7_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg7e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.nxv2f32(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, float* %base, i32 %vl)
  ret void
}

define void @test_vsseg7_mask_nxv2f32(<vscale x 2 x float> %val, float* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg7_mask_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg7e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.mask.nxv2f32(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, float* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg8.nxv2f32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, float* , i32)
declare void @llvm.riscv.vsseg8.mask.nxv2f32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, float*, <vscale x 2 x i1>, i32)

define void @test_vsseg8_nxv2f32(<vscale x 2 x float> %val, float* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg8_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg8e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.nxv2f32(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, float* %base, i32 %vl)
  ret void
}

define void @test_vsseg8_mask_nxv2f32(<vscale x 2 x float> %val, float* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg8_mask_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vsseg8e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.mask.nxv2f32(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, float* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg2.nxv1f16(<vscale x 1 x half>,<vscale x 1 x half>, half* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv1f16(<vscale x 1 x half>,<vscale x 1 x half>, half*, <vscale x 1 x i1>, i32)

define void @test_vsseg2_nxv1f16(<vscale x 1 x half> %val, half* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg2e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv1f16(<vscale x 1 x half> %val,<vscale x 1 x half> %val, half* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv1f16(<vscale x 1 x half> %val, half* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg2e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv1f16(<vscale x 1 x half> %val,<vscale x 1 x half> %val, half* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg3.nxv1f16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, half* , i32)
declare void @llvm.riscv.vsseg3.mask.nxv1f16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, half*, <vscale x 1 x i1>, i32)

define void @test_vsseg3_nxv1f16(<vscale x 1 x half> %val, half* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg3_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg3e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.nxv1f16(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, half* %base, i32 %vl)
  ret void
}

define void @test_vsseg3_mask_nxv1f16(<vscale x 1 x half> %val, half* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg3_mask_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg3e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.mask.nxv1f16(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, half* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg4.nxv1f16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, half* , i32)
declare void @llvm.riscv.vsseg4.mask.nxv1f16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, half*, <vscale x 1 x i1>, i32)

define void @test_vsseg4_nxv1f16(<vscale x 1 x half> %val, half* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg4_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg4e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.nxv1f16(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, half* %base, i32 %vl)
  ret void
}

define void @test_vsseg4_mask_nxv1f16(<vscale x 1 x half> %val, half* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg4_mask_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg4e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.mask.nxv1f16(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, half* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg5.nxv1f16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, half* , i32)
declare void @llvm.riscv.vsseg5.mask.nxv1f16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, half*, <vscale x 1 x i1>, i32)

define void @test_vsseg5_nxv1f16(<vscale x 1 x half> %val, half* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg5_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg5e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.nxv1f16(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, half* %base, i32 %vl)
  ret void
}

define void @test_vsseg5_mask_nxv1f16(<vscale x 1 x half> %val, half* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg5_mask_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg5e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.mask.nxv1f16(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, half* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg6.nxv1f16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, half* , i32)
declare void @llvm.riscv.vsseg6.mask.nxv1f16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, half*, <vscale x 1 x i1>, i32)

define void @test_vsseg6_nxv1f16(<vscale x 1 x half> %val, half* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg6_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg6e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.nxv1f16(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, half* %base, i32 %vl)
  ret void
}

define void @test_vsseg6_mask_nxv1f16(<vscale x 1 x half> %val, half* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg6_mask_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg6e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.mask.nxv1f16(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, half* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg7.nxv1f16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, half* , i32)
declare void @llvm.riscv.vsseg7.mask.nxv1f16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, half*, <vscale x 1 x i1>, i32)

define void @test_vsseg7_nxv1f16(<vscale x 1 x half> %val, half* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg7_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg7e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.nxv1f16(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, half* %base, i32 %vl)
  ret void
}

define void @test_vsseg7_mask_nxv1f16(<vscale x 1 x half> %val, half* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg7_mask_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg7e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.mask.nxv1f16(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, half* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg8.nxv1f16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, half* , i32)
declare void @llvm.riscv.vsseg8.mask.nxv1f16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, half*, <vscale x 1 x i1>, i32)

define void @test_vsseg8_nxv1f16(<vscale x 1 x half> %val, half* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg8_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg8e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.nxv1f16(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, half* %base, i32 %vl)
  ret void
}

define void @test_vsseg8_mask_nxv1f16(<vscale x 1 x half> %val, half* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg8_mask_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf4,ta,mu
; CHECK-NEXT:    vsseg8e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.mask.nxv1f16(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, half* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg2.nxv1f32(<vscale x 1 x float>,<vscale x 1 x float>, float* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv1f32(<vscale x 1 x float>,<vscale x 1 x float>, float*, <vscale x 1 x i1>, i32)

define void @test_vsseg2_nxv1f32(<vscale x 1 x float> %val, float* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg2e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv1f32(<vscale x 1 x float> %val,<vscale x 1 x float> %val, float* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv1f32(<vscale x 1 x float> %val, float* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg2e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv1f32(<vscale x 1 x float> %val,<vscale x 1 x float> %val, float* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg3.nxv1f32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, float* , i32)
declare void @llvm.riscv.vsseg3.mask.nxv1f32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, float*, <vscale x 1 x i1>, i32)

define void @test_vsseg3_nxv1f32(<vscale x 1 x float> %val, float* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg3_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg3e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.nxv1f32(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, float* %base, i32 %vl)
  ret void
}

define void @test_vsseg3_mask_nxv1f32(<vscale x 1 x float> %val, float* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg3_mask_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg3e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.mask.nxv1f32(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, float* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg4.nxv1f32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, float* , i32)
declare void @llvm.riscv.vsseg4.mask.nxv1f32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, float*, <vscale x 1 x i1>, i32)

define void @test_vsseg4_nxv1f32(<vscale x 1 x float> %val, float* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg4_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg4e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.nxv1f32(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, float* %base, i32 %vl)
  ret void
}

define void @test_vsseg4_mask_nxv1f32(<vscale x 1 x float> %val, float* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg4_mask_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg4e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.mask.nxv1f32(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, float* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg5.nxv1f32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, float* , i32)
declare void @llvm.riscv.vsseg5.mask.nxv1f32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, float*, <vscale x 1 x i1>, i32)

define void @test_vsseg5_nxv1f32(<vscale x 1 x float> %val, float* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg5_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg5e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.nxv1f32(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, float* %base, i32 %vl)
  ret void
}

define void @test_vsseg5_mask_nxv1f32(<vscale x 1 x float> %val, float* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg5_mask_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg5e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.mask.nxv1f32(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, float* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg6.nxv1f32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, float* , i32)
declare void @llvm.riscv.vsseg6.mask.nxv1f32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, float*, <vscale x 1 x i1>, i32)

define void @test_vsseg6_nxv1f32(<vscale x 1 x float> %val, float* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg6_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg6e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.nxv1f32(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, float* %base, i32 %vl)
  ret void
}

define void @test_vsseg6_mask_nxv1f32(<vscale x 1 x float> %val, float* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg6_mask_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg6e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.mask.nxv1f32(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, float* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg7.nxv1f32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, float* , i32)
declare void @llvm.riscv.vsseg7.mask.nxv1f32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, float*, <vscale x 1 x i1>, i32)

define void @test_vsseg7_nxv1f32(<vscale x 1 x float> %val, float* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg7_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg7e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.nxv1f32(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, float* %base, i32 %vl)
  ret void
}

define void @test_vsseg7_mask_nxv1f32(<vscale x 1 x float> %val, float* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg7_mask_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg7e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.mask.nxv1f32(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, float* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg8.nxv1f32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, float* , i32)
declare void @llvm.riscv.vsseg8.mask.nxv1f32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, float*, <vscale x 1 x i1>, i32)

define void @test_vsseg8_nxv1f32(<vscale x 1 x float> %val, float* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg8_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg8e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.nxv1f32(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, float* %base, i32 %vl)
  ret void
}

define void @test_vsseg8_mask_nxv1f32(<vscale x 1 x float> %val, float* %base, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg8_mask_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vsseg8e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.mask.nxv1f32(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, float* %base, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg2.nxv8f16(<vscale x 8 x half>,<vscale x 8 x half>, half* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv8f16(<vscale x 8 x half>,<vscale x 8 x half>, half*, <vscale x 8 x i1>, i32)

define void @test_vsseg2_nxv8f16(<vscale x 8 x half> %val, half* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv8f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m2,ta,mu
; CHECK-NEXT:    vsseg2e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv8f16(<vscale x 8 x half> %val,<vscale x 8 x half> %val, half* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv8f16(<vscale x 8 x half> %val, half* %base, <vscale x 8 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv8f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m2,ta,mu
; CHECK-NEXT:    vsseg2e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv8f16(<vscale x 8 x half> %val,<vscale x 8 x half> %val, half* %base, <vscale x 8 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg3.nxv8f16(<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>, half* , i32)
declare void @llvm.riscv.vsseg3.mask.nxv8f16(<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>, half*, <vscale x 8 x i1>, i32)

define void @test_vsseg3_nxv8f16(<vscale x 8 x half> %val, half* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg3_nxv8f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m2,ta,mu
; CHECK-NEXT:    vsseg3e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.nxv8f16(<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val, half* %base, i32 %vl)
  ret void
}

define void @test_vsseg3_mask_nxv8f16(<vscale x 8 x half> %val, half* %base, <vscale x 8 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg3_mask_nxv8f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m2,ta,mu
; CHECK-NEXT:    vsseg3e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.mask.nxv8f16(<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val, half* %base, <vscale x 8 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg4.nxv8f16(<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>, half* , i32)
declare void @llvm.riscv.vsseg4.mask.nxv8f16(<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>, half*, <vscale x 8 x i1>, i32)

define void @test_vsseg4_nxv8f16(<vscale x 8 x half> %val, half* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg4_nxv8f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2_v14m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m2,ta,mu
; CHECK-NEXT:    vsseg4e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.nxv8f16(<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val, half* %base, i32 %vl)
  ret void
}

define void @test_vsseg4_mask_nxv8f16(<vscale x 8 x half> %val, half* %base, <vscale x 8 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg4_mask_nxv8f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2_v14m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m2,ta,mu
; CHECK-NEXT:    vsseg4e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.mask.nxv8f16(<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val, half* %base, <vscale x 8 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg2.nxv8f32(<vscale x 8 x float>,<vscale x 8 x float>, float* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv8f32(<vscale x 8 x float>,<vscale x 8 x float>, float*, <vscale x 8 x i1>, i32)

define void @test_vsseg2_nxv8f32(<vscale x 8 x float> %val, float* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv8f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m4,ta,mu
; CHECK-NEXT:    vsseg2e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv8f32(<vscale x 8 x float> %val,<vscale x 8 x float> %val, float* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv8f32(<vscale x 8 x float> %val, float* %base, <vscale x 8 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv8f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m4,ta,mu
; CHECK-NEXT:    vsseg2e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv8f32(<vscale x 8 x float> %val,<vscale x 8 x float> %val, float* %base, <vscale x 8 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg2.nxv2f64(<vscale x 2 x double>,<vscale x 2 x double>, double* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv2f64(<vscale x 2 x double>,<vscale x 2 x double>, double*, <vscale x 2 x i1>, i32)

define void @test_vsseg2_nxv2f64(<vscale x 2 x double> %val, double* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv2f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e64,m2,ta,mu
; CHECK-NEXT:    vsseg2e64.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv2f64(<vscale x 2 x double> %val,<vscale x 2 x double> %val, double* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv2f64(<vscale x 2 x double> %val, double* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv2f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e64,m2,ta,mu
; CHECK-NEXT:    vsseg2e64.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv2f64(<vscale x 2 x double> %val,<vscale x 2 x double> %val, double* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg3.nxv2f64(<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>, double* , i32)
declare void @llvm.riscv.vsseg3.mask.nxv2f64(<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>, double*, <vscale x 2 x i1>, i32)

define void @test_vsseg3_nxv2f64(<vscale x 2 x double> %val, double* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg3_nxv2f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e64,m2,ta,mu
; CHECK-NEXT:    vsseg3e64.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.nxv2f64(<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val, double* %base, i32 %vl)
  ret void
}

define void @test_vsseg3_mask_nxv2f64(<vscale x 2 x double> %val, double* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg3_mask_nxv2f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e64,m2,ta,mu
; CHECK-NEXT:    vsseg3e64.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.mask.nxv2f64(<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val, double* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg4.nxv2f64(<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>, double* , i32)
declare void @llvm.riscv.vsseg4.mask.nxv2f64(<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>, double*, <vscale x 2 x i1>, i32)

define void @test_vsseg4_nxv2f64(<vscale x 2 x double> %val, double* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg4_nxv2f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2_v14m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e64,m2,ta,mu
; CHECK-NEXT:    vsseg4e64.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.nxv2f64(<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val, double* %base, i32 %vl)
  ret void
}

define void @test_vsseg4_mask_nxv2f64(<vscale x 2 x double> %val, double* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg4_mask_nxv2f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2_v14m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e64,m2,ta,mu
; CHECK-NEXT:    vsseg4e64.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.mask.nxv2f64(<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val, double* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg2.nxv4f16(<vscale x 4 x half>,<vscale x 4 x half>, half* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv4f16(<vscale x 4 x half>,<vscale x 4 x half>, half*, <vscale x 4 x i1>, i32)

define void @test_vsseg2_nxv4f16(<vscale x 4 x half> %val, half* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg2e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv4f16(<vscale x 4 x half> %val,<vscale x 4 x half> %val, half* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv4f16(<vscale x 4 x half> %val, half* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg2e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv4f16(<vscale x 4 x half> %val,<vscale x 4 x half> %val, half* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg3.nxv4f16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, half* , i32)
declare void @llvm.riscv.vsseg3.mask.nxv4f16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, half*, <vscale x 4 x i1>, i32)

define void @test_vsseg3_nxv4f16(<vscale x 4 x half> %val, half* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg3_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg3e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.nxv4f16(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, half* %base, i32 %vl)
  ret void
}

define void @test_vsseg3_mask_nxv4f16(<vscale x 4 x half> %val, half* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg3_mask_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg3e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.mask.nxv4f16(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, half* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg4.nxv4f16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, half* , i32)
declare void @llvm.riscv.vsseg4.mask.nxv4f16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, half*, <vscale x 4 x i1>, i32)

define void @test_vsseg4_nxv4f16(<vscale x 4 x half> %val, half* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg4_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg4e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.nxv4f16(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, half* %base, i32 %vl)
  ret void
}

define void @test_vsseg4_mask_nxv4f16(<vscale x 4 x half> %val, half* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg4_mask_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg4e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.mask.nxv4f16(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, half* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg5.nxv4f16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, half* , i32)
declare void @llvm.riscv.vsseg5.mask.nxv4f16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, half*, <vscale x 4 x i1>, i32)

define void @test_vsseg5_nxv4f16(<vscale x 4 x half> %val, half* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg5_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg5e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.nxv4f16(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, half* %base, i32 %vl)
  ret void
}

define void @test_vsseg5_mask_nxv4f16(<vscale x 4 x half> %val, half* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg5_mask_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg5e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.mask.nxv4f16(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, half* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg6.nxv4f16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, half* , i32)
declare void @llvm.riscv.vsseg6.mask.nxv4f16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, half*, <vscale x 4 x i1>, i32)

define void @test_vsseg6_nxv4f16(<vscale x 4 x half> %val, half* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg6_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg6e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.nxv4f16(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, half* %base, i32 %vl)
  ret void
}

define void @test_vsseg6_mask_nxv4f16(<vscale x 4 x half> %val, half* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg6_mask_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg6e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.mask.nxv4f16(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, half* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg7.nxv4f16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, half* , i32)
declare void @llvm.riscv.vsseg7.mask.nxv4f16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, half*, <vscale x 4 x i1>, i32)

define void @test_vsseg7_nxv4f16(<vscale x 4 x half> %val, half* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg7_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg7e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.nxv4f16(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, half* %base, i32 %vl)
  ret void
}

define void @test_vsseg7_mask_nxv4f16(<vscale x 4 x half> %val, half* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg7_mask_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg7e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.mask.nxv4f16(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, half* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg8.nxv4f16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, half* , i32)
declare void @llvm.riscv.vsseg8.mask.nxv4f16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, half*, <vscale x 4 x i1>, i32)

define void @test_vsseg8_nxv4f16(<vscale x 4 x half> %val, half* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg8_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg8e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.nxv4f16(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, half* %base, i32 %vl)
  ret void
}

define void @test_vsseg8_mask_nxv4f16(<vscale x 4 x half> %val, half* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg8_mask_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vsseg8e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.mask.nxv4f16(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, half* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg2.nxv2f16(<vscale x 2 x half>,<vscale x 2 x half>, half* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv2f16(<vscale x 2 x half>,<vscale x 2 x half>, half*, <vscale x 2 x i1>, i32)

define void @test_vsseg2_nxv2f16(<vscale x 2 x half> %val, half* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg2e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv2f16(<vscale x 2 x half> %val,<vscale x 2 x half> %val, half* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv2f16(<vscale x 2 x half> %val, half* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg2e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv2f16(<vscale x 2 x half> %val,<vscale x 2 x half> %val, half* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg3.nxv2f16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, half* , i32)
declare void @llvm.riscv.vsseg3.mask.nxv2f16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, half*, <vscale x 2 x i1>, i32)

define void @test_vsseg3_nxv2f16(<vscale x 2 x half> %val, half* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg3_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg3e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.nxv2f16(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, half* %base, i32 %vl)
  ret void
}

define void @test_vsseg3_mask_nxv2f16(<vscale x 2 x half> %val, half* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg3_mask_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg3e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.mask.nxv2f16(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, half* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg4.nxv2f16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, half* , i32)
declare void @llvm.riscv.vsseg4.mask.nxv2f16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, half*, <vscale x 2 x i1>, i32)

define void @test_vsseg4_nxv2f16(<vscale x 2 x half> %val, half* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg4_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg4e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.nxv2f16(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, half* %base, i32 %vl)
  ret void
}

define void @test_vsseg4_mask_nxv2f16(<vscale x 2 x half> %val, half* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg4_mask_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg4e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.mask.nxv2f16(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, half* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg5.nxv2f16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, half* , i32)
declare void @llvm.riscv.vsseg5.mask.nxv2f16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, half*, <vscale x 2 x i1>, i32)

define void @test_vsseg5_nxv2f16(<vscale x 2 x half> %val, half* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg5_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg5e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.nxv2f16(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, half* %base, i32 %vl)
  ret void
}

define void @test_vsseg5_mask_nxv2f16(<vscale x 2 x half> %val, half* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg5_mask_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg5e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg5.mask.nxv2f16(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, half* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg6.nxv2f16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, half* , i32)
declare void @llvm.riscv.vsseg6.mask.nxv2f16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, half*, <vscale x 2 x i1>, i32)

define void @test_vsseg6_nxv2f16(<vscale x 2 x half> %val, half* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg6_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg6e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.nxv2f16(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, half* %base, i32 %vl)
  ret void
}

define void @test_vsseg6_mask_nxv2f16(<vscale x 2 x half> %val, half* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg6_mask_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg6e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg6.mask.nxv2f16(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, half* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg7.nxv2f16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, half* , i32)
declare void @llvm.riscv.vsseg7.mask.nxv2f16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, half*, <vscale x 2 x i1>, i32)

define void @test_vsseg7_nxv2f16(<vscale x 2 x half> %val, half* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg7_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg7e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.nxv2f16(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, half* %base, i32 %vl)
  ret void
}

define void @test_vsseg7_mask_nxv2f16(<vscale x 2 x half> %val, half* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg7_mask_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg7e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg7.mask.nxv2f16(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, half* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg8.nxv2f16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, half* , i32)
declare void @llvm.riscv.vsseg8.mask.nxv2f16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, half*, <vscale x 2 x i1>, i32)

define void @test_vsseg8_nxv2f16(<vscale x 2 x half> %val, half* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg8_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg8e16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.nxv2f16(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, half* %base, i32 %vl)
  ret void
}

define void @test_vsseg8_mask_nxv2f16(<vscale x 2 x half> %val, half* %base, <vscale x 2 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg8_mask_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli a1, a1, e16,mf2,ta,mu
; CHECK-NEXT:    vsseg8e16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg8.mask.nxv2f16(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, half* %base, <vscale x 2 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg2.nxv4f32(<vscale x 4 x float>,<vscale x 4 x float>, float* , i32)
declare void @llvm.riscv.vsseg2.mask.nxv4f32(<vscale x 4 x float>,<vscale x 4 x float>, float*, <vscale x 4 x i1>, i32)

define void @test_vsseg2_nxv4f32(<vscale x 4 x float> %val, float* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg2_nxv4f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vsseg2e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.nxv4f32(<vscale x 4 x float> %val,<vscale x 4 x float> %val, float* %base, i32 %vl)
  ret void
}

define void @test_vsseg2_mask_nxv4f32(<vscale x 4 x float> %val, float* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg2_mask_nxv4f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vsseg2e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg2.mask.nxv4f32(<vscale x 4 x float> %val,<vscale x 4 x float> %val, float* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg3.nxv4f32(<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>, float* , i32)
declare void @llvm.riscv.vsseg3.mask.nxv4f32(<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>, float*, <vscale x 4 x i1>, i32)

define void @test_vsseg3_nxv4f32(<vscale x 4 x float> %val, float* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg3_nxv4f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vsseg3e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.nxv4f32(<vscale x 4 x float> %val,<vscale x 4 x float> %val,<vscale x 4 x float> %val, float* %base, i32 %vl)
  ret void
}

define void @test_vsseg3_mask_nxv4f32(<vscale x 4 x float> %val, float* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg3_mask_nxv4f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vsseg3e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg3.mask.nxv4f32(<vscale x 4 x float> %val,<vscale x 4 x float> %val,<vscale x 4 x float> %val, float* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vsseg4.nxv4f32(<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>, float* , i32)
declare void @llvm.riscv.vsseg4.mask.nxv4f32(<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>, float*, <vscale x 4 x i1>, i32)

define void @test_vsseg4_nxv4f32(<vscale x 4 x float> %val, float* %base, i32 %vl) {
; CHECK-LABEL: test_vsseg4_nxv4f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2_v14m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vsseg4e32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.nxv4f32(<vscale x 4 x float> %val,<vscale x 4 x float> %val,<vscale x 4 x float> %val,<vscale x 4 x float> %val, float* %base, i32 %vl)
  ret void
}

define void @test_vsseg4_mask_nxv4f32(<vscale x 4 x float> %val, float* %base, <vscale x 4 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vsseg4_mask_nxv4f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2_v14m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v8
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vsseg4e32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsseg4.mask.nxv4f32(<vscale x 4 x float> %val,<vscale x 4 x float> %val,<vscale x 4 x float> %val,<vscale x 4 x float> %val, float* %base, <vscale x 4 x i1> %mask, i32 %vl)
  ret void
}
