; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -csky-no-aliases < %s -mtriple=csky -float-abi=hard -mattr=+hard-float -mattr=+2e3 -mattr=+fpuv2_sf -mattr=+fpuv2_df | FileCheck %s --check-prefix=CHECK-DF
; RUN: llc -verify-machineinstrs -csky-no-aliases < %s -mtriple=csky -float-abi=hard -mattr=+hard-float -mattr=+2e3 -mattr=+fpuv3_sf -mattr=+fpuv3_df | FileCheck %s --check-prefix=CHECK-DF2

;OEQ
define i32 @brRR_oeq(double %x, double %y) {
;
;
; CHECK-DF-LABEL: brRR_oeq:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    fcmpned vr1, vr0
; CHECK-DF-NEXT:    bt32 .LBB0_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB0_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
;
; CHECK-DF2-LABEL: brRR_oeq:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    fcmpne.64 vr1, vr0
; CHECK-DF2-NEXT:    bt32 .LBB0_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB0_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
entry:
  %fcmp = fcmp oeq double %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_oeq(double %x) {
;
;
; CHECK-DF-LABEL: brRI_oeq:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    grs32 a0, .LCPI1_0
; CHECK-DF-NEXT:    fldd vr1, (a0, 0)
; CHECK-DF-NEXT:    fcmpned vr0, vr1
; CHECK-DF-NEXT:    bt32 .LBB1_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB1_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:    .p2align 1
; CHECK-DF-NEXT:  # %bb.3:
; CHECK-DF-NEXT:    .p2align 2
; CHECK-DF-NEXT:  .LCPI1_0:
; CHECK-DF-NEXT:    .quad 0x4024000000000000 # double 10
;
; CHECK-DF2-LABEL: brRI_oeq:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    flrw.64 vr1, [.LCPI1_0]
; CHECK-DF2-NEXT:    fcmpne.64 vr0, vr1
; CHECK-DF2-NEXT:    bt32 .LBB1_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB1_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:    .p2align 1
; CHECK-DF2-NEXT:  # %bb.3:
; CHECK-DF2-NEXT:    .p2align 2
; CHECK-DF2-NEXT:  .LCPI1_0:
; CHECK-DF2-NEXT:    .quad 0x4024000000000000 # double 10
entry:
  %fcmp = fcmp oeq double %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_oeq(double %x) {
;
;
; CHECK-DF-LABEL: brR0_oeq:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    grs32 a0, .LCPI2_0
; CHECK-DF-NEXT:    fldd vr1, (a0, 0)
; CHECK-DF-NEXT:    fcmpned vr0, vr1
; CHECK-DF-NEXT:    bt32 .LBB2_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB2_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:    .p2align 1
; CHECK-DF-NEXT:  # %bb.3:
; CHECK-DF-NEXT:    .p2align 2
; CHECK-DF-NEXT:  .LCPI2_0:
; CHECK-DF-NEXT:    .quad 0x0000000000000000 # double 0
;
; CHECK-DF2-LABEL: brR0_oeq:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    flrw.64 vr1, [.LCPI2_0]
; CHECK-DF2-NEXT:    fcmpne.64 vr0, vr1
; CHECK-DF2-NEXT:    bt32 .LBB2_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB2_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:    .p2align 1
; CHECK-DF2-NEXT:  # %bb.3:
; CHECK-DF2-NEXT:    .p2align 2
; CHECK-DF2-NEXT:  .LCPI2_0:
; CHECK-DF2-NEXT:    .quad 0x0000000000000000 # double 0
entry:
  %fcmp = fcmp oeq double %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;NE
define i32 @brRR_one(double %x, double %y) {
;
;
; CHECK-DF-LABEL: brRR_one:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    fcmpuod vr1, vr0
; CHECK-DF-NEXT:    mvc32 a0
; CHECK-DF-NEXT:    fcmpned vr1, vr0
; CHECK-DF-NEXT:    mvcv16 a1
; CHECK-DF-NEXT:    or16 a0, a1
; CHECK-DF-NEXT:    btsti32 a0, 0
; CHECK-DF-NEXT:    bt32 .LBB3_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB3_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
;
; CHECK-DF2-LABEL: brRR_one:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    fcmpuo.64 vr1, vr0
; CHECK-DF2-NEXT:    mvc32 a0
; CHECK-DF2-NEXT:    fcmpne.64 vr1, vr0
; CHECK-DF2-NEXT:    mvcv16 a1
; CHECK-DF2-NEXT:    or16 a0, a1
; CHECK-DF2-NEXT:    btsti32 a0, 0
; CHECK-DF2-NEXT:    bt32 .LBB3_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB3_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
entry:
  %fcmp = fcmp one double %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_one(double %x) {
;
;
; CHECK-DF-LABEL: brRI_one:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    grs32 a0, .LCPI4_0
; CHECK-DF-NEXT:    fldd vr1, (a0, 0)
; CHECK-DF-NEXT:    fcmpuod vr0, vr1
; CHECK-DF-NEXT:    mvc32 a0
; CHECK-DF-NEXT:    fcmpned vr0, vr1
; CHECK-DF-NEXT:    mvcv16 a1
; CHECK-DF-NEXT:    or16 a0, a1
; CHECK-DF-NEXT:    btsti32 a0, 0
; CHECK-DF-NEXT:    bt32 .LBB4_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB4_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:    .p2align 1
; CHECK-DF-NEXT:  # %bb.3:
; CHECK-DF-NEXT:    .p2align 2
; CHECK-DF-NEXT:  .LCPI4_0:
; CHECK-DF-NEXT:    .quad 0x4024000000000000 # double 10
;
; CHECK-DF2-LABEL: brRI_one:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    flrw.64 vr1, [.LCPI4_0]
; CHECK-DF2-NEXT:    fcmpuo.64 vr0, vr1
; CHECK-DF2-NEXT:    mvc32 a0
; CHECK-DF2-NEXT:    fcmpne.64 vr0, vr1
; CHECK-DF2-NEXT:    mvcv16 a1
; CHECK-DF2-NEXT:    or16 a0, a1
; CHECK-DF2-NEXT:    btsti32 a0, 0
; CHECK-DF2-NEXT:    bt32 .LBB4_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB4_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:    .p2align 1
; CHECK-DF2-NEXT:  # %bb.3:
; CHECK-DF2-NEXT:    .p2align 2
; CHECK-DF2-NEXT:  .LCPI4_0:
; CHECK-DF2-NEXT:    .quad 0x4024000000000000 # double 10
entry:
  %fcmp = fcmp one double %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_one(double %x) {
;
;
; CHECK-DF-LABEL: brR0_one:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    grs32 a0, .LCPI5_0
; CHECK-DF-NEXT:    fldd vr1, (a0, 0)
; CHECK-DF-NEXT:    fcmpuod vr0, vr1
; CHECK-DF-NEXT:    mvc32 a0
; CHECK-DF-NEXT:    fcmpned vr0, vr1
; CHECK-DF-NEXT:    mvcv16 a1
; CHECK-DF-NEXT:    or16 a0, a1
; CHECK-DF-NEXT:    btsti32 a0, 0
; CHECK-DF-NEXT:    bt32 .LBB5_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB5_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:    .p2align 1
; CHECK-DF-NEXT:  # %bb.3:
; CHECK-DF-NEXT:    .p2align 2
; CHECK-DF-NEXT:  .LCPI5_0:
; CHECK-DF-NEXT:    .quad 0x0000000000000000 # double 0
;
; CHECK-DF2-LABEL: brR0_one:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    flrw.64 vr1, [.LCPI5_0]
; CHECK-DF2-NEXT:    fcmpuo.64 vr0, vr1
; CHECK-DF2-NEXT:    mvc32 a0
; CHECK-DF2-NEXT:    fcmpne.64 vr0, vr1
; CHECK-DF2-NEXT:    mvcv16 a1
; CHECK-DF2-NEXT:    or16 a0, a1
; CHECK-DF2-NEXT:    btsti32 a0, 0
; CHECK-DF2-NEXT:    bt32 .LBB5_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB5_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:    .p2align 1
; CHECK-DF2-NEXT:  # %bb.3:
; CHECK-DF2-NEXT:    .p2align 2
; CHECK-DF2-NEXT:  .LCPI5_0:
; CHECK-DF2-NEXT:    .quad 0x0000000000000000 # double 0
entry:
  %fcmp = fcmp one double %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;UGT
define i32 @brRR_ugt(double %x, double %y) {
;
;
; CHECK-DF-LABEL: brRR_ugt:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    fcmphsd vr0, vr1
; CHECK-DF-NEXT:    bt32 .LBB6_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB6_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
;
; CHECK-DF2-LABEL: brRR_ugt:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    fcmphs.64 vr0, vr1
; CHECK-DF2-NEXT:    bt32 .LBB6_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB6_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
entry:
  %fcmp = fcmp ugt double %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_ugt(double %x) {
;
;
; CHECK-DF-LABEL: brRI_ugt:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    grs32 a0, .LCPI7_0
; CHECK-DF-NEXT:    fldd vr1, (a0, 0)
; CHECK-DF-NEXT:    fcmphsd vr1, vr0
; CHECK-DF-NEXT:    bt32 .LBB7_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB7_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:    .p2align 1
; CHECK-DF-NEXT:  # %bb.3:
; CHECK-DF-NEXT:    .p2align 2
; CHECK-DF-NEXT:  .LCPI7_0:
; CHECK-DF-NEXT:    .quad 0x4024000000000000 # double 10
;
; CHECK-DF2-LABEL: brRI_ugt:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    flrw.64 vr1, [.LCPI7_0]
; CHECK-DF2-NEXT:    fcmphs.64 vr1, vr0
; CHECK-DF2-NEXT:    bt32 .LBB7_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB7_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:    .p2align 1
; CHECK-DF2-NEXT:  # %bb.3:
; CHECK-DF2-NEXT:    .p2align 2
; CHECK-DF2-NEXT:  .LCPI7_0:
; CHECK-DF2-NEXT:    .quad 0x4024000000000000 # double 10
entry:
  %fcmp = fcmp ugt double %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_ugt(double %x) {
;
;
; CHECK-DF-LABEL: brR0_ugt:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    grs32 a0, .LCPI8_0
; CHECK-DF-NEXT:    fldd vr1, (a0, 0)
; CHECK-DF-NEXT:    fcmphsd vr1, vr0
; CHECK-DF-NEXT:    bt32 .LBB8_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB8_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:    .p2align 1
; CHECK-DF-NEXT:  # %bb.3:
; CHECK-DF-NEXT:    .p2align 2
; CHECK-DF-NEXT:  .LCPI8_0:
; CHECK-DF-NEXT:    .quad 0x0000000000000000 # double 0
;
; CHECK-DF2-LABEL: brR0_ugt:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    flrw.64 vr1, [.LCPI8_0]
; CHECK-DF2-NEXT:    fcmphs.64 vr1, vr0
; CHECK-DF2-NEXT:    bt32 .LBB8_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB8_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:    .p2align 1
; CHECK-DF2-NEXT:  # %bb.3:
; CHECK-DF2-NEXT:    .p2align 2
; CHECK-DF2-NEXT:  .LCPI8_0:
; CHECK-DF2-NEXT:    .quad 0x0000000000000000 # double 0
entry:
  %fcmp = fcmp ugt double %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;UGE
define i32 @brRR_uge(double %x, double %y) {
;
;
; CHECK-DF-LABEL: brRR_uge:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    fcmpltd vr1, vr0
; CHECK-DF-NEXT:    bt32 .LBB9_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB9_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
;
; CHECK-DF2-LABEL: brRR_uge:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    fcmplt.64 vr1, vr0
; CHECK-DF2-NEXT:    bt32 .LBB9_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB9_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
entry:
  %fcmp = fcmp uge double %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_uge(double %x) {
;
;
; CHECK-DF-LABEL: brRI_uge:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    grs32 a0, .LCPI10_0
; CHECK-DF-NEXT:    fldd vr1, (a0, 0)
; CHECK-DF-NEXT:    fcmpltd vr0, vr1
; CHECK-DF-NEXT:    bt32 .LBB10_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB10_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:    .p2align 1
; CHECK-DF-NEXT:  # %bb.3:
; CHECK-DF-NEXT:    .p2align 2
; CHECK-DF-NEXT:  .LCPI10_0:
; CHECK-DF-NEXT:    .quad 0x4024000000000000 # double 10
;
; CHECK-DF2-LABEL: brRI_uge:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    flrw.64 vr1, [.LCPI10_0]
; CHECK-DF2-NEXT:    fcmplt.64 vr0, vr1
; CHECK-DF2-NEXT:    bt32 .LBB10_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB10_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:    .p2align 1
; CHECK-DF2-NEXT:  # %bb.3:
; CHECK-DF2-NEXT:    .p2align 2
; CHECK-DF2-NEXT:  .LCPI10_0:
; CHECK-DF2-NEXT:    .quad 0x4024000000000000 # double 10
entry:
  %fcmp = fcmp uge double %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_uge(double %x) {
;
;
; CHECK-DF-LABEL: brR0_uge:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    grs32 a0, .LCPI11_0
; CHECK-DF-NEXT:    fldd vr1, (a0, 0)
; CHECK-DF-NEXT:    fcmpltd vr0, vr1
; CHECK-DF-NEXT:    bt32 .LBB11_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB11_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:    .p2align 1
; CHECK-DF-NEXT:  # %bb.3:
; CHECK-DF-NEXT:    .p2align 2
; CHECK-DF-NEXT:  .LCPI11_0:
; CHECK-DF-NEXT:    .quad 0x0000000000000000 # double 0
;
; CHECK-DF2-LABEL: brR0_uge:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    flrw.64 vr1, [.LCPI11_0]
; CHECK-DF2-NEXT:    fcmplt.64 vr0, vr1
; CHECK-DF2-NEXT:    bt32 .LBB11_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB11_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:    .p2align 1
; CHECK-DF2-NEXT:  # %bb.3:
; CHECK-DF2-NEXT:    .p2align 2
; CHECK-DF2-NEXT:  .LCPI11_0:
; CHECK-DF2-NEXT:    .quad 0x0000000000000000 # double 0
entry:
  %fcmp = fcmp uge double %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;ULT
define i32 @brRR_ult(double %x, double %y) {
;
;
; CHECK-DF-LABEL: brRR_ult:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    fcmphsd vr1, vr0
; CHECK-DF-NEXT:    bt32 .LBB12_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB12_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
;
; CHECK-DF2-LABEL: brRR_ult:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    fcmphs.64 vr1, vr0
; CHECK-DF2-NEXT:    bt32 .LBB12_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB12_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
entry:
  %fcmp = fcmp ult double %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_ult(double %x) {
;
;
; CHECK-DF-LABEL: brRI_ult:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    grs32 a0, .LCPI13_0
; CHECK-DF-NEXT:    fldd vr1, (a0, 0)
; CHECK-DF-NEXT:    fcmphsd vr0, vr1
; CHECK-DF-NEXT:    bt32 .LBB13_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB13_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:    .p2align 1
; CHECK-DF-NEXT:  # %bb.3:
; CHECK-DF-NEXT:    .p2align 2
; CHECK-DF-NEXT:  .LCPI13_0:
; CHECK-DF-NEXT:    .quad 0x4024000000000000 # double 10
;
; CHECK-DF2-LABEL: brRI_ult:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    flrw.64 vr1, [.LCPI13_0]
; CHECK-DF2-NEXT:    fcmphs.64 vr0, vr1
; CHECK-DF2-NEXT:    bt32 .LBB13_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB13_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:    .p2align 1
; CHECK-DF2-NEXT:  # %bb.3:
; CHECK-DF2-NEXT:    .p2align 2
; CHECK-DF2-NEXT:  .LCPI13_0:
; CHECK-DF2-NEXT:    .quad 0x4024000000000000 # double 10
entry:
  %fcmp = fcmp ult double %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_ult(double %x) {
;
;
; CHECK-DF-LABEL: brR0_ult:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    grs32 a0, .LCPI14_0
; CHECK-DF-NEXT:    fldd vr1, (a0, 0)
; CHECK-DF-NEXT:    fcmphsd vr0, vr1
; CHECK-DF-NEXT:    bt32 .LBB14_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB14_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:    .p2align 1
; CHECK-DF-NEXT:  # %bb.3:
; CHECK-DF-NEXT:    .p2align 2
; CHECK-DF-NEXT:  .LCPI14_0:
; CHECK-DF-NEXT:    .quad 0x0000000000000000 # double 0
;
; CHECK-DF2-LABEL: brR0_ult:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    flrw.64 vr1, [.LCPI14_0]
; CHECK-DF2-NEXT:    fcmphs.64 vr0, vr1
; CHECK-DF2-NEXT:    bt32 .LBB14_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB14_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:    .p2align 1
; CHECK-DF2-NEXT:  # %bb.3:
; CHECK-DF2-NEXT:    .p2align 2
; CHECK-DF2-NEXT:  .LCPI14_0:
; CHECK-DF2-NEXT:    .quad 0x0000000000000000 # double 0
entry:
  %fcmp = fcmp ult double %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;ULE
define i32 @brRR_ule(double %x, double %y) {
;
;
; CHECK-DF-LABEL: brRR_ule:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    fcmpltd vr0, vr1
; CHECK-DF-NEXT:    bt32 .LBB15_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB15_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
;
; CHECK-DF2-LABEL: brRR_ule:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    fcmplt.64 vr0, vr1
; CHECK-DF2-NEXT:    bt32 .LBB15_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB15_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
entry:
  %fcmp = fcmp ule double %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_ule(double %x) {
;
;
; CHECK-DF-LABEL: brRI_ule:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    grs32 a0, .LCPI16_0
; CHECK-DF-NEXT:    fldd vr1, (a0, 0)
; CHECK-DF-NEXT:    fcmpltd vr1, vr0
; CHECK-DF-NEXT:    bt32 .LBB16_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB16_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:    .p2align 1
; CHECK-DF-NEXT:  # %bb.3:
; CHECK-DF-NEXT:    .p2align 2
; CHECK-DF-NEXT:  .LCPI16_0:
; CHECK-DF-NEXT:    .quad 0x4024000000000000 # double 10
;
; CHECK-DF2-LABEL: brRI_ule:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    flrw.64 vr1, [.LCPI16_0]
; CHECK-DF2-NEXT:    fcmplt.64 vr1, vr0
; CHECK-DF2-NEXT:    bt32 .LBB16_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB16_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:    .p2align 1
; CHECK-DF2-NEXT:  # %bb.3:
; CHECK-DF2-NEXT:    .p2align 2
; CHECK-DF2-NEXT:  .LCPI16_0:
; CHECK-DF2-NEXT:    .quad 0x4024000000000000 # double 10
entry:
  %fcmp = fcmp ule double %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_ule(double %x) {
;
;
; CHECK-DF-LABEL: brR0_ule:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    grs32 a0, .LCPI17_0
; CHECK-DF-NEXT:    fldd vr1, (a0, 0)
; CHECK-DF-NEXT:    fcmpltd vr1, vr0
; CHECK-DF-NEXT:    bt32 .LBB17_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB17_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:    .p2align 1
; CHECK-DF-NEXT:  # %bb.3:
; CHECK-DF-NEXT:    .p2align 2
; CHECK-DF-NEXT:  .LCPI17_0:
; CHECK-DF-NEXT:    .quad 0x0000000000000000 # double 0
;
; CHECK-DF2-LABEL: brR0_ule:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    flrw.64 vr1, [.LCPI17_0]
; CHECK-DF2-NEXT:    fcmplt.64 vr1, vr0
; CHECK-DF2-NEXT:    bt32 .LBB17_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB17_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:    .p2align 1
; CHECK-DF2-NEXT:  # %bb.3:
; CHECK-DF2-NEXT:    .p2align 2
; CHECK-DF2-NEXT:  .LCPI17_0:
; CHECK-DF2-NEXT:    .quad 0x0000000000000000 # double 0
entry:
  %fcmp = fcmp ule double %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;SGT
define i32 @brRR_ogt(double %x, double %y) {
;
;
; CHECK-DF-LABEL: brRR_ogt:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    fcmpltd vr0, vr1
; CHECK-DF-NEXT:    mvc32 a0
; CHECK-DF-NEXT:    xori32 a0, a0, 1
; CHECK-DF-NEXT:    btsti32 a0, 0
; CHECK-DF-NEXT:    bt32 .LBB18_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB18_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
;
; CHECK-DF2-LABEL: brRR_ogt:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    fcmplt.64 vr0, vr1
; CHECK-DF2-NEXT:    mvc32 a0
; CHECK-DF2-NEXT:    xori32 a0, a0, 1
; CHECK-DF2-NEXT:    btsti32 a0, 0
; CHECK-DF2-NEXT:    bt32 .LBB18_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB18_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
entry:
  %fcmp = fcmp ogt double %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_ogt(double %x) {
;
;
; CHECK-DF-LABEL: brRI_ogt:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    grs32 a0, .LCPI19_0
; CHECK-DF-NEXT:    fldd vr1, (a0, 0)
; CHECK-DF-NEXT:    fcmpltd vr1, vr0
; CHECK-DF-NEXT:    mvc32 a0
; CHECK-DF-NEXT:    xori32 a0, a0, 1
; CHECK-DF-NEXT:    btsti32 a0, 0
; CHECK-DF-NEXT:    bt32 .LBB19_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB19_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:    .p2align 1
; CHECK-DF-NEXT:  # %bb.3:
; CHECK-DF-NEXT:    .p2align 2
; CHECK-DF-NEXT:  .LCPI19_0:
; CHECK-DF-NEXT:    .quad 0x4024000000000000 # double 10
;
; CHECK-DF2-LABEL: brRI_ogt:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    flrw.64 vr1, [.LCPI19_0]
; CHECK-DF2-NEXT:    fcmplt.64 vr1, vr0
; CHECK-DF2-NEXT:    mvc32 a0
; CHECK-DF2-NEXT:    xori32 a0, a0, 1
; CHECK-DF2-NEXT:    btsti32 a0, 0
; CHECK-DF2-NEXT:    bt32 .LBB19_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB19_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:    .p2align 1
; CHECK-DF2-NEXT:  # %bb.3:
; CHECK-DF2-NEXT:    .p2align 2
; CHECK-DF2-NEXT:  .LCPI19_0:
; CHECK-DF2-NEXT:    .quad 0x4024000000000000 # double 10
entry:
  %fcmp = fcmp ogt double %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_ogt(double %x) {
;
;
; CHECK-DF-LABEL: brR0_ogt:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    grs32 a0, .LCPI20_0
; CHECK-DF-NEXT:    fldd vr1, (a0, 0)
; CHECK-DF-NEXT:    fcmpltd vr1, vr0
; CHECK-DF-NEXT:    mvc32 a0
; CHECK-DF-NEXT:    xori32 a0, a0, 1
; CHECK-DF-NEXT:    btsti32 a0, 0
; CHECK-DF-NEXT:    bt32 .LBB20_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB20_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:    .p2align 1
; CHECK-DF-NEXT:  # %bb.3:
; CHECK-DF-NEXT:    .p2align 2
; CHECK-DF-NEXT:  .LCPI20_0:
; CHECK-DF-NEXT:    .quad 0x0000000000000000 # double 0
;
; CHECK-DF2-LABEL: brR0_ogt:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    flrw.64 vr1, [.LCPI20_0]
; CHECK-DF2-NEXT:    fcmplt.64 vr1, vr0
; CHECK-DF2-NEXT:    mvc32 a0
; CHECK-DF2-NEXT:    xori32 a0, a0, 1
; CHECK-DF2-NEXT:    btsti32 a0, 0
; CHECK-DF2-NEXT:    bt32 .LBB20_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB20_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:    .p2align 1
; CHECK-DF2-NEXT:  # %bb.3:
; CHECK-DF2-NEXT:    .p2align 2
; CHECK-DF2-NEXT:  .LCPI20_0:
; CHECK-DF2-NEXT:    .quad 0x0000000000000000 # double 0
entry:
  %fcmp = fcmp ogt double %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;SGE
define i32 @brRR_oge(double %x, double %y) {
;
;
; CHECK-DF-LABEL: brRR_oge:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    fcmphsd vr1, vr0
; CHECK-DF-NEXT:    mvc32 a0
; CHECK-DF-NEXT:    xori32 a0, a0, 1
; CHECK-DF-NEXT:    btsti32 a0, 0
; CHECK-DF-NEXT:    bt32 .LBB21_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB21_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
;
; CHECK-DF2-LABEL: brRR_oge:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    fcmphs.64 vr1, vr0
; CHECK-DF2-NEXT:    mvc32 a0
; CHECK-DF2-NEXT:    xori32 a0, a0, 1
; CHECK-DF2-NEXT:    btsti32 a0, 0
; CHECK-DF2-NEXT:    bt32 .LBB21_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB21_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
entry:
  %fcmp = fcmp oge double %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_oge(double %x) {
;
;
; CHECK-DF-LABEL: brRI_oge:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    grs32 a0, .LCPI22_0
; CHECK-DF-NEXT:    fldd vr1, (a0, 0)
; CHECK-DF-NEXT:    fcmphsd vr0, vr1
; CHECK-DF-NEXT:    mvc32 a0
; CHECK-DF-NEXT:    xori32 a0, a0, 1
; CHECK-DF-NEXT:    btsti32 a0, 0
; CHECK-DF-NEXT:    bt32 .LBB22_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB22_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:    .p2align 1
; CHECK-DF-NEXT:  # %bb.3:
; CHECK-DF-NEXT:    .p2align 2
; CHECK-DF-NEXT:  .LCPI22_0:
; CHECK-DF-NEXT:    .quad 0x4024000000000000 # double 10
;
; CHECK-DF2-LABEL: brRI_oge:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    flrw.64 vr1, [.LCPI22_0]
; CHECK-DF2-NEXT:    fcmphs.64 vr0, vr1
; CHECK-DF2-NEXT:    mvc32 a0
; CHECK-DF2-NEXT:    xori32 a0, a0, 1
; CHECK-DF2-NEXT:    btsti32 a0, 0
; CHECK-DF2-NEXT:    bt32 .LBB22_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB22_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:    .p2align 1
; CHECK-DF2-NEXT:  # %bb.3:
; CHECK-DF2-NEXT:    .p2align 2
; CHECK-DF2-NEXT:  .LCPI22_0:
; CHECK-DF2-NEXT:    .quad 0x4024000000000000 # double 10
entry:
  %fcmp = fcmp oge double %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_oge(double %x) {
;
;
; CHECK-DF-LABEL: brR0_oge:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    grs32 a0, .LCPI23_0
; CHECK-DF-NEXT:    fldd vr1, (a0, 0)
; CHECK-DF-NEXT:    fcmphsd vr0, vr1
; CHECK-DF-NEXT:    mvc32 a0
; CHECK-DF-NEXT:    xori32 a0, a0, 1
; CHECK-DF-NEXT:    btsti32 a0, 0
; CHECK-DF-NEXT:    bt32 .LBB23_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB23_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:    .p2align 1
; CHECK-DF-NEXT:  # %bb.3:
; CHECK-DF-NEXT:    .p2align 2
; CHECK-DF-NEXT:  .LCPI23_0:
; CHECK-DF-NEXT:    .quad 0x0000000000000000 # double 0
;
; CHECK-DF2-LABEL: brR0_oge:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    flrw.64 vr1, [.LCPI23_0]
; CHECK-DF2-NEXT:    fcmphs.64 vr0, vr1
; CHECK-DF2-NEXT:    mvc32 a0
; CHECK-DF2-NEXT:    xori32 a0, a0, 1
; CHECK-DF2-NEXT:    btsti32 a0, 0
; CHECK-DF2-NEXT:    bt32 .LBB23_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB23_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:    .p2align 1
; CHECK-DF2-NEXT:  # %bb.3:
; CHECK-DF2-NEXT:    .p2align 2
; CHECK-DF2-NEXT:  .LCPI23_0:
; CHECK-DF2-NEXT:    .quad 0x0000000000000000 # double 0
entry:
  %fcmp = fcmp oge double %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;SLT
define i32 @brRR_olt(double %x, double %y) {
;
;
; CHECK-DF-LABEL: brRR_olt:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    fcmpltd vr1, vr0
; CHECK-DF-NEXT:    mvc32 a0
; CHECK-DF-NEXT:    xori32 a0, a0, 1
; CHECK-DF-NEXT:    btsti32 a0, 0
; CHECK-DF-NEXT:    bt32 .LBB24_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB24_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
;
; CHECK-DF2-LABEL: brRR_olt:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    fcmplt.64 vr1, vr0
; CHECK-DF2-NEXT:    mvc32 a0
; CHECK-DF2-NEXT:    xori32 a0, a0, 1
; CHECK-DF2-NEXT:    btsti32 a0, 0
; CHECK-DF2-NEXT:    bt32 .LBB24_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB24_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
entry:
  %fcmp = fcmp olt double %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_olt(double %x) {
;
;
; CHECK-DF-LABEL: brRI_olt:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    grs32 a0, .LCPI25_0
; CHECK-DF-NEXT:    fldd vr1, (a0, 0)
; CHECK-DF-NEXT:    fcmpltd vr0, vr1
; CHECK-DF-NEXT:    mvc32 a0
; CHECK-DF-NEXT:    xori32 a0, a0, 1
; CHECK-DF-NEXT:    btsti32 a0, 0
; CHECK-DF-NEXT:    bt32 .LBB25_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB25_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:    .p2align 1
; CHECK-DF-NEXT:  # %bb.3:
; CHECK-DF-NEXT:    .p2align 2
; CHECK-DF-NEXT:  .LCPI25_0:
; CHECK-DF-NEXT:    .quad 0x4024000000000000 # double 10
;
; CHECK-DF2-LABEL: brRI_olt:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    flrw.64 vr1, [.LCPI25_0]
; CHECK-DF2-NEXT:    fcmplt.64 vr0, vr1
; CHECK-DF2-NEXT:    mvc32 a0
; CHECK-DF2-NEXT:    xori32 a0, a0, 1
; CHECK-DF2-NEXT:    btsti32 a0, 0
; CHECK-DF2-NEXT:    bt32 .LBB25_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB25_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:    .p2align 1
; CHECK-DF2-NEXT:  # %bb.3:
; CHECK-DF2-NEXT:    .p2align 2
; CHECK-DF2-NEXT:  .LCPI25_0:
; CHECK-DF2-NEXT:    .quad 0x4024000000000000 # double 10
entry:
  %fcmp = fcmp olt double %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_olt(double %x) {
;
;
; CHECK-DF-LABEL: brR0_olt:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    grs32 a0, .LCPI26_0
; CHECK-DF-NEXT:    fldd vr1, (a0, 0)
; CHECK-DF-NEXT:    fcmpltd vr0, vr1
; CHECK-DF-NEXT:    mvc32 a0
; CHECK-DF-NEXT:    xori32 a0, a0, 1
; CHECK-DF-NEXT:    btsti32 a0, 0
; CHECK-DF-NEXT:    bt32 .LBB26_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB26_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:    .p2align 1
; CHECK-DF-NEXT:  # %bb.3:
; CHECK-DF-NEXT:    .p2align 2
; CHECK-DF-NEXT:  .LCPI26_0:
; CHECK-DF-NEXT:    .quad 0x0000000000000000 # double 0
;
; CHECK-DF2-LABEL: brR0_olt:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    flrw.64 vr1, [.LCPI26_0]
; CHECK-DF2-NEXT:    fcmplt.64 vr0, vr1
; CHECK-DF2-NEXT:    mvc32 a0
; CHECK-DF2-NEXT:    xori32 a0, a0, 1
; CHECK-DF2-NEXT:    btsti32 a0, 0
; CHECK-DF2-NEXT:    bt32 .LBB26_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB26_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:    .p2align 1
; CHECK-DF2-NEXT:  # %bb.3:
; CHECK-DF2-NEXT:    .p2align 2
; CHECK-DF2-NEXT:  .LCPI26_0:
; CHECK-DF2-NEXT:    .quad 0x0000000000000000 # double 0
entry:
  %fcmp = fcmp olt double %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;SLE
define i32 @brRR_ole(double %x, double %y) {
;
;
; CHECK-DF-LABEL: brRR_ole:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    fcmphsd vr0, vr1
; CHECK-DF-NEXT:    mvc32 a0
; CHECK-DF-NEXT:    xori32 a0, a0, 1
; CHECK-DF-NEXT:    btsti32 a0, 0
; CHECK-DF-NEXT:    bt32 .LBB27_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB27_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
;
; CHECK-DF2-LABEL: brRR_ole:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    fcmphs.64 vr0, vr1
; CHECK-DF2-NEXT:    mvc32 a0
; CHECK-DF2-NEXT:    xori32 a0, a0, 1
; CHECK-DF2-NEXT:    btsti32 a0, 0
; CHECK-DF2-NEXT:    bt32 .LBB27_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB27_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
entry:
  %fcmp = fcmp ole double %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_ole(double %x) {
;
;
; CHECK-DF-LABEL: brRI_ole:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    grs32 a0, .LCPI28_0
; CHECK-DF-NEXT:    fldd vr1, (a0, 0)
; CHECK-DF-NEXT:    fcmphsd vr1, vr0
; CHECK-DF-NEXT:    mvc32 a0
; CHECK-DF-NEXT:    xori32 a0, a0, 1
; CHECK-DF-NEXT:    btsti32 a0, 0
; CHECK-DF-NEXT:    bt32 .LBB28_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB28_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:    .p2align 1
; CHECK-DF-NEXT:  # %bb.3:
; CHECK-DF-NEXT:    .p2align 2
; CHECK-DF-NEXT:  .LCPI28_0:
; CHECK-DF-NEXT:    .quad 0x4024000000000000 # double 10
;
; CHECK-DF2-LABEL: brRI_ole:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    flrw.64 vr1, [.LCPI28_0]
; CHECK-DF2-NEXT:    fcmphs.64 vr1, vr0
; CHECK-DF2-NEXT:    mvc32 a0
; CHECK-DF2-NEXT:    xori32 a0, a0, 1
; CHECK-DF2-NEXT:    btsti32 a0, 0
; CHECK-DF2-NEXT:    bt32 .LBB28_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB28_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:    .p2align 1
; CHECK-DF2-NEXT:  # %bb.3:
; CHECK-DF2-NEXT:    .p2align 2
; CHECK-DF2-NEXT:  .LCPI28_0:
; CHECK-DF2-NEXT:    .quad 0x4024000000000000 # double 10
entry:
  %fcmp = fcmp ole double %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_ole(double %x) {
;
;
; CHECK-DF-LABEL: brR0_ole:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    grs32 a0, .LCPI29_0
; CHECK-DF-NEXT:    fldd vr1, (a0, 0)
; CHECK-DF-NEXT:    fcmphsd vr1, vr0
; CHECK-DF-NEXT:    mvc32 a0
; CHECK-DF-NEXT:    xori32 a0, a0, 1
; CHECK-DF-NEXT:    btsti32 a0, 0
; CHECK-DF-NEXT:    bt32 .LBB29_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB29_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:    .p2align 1
; CHECK-DF-NEXT:  # %bb.3:
; CHECK-DF-NEXT:    .p2align 2
; CHECK-DF-NEXT:  .LCPI29_0:
; CHECK-DF-NEXT:    .quad 0x0000000000000000 # double 0
;
; CHECK-DF2-LABEL: brR0_ole:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    flrw.64 vr1, [.LCPI29_0]
; CHECK-DF2-NEXT:    fcmphs.64 vr1, vr0
; CHECK-DF2-NEXT:    mvc32 a0
; CHECK-DF2-NEXT:    xori32 a0, a0, 1
; CHECK-DF2-NEXT:    btsti32 a0, 0
; CHECK-DF2-NEXT:    bt32 .LBB29_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB29_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:    .p2align 1
; CHECK-DF2-NEXT:  # %bb.3:
; CHECK-DF2-NEXT:    .p2align 2
; CHECK-DF2-NEXT:  .LCPI29_0:
; CHECK-DF2-NEXT:    .quad 0x0000000000000000 # double 0
entry:
  %fcmp = fcmp ole double %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;False
define i32 @brRR_false(double %x, double %y) {
;
;
; CHECK-DF-LABEL: brRR_false:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    btsti32 a0, 0
; CHECK-DF-NEXT:    bt32 .LBB30_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB30_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
;
; CHECK-DF2-LABEL: brRR_false:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    btsti32 a0, 0
; CHECK-DF2-NEXT:    bt32 .LBB30_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB30_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
entry:
  %fcmp = fcmp false double %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_false(double %x) {
;
;
; CHECK-DF-LABEL: brRI_false:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    btsti32 a0, 0
; CHECK-DF-NEXT:    bt32 .LBB31_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB31_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
;
; CHECK-DF2-LABEL: brRI_false:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    btsti32 a0, 0
; CHECK-DF2-NEXT:    bt32 .LBB31_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB31_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
entry:
  %fcmp = fcmp false double %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_false(double %x) {
;
;
; CHECK-DF-LABEL: brR0_false:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    btsti32 a0, 0
; CHECK-DF-NEXT:    bt32 .LBB32_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB32_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
;
; CHECK-DF2-LABEL: brR0_false:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    btsti32 a0, 0
; CHECK-DF2-NEXT:    bt32 .LBB32_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB32_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
entry:
  %fcmp = fcmp false double %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}


;ORD
define i32 @brRR_ord(double %x, double %y) {
;
;
; CHECK-DF-LABEL: brRR_ord:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    fcmpuod vr1, vr0
; CHECK-DF-NEXT:    bt32 .LBB33_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB33_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
;
; CHECK-DF2-LABEL: brRR_ord:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    fcmpuo.64 vr1, vr0
; CHECK-DF2-NEXT:    bt32 .LBB33_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB33_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
entry:
  %fcmp = fcmp ord double %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_ord(double %x) {
;
;
; CHECK-DF-LABEL: brRI_ord:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    fcmpuod vr0, vr0
; CHECK-DF-NEXT:    bt32 .LBB34_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB34_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
;
; CHECK-DF2-LABEL: brRI_ord:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    fcmpuo.64 vr0, vr0
; CHECK-DF2-NEXT:    bt32 .LBB34_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB34_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
entry:
  %fcmp = fcmp ord double %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_ord(double %x) {
;
;
; CHECK-DF-LABEL: brR0_ord:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    fcmpuod vr0, vr0
; CHECK-DF-NEXT:    bt32 .LBB35_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB35_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
;
; CHECK-DF2-LABEL: brR0_ord:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    fcmpuo.64 vr0, vr0
; CHECK-DF2-NEXT:    bt32 .LBB35_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB35_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
entry:
  %fcmp = fcmp ord double %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}


;UEQ
define i32 @brRR_ueq(double %x, double %y) {
;
;
; CHECK-DF-LABEL: brRR_ueq:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    fcmpuod vr1, vr0
; CHECK-DF-NEXT:    mvcv16 a0
; CHECK-DF-NEXT:    fcmpned vr1, vr0
; CHECK-DF-NEXT:    mvc32 a1
; CHECK-DF-NEXT:    and16 a0, a1
; CHECK-DF-NEXT:    btsti32 a0, 0
; CHECK-DF-NEXT:    bf32 .LBB36_2
; CHECK-DF-NEXT:  # %bb.1: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB36_2: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
;
; CHECK-DF2-LABEL: brRR_ueq:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    fcmpuo.64 vr1, vr0
; CHECK-DF2-NEXT:    mvcv16 a0
; CHECK-DF2-NEXT:    fcmpne.64 vr1, vr0
; CHECK-DF2-NEXT:    mvc32 a1
; CHECK-DF2-NEXT:    and16 a0, a1
; CHECK-DF2-NEXT:    btsti32 a0, 0
; CHECK-DF2-NEXT:    bf32 .LBB36_2
; CHECK-DF2-NEXT:  # %bb.1: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB36_2: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
entry:
  %fcmp = fcmp ueq double %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_ueq(double %x) {
;
;
; CHECK-DF-LABEL: brRI_ueq:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    grs32 a0, .LCPI37_0
; CHECK-DF-NEXT:    fldd vr1, (a0, 0)
; CHECK-DF-NEXT:    fcmpuod vr0, vr1
; CHECK-DF-NEXT:    mvcv16 a0
; CHECK-DF-NEXT:    fcmpned vr0, vr1
; CHECK-DF-NEXT:    mvc32 a1
; CHECK-DF-NEXT:    and16 a0, a1
; CHECK-DF-NEXT:    btsti32 a0, 0
; CHECK-DF-NEXT:    bf32 .LBB37_2
; CHECK-DF-NEXT:  # %bb.1: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB37_2: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:    .p2align 1
; CHECK-DF-NEXT:  # %bb.3:
; CHECK-DF-NEXT:    .p2align 2
; CHECK-DF-NEXT:  .LCPI37_0:
; CHECK-DF-NEXT:    .quad 0x4024000000000000 # double 10
;
; CHECK-DF2-LABEL: brRI_ueq:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    flrw.64 vr1, [.LCPI37_0]
; CHECK-DF2-NEXT:    fcmpuo.64 vr0, vr1
; CHECK-DF2-NEXT:    mvcv16 a0
; CHECK-DF2-NEXT:    fcmpne.64 vr0, vr1
; CHECK-DF2-NEXT:    mvc32 a1
; CHECK-DF2-NEXT:    and16 a0, a1
; CHECK-DF2-NEXT:    btsti32 a0, 0
; CHECK-DF2-NEXT:    bf32 .LBB37_2
; CHECK-DF2-NEXT:  # %bb.1: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB37_2: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:    .p2align 1
; CHECK-DF2-NEXT:  # %bb.3:
; CHECK-DF2-NEXT:    .p2align 2
; CHECK-DF2-NEXT:  .LCPI37_0:
; CHECK-DF2-NEXT:    .quad 0x4024000000000000 # double 10
entry:
  %fcmp = fcmp ueq double %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_ueq(double %x) {
;
;
; CHECK-DF-LABEL: brR0_ueq:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    grs32 a0, .LCPI38_0
; CHECK-DF-NEXT:    fldd vr1, (a0, 0)
; CHECK-DF-NEXT:    fcmpuod vr0, vr1
; CHECK-DF-NEXT:    mvcv16 a0
; CHECK-DF-NEXT:    fcmpned vr0, vr1
; CHECK-DF-NEXT:    mvc32 a1
; CHECK-DF-NEXT:    and16 a0, a1
; CHECK-DF-NEXT:    btsti32 a0, 0
; CHECK-DF-NEXT:    bf32 .LBB38_2
; CHECK-DF-NEXT:  # %bb.1: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB38_2: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:    .p2align 1
; CHECK-DF-NEXT:  # %bb.3:
; CHECK-DF-NEXT:    .p2align 2
; CHECK-DF-NEXT:  .LCPI38_0:
; CHECK-DF-NEXT:    .quad 0x0000000000000000 # double 0
;
; CHECK-DF2-LABEL: brR0_ueq:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    flrw.64 vr1, [.LCPI38_0]
; CHECK-DF2-NEXT:    fcmpuo.64 vr0, vr1
; CHECK-DF2-NEXT:    mvcv16 a0
; CHECK-DF2-NEXT:    fcmpne.64 vr0, vr1
; CHECK-DF2-NEXT:    mvc32 a1
; CHECK-DF2-NEXT:    and16 a0, a1
; CHECK-DF2-NEXT:    btsti32 a0, 0
; CHECK-DF2-NEXT:    bf32 .LBB38_2
; CHECK-DF2-NEXT:  # %bb.1: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB38_2: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:    .p2align 1
; CHECK-DF2-NEXT:  # %bb.3:
; CHECK-DF2-NEXT:    .p2align 2
; CHECK-DF2-NEXT:  .LCPI38_0:
; CHECK-DF2-NEXT:    .quad 0x0000000000000000 # double 0
entry:
  %fcmp = fcmp ueq double %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;UNE
define i32 @brRR_une(double %x, double %y) {
;
;
; CHECK-DF-LABEL: brRR_une:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    fcmpned vr1, vr0
; CHECK-DF-NEXT:    bf32 .LBB39_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB39_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
;
; CHECK-DF2-LABEL: brRR_une:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    fcmpne.64 vr1, vr0
; CHECK-DF2-NEXT:    bf32 .LBB39_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB39_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
entry:
  %fcmp = fcmp une double %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_une(double %x) {
;
;
; CHECK-DF-LABEL: brRI_une:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    grs32 a0, .LCPI40_0
; CHECK-DF-NEXT:    fldd vr1, (a0, 0)
; CHECK-DF-NEXT:    fcmpned vr0, vr1
; CHECK-DF-NEXT:    bf32 .LBB40_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB40_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:    .p2align 1
; CHECK-DF-NEXT:  # %bb.3:
; CHECK-DF-NEXT:    .p2align 2
; CHECK-DF-NEXT:  .LCPI40_0:
; CHECK-DF-NEXT:    .quad 0x4024000000000000 # double 10
;
; CHECK-DF2-LABEL: brRI_une:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    flrw.64 vr1, [.LCPI40_0]
; CHECK-DF2-NEXT:    fcmpne.64 vr0, vr1
; CHECK-DF2-NEXT:    bf32 .LBB40_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB40_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:    .p2align 1
; CHECK-DF2-NEXT:  # %bb.3:
; CHECK-DF2-NEXT:    .p2align 2
; CHECK-DF2-NEXT:  .LCPI40_0:
; CHECK-DF2-NEXT:    .quad 0x4024000000000000 # double 10
entry:
  %fcmp = fcmp une double %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_une(double %x) {
;
;
; CHECK-DF-LABEL: brR0_une:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    grs32 a0, .LCPI41_0
; CHECK-DF-NEXT:    fldd vr1, (a0, 0)
; CHECK-DF-NEXT:    fcmpned vr0, vr1
; CHECK-DF-NEXT:    bf32 .LBB41_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB41_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:    .p2align 1
; CHECK-DF-NEXT:  # %bb.3:
; CHECK-DF-NEXT:    .p2align 2
; CHECK-DF-NEXT:  .LCPI41_0:
; CHECK-DF-NEXT:    .quad 0x0000000000000000 # double 0
;
; CHECK-DF2-LABEL: brR0_une:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    flrw.64 vr1, [.LCPI41_0]
; CHECK-DF2-NEXT:    fcmpne.64 vr0, vr1
; CHECK-DF2-NEXT:    bf32 .LBB41_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB41_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:    .p2align 1
; CHECK-DF2-NEXT:  # %bb.3:
; CHECK-DF2-NEXT:    .p2align 2
; CHECK-DF2-NEXT:  .LCPI41_0:
; CHECK-DF2-NEXT:    .quad 0x0000000000000000 # double 0
entry:
  %fcmp = fcmp une double %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;UNO
define i32 @brRR_uno(double %x, double %y) {
;
;
; CHECK-DF-LABEL: brRR_uno:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    fcmpuod vr1, vr0
; CHECK-DF-NEXT:    bt32 .LBB42_2
; CHECK-DF-NEXT:  # %bb.1: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB42_2: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
;
; CHECK-DF2-LABEL: brRR_uno:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    fcmpuo.64 vr1, vr0
; CHECK-DF2-NEXT:    bt32 .LBB42_2
; CHECK-DF2-NEXT:  # %bb.1: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB42_2: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
entry:
  %fcmp = fcmp uno double %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_uno(double %x) {
;
;
; CHECK-DF-LABEL: brRI_uno:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    fcmpuod vr0, vr0
; CHECK-DF-NEXT:    bt32 .LBB43_2
; CHECK-DF-NEXT:  # %bb.1: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB43_2: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
;
; CHECK-DF2-LABEL: brRI_uno:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    fcmpuo.64 vr0, vr0
; CHECK-DF2-NEXT:    bt32 .LBB43_2
; CHECK-DF2-NEXT:  # %bb.1: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB43_2: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
entry:
  %fcmp = fcmp uno double %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_uno(double %x) {
;
;
; CHECK-DF-LABEL: brR0_uno:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    fcmpuod vr0, vr0
; CHECK-DF-NEXT:    bt32 .LBB44_2
; CHECK-DF-NEXT:  # %bb.1: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB44_2: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
;
; CHECK-DF2-LABEL: brR0_uno:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    fcmpuo.64 vr0, vr0
; CHECK-DF2-NEXT:    bt32 .LBB44_2
; CHECK-DF2-NEXT:  # %bb.1: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB44_2: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
entry:
  %fcmp = fcmp uno double %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;True
define i32 @brRR_true(double %x, double %y) {
;
;
; CHECK-DF-LABEL: brRR_true:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    btsti32 a0, 0
; CHECK-DF-NEXT:    bt32 .LBB45_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB45_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
;
; CHECK-DF2-LABEL: brRR_true:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    btsti32 a0, 0
; CHECK-DF2-NEXT:    bt32 .LBB45_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB45_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
entry:
  %fcmp = fcmp true double %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_true(double %x) {
;
;
; CHECK-DF-LABEL: brRI_true:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    btsti32 a0, 0
; CHECK-DF-NEXT:    bt32 .LBB46_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB46_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
;
; CHECK-DF2-LABEL: brRI_true:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    btsti32 a0, 0
; CHECK-DF2-NEXT:    bt32 .LBB46_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB46_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
entry:
  %fcmp = fcmp true double %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_true(double %x) {
;
;
; CHECK-DF-LABEL: brR0_true:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    btsti32 a0, 0
; CHECK-DF-NEXT:    bt32 .LBB47_2
; CHECK-DF-NEXT:  # %bb.1: # %label1
; CHECK-DF-NEXT:    movi16 a0, 1
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:  .LBB47_2: # %label2
; CHECK-DF-NEXT:    movi16 a0, 0
; CHECK-DF-NEXT:    rts16
;
; CHECK-DF2-LABEL: brR0_true:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    btsti32 a0, 0
; CHECK-DF2-NEXT:    bt32 .LBB47_2
; CHECK-DF2-NEXT:  # %bb.1: # %label1
; CHECK-DF2-NEXT:    movi16 a0, 1
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:  .LBB47_2: # %label2
; CHECK-DF2-NEXT:    movi16 a0, 0
; CHECK-DF2-NEXT:    rts16
entry:
  %fcmp = fcmp true double %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}
