; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py

; RUN: llc -verify-machineinstrs -csky-no-aliases < %s -mtriple=csky -float-abi=hard -mattr=+hard-float -mattr=+2e3 -mattr=+fpuv2_sf | FileCheck %s --check-prefix=CHECK-SF
; RUN: llc -verify-machineinstrs -csky-no-aliases < %s -mtriple=csky -float-abi=hard -mattr=+hard-float -mattr=+2e3 -mattr=+fpuv3_sf | FileCheck %s --check-prefix=CHECK-SF2

define float @load_I_w(float* nocapture readonly %a) local_unnamed_addr #0 {
;
; CHECK-SF-LABEL: load_I_w:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    flds vr0, (a0, 12)
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: load_I_w:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fld.32 vr0, (a0, 12)
; CHECK-SF2-NEXT:    rts16
entry:
  %arrayidx = getelementptr inbounds float, float* %a, i64 3
  %0 = load float, float* %arrayidx, align 4
  ret float %0
}

define float @load_R_w(float* nocapture readonly %a, i32 %b) local_unnamed_addr #0 {
;
; CHECK-SF-LABEL: load_R_w:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fldrs vr0, (a0, a1 << 2)
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: load_R_w:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fldr.32 vr0, (a0, a1 << 2)
; CHECK-SF2-NEXT:    rts16
entry:
  %idxprom = sext i32 %b to i64
  %arrayidx = getelementptr inbounds float, float* %a, i64 %idxprom
  %0 = load float, float* %arrayidx, align 4
  ret float %0
}


define float @store_I_w(float*  %a, float %b) local_unnamed_addr #0 {
;
; CHECK-SF-LABEL: store_I_w:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fsts vr0, (a0, 12)
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    fmtvrl vr0, a0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: store_I_w:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fst.32 vr0, (a0, 12)
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    fmtvr.32.1 vr0, a0
; CHECK-SF2-NEXT:    rts16
entry:
  %arrayidx = getelementptr inbounds float, float* %a, i64 3
  store float %b, float* %arrayidx, align 4
  ret float 0.0
}

define float @store_R_w(float*  %a, i32 %b, float %c) local_unnamed_addr #0 {
;
; CHECK-SF-LABEL: store_R_w:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fstrs vr0, (a0, a1 << 2)
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    fmtvrl vr0, a0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: store_R_w:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fstr.32 vr0, (a0, a1 << 2)
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    fmtvr.32.1 vr0, a0
; CHECK-SF2-NEXT:    rts16
entry:
  %idxprom = sext i32 %b to i64
  %arrayidx = getelementptr inbounds float, float* %a, i64 %idxprom
  store float %c, float* %arrayidx, align 4
  ret float 0.0
}
