/*
 * Decompiled with CFR 0.152.
 */
package ancestris.core;

import ancestris.util.Utilities;
import genj.gedcom.Gedcom;
import genj.util.AncestrisPreferences;
import genj.util.Registry;
import java.util.Locale;

public class TextOptions {
    private static AncestrisPreferences textOptions;

    private TextOptions() {
        textOptions = Registry.get(TextOptions.class);
    }

    public static TextOptions getInstance() {
        return OptionsHolder.INSTANCE;
    }

    private String trim(String symbol, String fallback) {
        if (symbol == null) {
            return fallback;
        }
        symbol = symbol.trim();
        int len = symbol.length();
        if (symbol.length() == 0) {
            return fallback;
        }
        if (!Character.isLetter(symbol.charAt(len - 1))) {
            return symbol;
        }
        return symbol;
    }

    public int getIndentPerLevel() {
        return textOptions.get("indentPerLevel", 2);
    }

    public void setIndentPerLevel(int set) {
        textOptions.put("indentPerLevel", Math.max(2, set));
    }

    public int getPositions() {
        return textOptions.get("positions", 5);
    }

    public void setPositions(int set) {
        textOptions.put("positions", Math.max(0, set));
    }

    public String getBirthSymbol() {
        return textOptions.get("birthSymbol", "\u00b0");
    }

    public void setBirthSymbol(String set) {
        textOptions.put("birthSymbol", this.trim(set, "\u00b0"));
    }

    public String getBaptismSymbol() {
        return textOptions.get("baptismSymbol", "~");
    }

    public void setBaptismSymbol(String set) {
        textOptions.put("baptismSymbol", this.trim(set, "~"));
    }

    public String getEngagingSymbol() {
        return textOptions.get("engagingSymbol", "o");
    }

    public void setEngagingSymbol(String set) {
        textOptions.put("engagingSymbol", this.trim(set, "o"));
    }

    public String getMarriageSymbol() {
        return textOptions.get("marriageSymbol", "x");
    }

    public void setMarriageSymbol(String set) {
        textOptions.put("marriageSymbol", this.trim(set, "x"));
    }

    public String getDivorceSymbol() {
        return textOptions.get("divorceSymbol", "o|o");
    }

    public void setDivorceSymbol(String set) {
        textOptions.put("divorceSymbol", this.trim(set, "o|o"));
    }

    public String getDeathSymbol() {
        return textOptions.get("deathSymbol", "+");
    }

    public void setDeathSymbol(String set) {
        textOptions.put("deathSymbol", this.trim(set, "+"));
    }

    public String getBurialSymbol() {
        return textOptions.get("burialSymbol", "[]");
    }

    public void setBurialSymbol(String set) {
        textOptions.put("burialSymbol", this.trim(set, "[]"));
    }

    public String getOccuSymbol() {
        return textOptions.get("occuSymbol", "=");
    }

    public void setOccuSymbol(String set) {
        textOptions.put("occuSymbol", this.trim(set, "="));
    }

    public String getResiSymbol() {
        return textOptions.get("resiSymbol", "^");
    }

    public void setResiSymbol(String set) {
        textOptions.put("resiSymbol", this.trim(set, "^"));
    }

    public String getChildOfSymbol() {
        return textOptions.get("childOfSymbol", "/");
    }

    public void setChildOfSymbol(String set) {
        textOptions.put("childOfSymbol", this.trim(set, "/"));
    }

    public String getSymbol(String tag, String defaultSymbol) {
        if ("BIRT".equals(tag)) {
            return this.getBirthSymbol();
        }
        if ("BAPM".equals(tag) || "CHR".equals(tag)) {
            return this.getBaptismSymbol();
        }
        if ("ENGA".equals(tag)) {
            return this.getEngagingSymbol();
        }
        if ("MARR".equals(tag)) {
            return this.getMarriageSymbol();
        }
        if ("DIV".equals(tag)) {
            return this.getDivorceSymbol();
        }
        if ("DEAT".equals(tag)) {
            return this.getDeathSymbol();
        }
        if ("BURI".equals(tag)) {
            return this.getBurialSymbol();
        }
        if ("OCCU".equals(tag)) {
            return this.getOccuSymbol();
        }
        if ("RESI".equals(tag)) {
            return this.getResiSymbol();
        }
        if ("FAMC".equals(tag)) {
            return this.getChildOfSymbol();
        }
        return defaultSymbol.isEmpty() ? Gedcom.getName(tag) : defaultSymbol;
    }

    public Locale getOutputLocale() {
        return this.getOutputLocale(Locale.getDefault());
    }

    public Locale getOutputLocale(Locale defaultLocale) {
        String outLocale = textOptions.get("locale.output", (String)null);
        return outLocale == null ? defaultLocale : Utilities.getLocaleFromString(outLocale);
    }

    public void setOutputLocale(Locale outLoc) {
        if (outLoc == null) {
            textOptions.put("locale.output", (String)null);
        } else {
            textOptions.put("locale.output", outLoc.toString());
        }
    }

    public boolean isUseChr() {
        return textOptions.get("useCHR", false);
    }

    public void setUseChr(boolean value) {
        textOptions.put("useCHR", value);
    }

    public boolean isUseBuri() {
        return textOptions.get("useBURI", false);
    }

    public void setUseBuri(boolean value) {
        textOptions.put("useBURI", value);
    }

    private static class OptionsHolder {
        private static final TextOptions INSTANCE = new TextOptions();

        private OptionsHolder() {
        }
    }
}

