/*
 * Decompiled with CFR 0.152.
 */
package ancestris.gedcom;

import ancestris.gedcom.AbstractPropertyFinder;
import genj.gedcom.Entity;
import genj.gedcom.Indi;
import java.util.Collection;

public interface PropertyFinder {
    public Collection<Entity> find(Entity var1);

    public Collection<Entity> find(Collection<Entity> var1);

    public PropertyFinder or(PropertyFinder var1);

    public PropertyFinder and(PropertyFinder var1);

    public PropertyFinder sex(int var1);

    public static final class Constants {
        public static final PropertyFinder FATHER = new AbstractPropertyFinder.TagPathFinder(Indi.class, "INDI:FAMC:*:..:HUSB:*");
        public static final PropertyFinder MOTHER = new AbstractPropertyFinder.TagPathFinder(Indi.class, "INDI:FAMC:*:..:WIFE:*");
        public static final PropertyFinder PARENT = FATHER.or(MOTHER);
        public static final PropertyFinder GRANDPARENT = PARENT.and(PARENT);
        public static final PropertyFinder SIBLING = new AbstractPropertyFinder.TagPathFinder(Indi.class, "INDI:FAMC:*:..:CHIL:*");
        public static final PropertyFinder BROTHER = SIBLING.sex(1);
        public static final PropertyFinder SISTER = SIBLING.sex(2);
        public static final PropertyFinder HUSBAND = new AbstractPropertyFinder.TagPathFinder(Indi.class, "INDI:FAMS:*:..:HUSB:*");
        public static final PropertyFinder WIFE = new AbstractPropertyFinder.TagPathFinder(Indi.class, "INDI:FAMS:*:..:WIFE:*");
        public static final PropertyFinder SPOUSE = HUSBAND.or(WIFE);
        public static final PropertyFinder CHILD = new AbstractPropertyFinder.TagPathFinder(Indi.class, "INDI:FAMS:*:..:CHIL:*");
        public static final PropertyFinder DAUGHTER = CHILD.sex(2);
        public static final PropertyFinder SON = CHILD.sex(1);
        public static final PropertyFinder GRANDSON = CHILD.and(SON);
        public static final PropertyFinder GRANDDAUGHTER = CHILD.and(DAUGHTER);
        public static final PropertyFinder GRANDCHILD = CHILD.and(CHILD);
        public static final PropertyFinder UNCLE = PARENT.and(BROTHER).or(PARENT.and(SISTER).and(HUSBAND));
        public static final PropertyFinder AUNT = PARENT.and(SISTER).or(PARENT.and(BROTHER).and(WIFE));
        public static final PropertyFinder UNCLE_AUNT = PARENT.and(SIBLING);
        public static final PropertyFinder NEPHEW = SIBLING.and(CHILD);
        public static final PropertyFinder FIRSTCOUSIN = PARENT.and(SIBLING).and(CHILD);

        private Constants() {
        }
    }
}

