/*
 * Decompiled with CFR 0.152.
 */
package gj.layout.tree;

import gj.layout.LayoutException;
import gj.layout.tree.Contour;
import gj.layout.tree.NodeOptions;
import gj.layout.tree.Orientation;
import gj.model.Graph;
import gj.model.Node;
import gj.util.ArcIterator;
import java.awt.Shape;
import java.util.HashSet;
import java.util.Set;

public class Tree {
    private int[] height;
    private int[] latitude;
    private int numGenerations;
    private Set nodes;
    private Node root;

    public Tree(Graph graph, Node root, NodeOptions nopt, Orientation o) throws LayoutException {
        this(root, nopt, o, graph.getNodes().size());
    }

    public Tree(Node root, NodeOptions nopt, Orientation o, int estimatedSize) throws LayoutException {
        this.root = root;
        this.height = new int[estimatedSize];
        this.nodes = new HashSet(estimatedSize);
        this.analyze(root, null, 0, nopt, o);
        this.latitude = new int[this.numGenerations];
        int pos = 0;
        for (int i = 0; i < this.numGenerations; ++i) {
            this.latitude[i] = pos;
            pos += this.height[i];
        }
    }

    private void analyze(Node node, Node parent, int generation, NodeOptions nopt, Orientation o) throws LayoutException {
        if (this.nodes.contains(node)) {
            throw new LayoutException("Arc " + parent + "->" + node + " is part of a cycle");
        }
        this.nodes.add(node);
        this.numGenerations = Math.max(this.numGenerations, generation + 1);
        Shape shape = node.getShape();
        if (shape != null) {
            Contour contour = o.getContour(shape.getBounds2D());
            contour.pad(nopt.getPadding(this.root, o));
            this.height[generation] = Math.max(this.height[generation], contour.south - contour.north);
        }
        ArcIterator it = new ArcIterator(node);
        while (it.next()) {
            if (!it.isFirst || it.isLoop || it.dest == parent) continue;
            this.analyze(it.dest, node, generation + 1, nopt, o);
        }
    }

    public int getHeight(int generation) {
        return this.height[generation];
    }

    public int getLatitude(int generation) {
        return this.latitude[generation];
    }

    public Set getNodes() {
        return this.nodes;
    }

    public Node getRoot() {
        return this.root;
    }
}

