/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree;

import ancestris.report.svgtree.arrange.AlignLeftArranger;
import ancestris.report.svgtree.arrange.CenteredArranger;
import ancestris.report.svgtree.filter.FilterChain;
import ancestris.report.svgtree.filter.SameHeightSpouses;
import ancestris.report.svgtree.filter.TreeFilter;
import ancestris.report.svgtree.output.HorizontalLines;
import genj.report.Translator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LayoutFactory {
    public static final int SPACING = 10;
    public static final int ROTATE_0 = 0;
    public static final int ROTATE_270 = 1;
    public static final int ROTATE_180 = 2;
    public static final int ROTATE_90 = 3;
    public int arrangement = 0;
    public String[] arrangements;
    public boolean flip = false;
    public boolean husband_first = true;
    public int rotation = 0;
    public String[] rotations = new String[]{"none", "270", "180", "90"};
    private final Map<String, TreeFilter> layouts = new LinkedHashMap<String, TreeFilter>();
    private final List<TreeFilter> layoutList = new ArrayList<TreeFilter>();
    private final Translator translator;

    public LayoutFactory(Translator translator) {
        this.translator = translator;
        this.add(translator.translate("arrangement.center"), this.getLayout(new CenteredArranger(10)));
        this.add(translator.translate("arrangement.left"), this.getLayout(new AlignLeftArranger(10)));
        for (int i = 0; i < this.rotations.length; ++i) {
            this.rotations[i] = translator.translate("rotation." + this.rotations[i]);
        }
    }

    public TreeFilter createLayout() {
        return this.layoutList.get(this.arrangement);
    }

    private void add(String name, TreeFilter layout) {
        this.layouts.put(name, layout);
        this.layoutList.add(layout);
        this.arrangements = this.layouts.keySet().toArray(new String[0]);
    }

    private TreeFilter getLayout(TreeFilter layout) {
        return new FilterChain(new TreeFilter[]{layout, new SameHeightSpouses(), new HorizontalLines(10)});
    }
}

