/*
 * Decompiled with CFR 0.152.
 */
package ancestris.welcome.ui;

import ancestris.welcome.content.BundleSupport;
import ancestris.welcome.content.Constants;
import ancestris.welcome.content.RSSFeed;
import ancestris.welcome.content.RSSFeedReaderPanel;
import ancestris.welcome.content.Utils;
import ancestris.welcome.content.WebLink;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.text.View;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.util.ImageUtilities;

class DemoPanel
extends RSSFeedReaderPanel {
    public DemoPanel() {
        super(BundleSupport.getURL("Demo"));
    }

    @Override
    protected JComponent buildContent(String url, boolean showProxyButton) {
        JPanel res = new JPanel(new GridBagLayout());
        res.setOpaque(false);
        DemoRSSFeed feed = new DemoRSSFeed(url);
        res.add((Component)feed, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        res.add((Component)new JLabel(), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return res;
    }

    private static class MyTooltip
    extends JToolTip {
        private MyTooltip() {
        }

        @Override
        public void setTipText(String tipText) {
            View v;
            super.setTipText(tipText);
            if (this.getPreferredSize().width > 400 && null != (v = (View)this.getClientProperty("html"))) {
                v.setSize(300.0f, 300.0f);
            }
        }
    }

    private static class MaxSizeImageIcon
    implements Icon,
    Constants {
        private static final int MAX_IMAGE_WIDTH = 202;
        private static final int MAX_IMAGE_HEIGHT = 142;
        private Image content;
        private Image frame;

        public MaxSizeImageIcon(Image content) {
            this.content = content;
            this.frame = ImageUtilities.loadImage((String)"ancestris/welcome/resources/picture_frame.png");
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            try {
                int imgX = x;
                int imgY = y;
                if (this.content.getWidth(null) > 202) {
                    imgX += (this.content.getWidth(null) - 202) / 2;
                }
                if (this.content.getHeight(null) > 142) {
                    imgY += (this.content.getHeight(null) - 142) / 2;
                }
                g.drawImage(this.content, x, y, x + Math.min(202, this.content.getWidth(null)), y + Math.min(142, this.content.getHeight(null)), imgX, imgY, imgX + Math.min(202, this.content.getWidth(null)), imgY + Math.min(142, this.content.getHeight(null)), null);
                g.drawImage(this.frame, x, y, c);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable e) {
                Logger.getLogger(DemoPanel.class.getName()).log(Level.FINE, "Error while painting demo image.", e);
            }
        }

        @Override
        public int getIconWidth() {
            return 202;
        }

        @Override
        public int getIconHeight() {
            return 142;
        }
    }

    private static class ImageLabel
    extends JLabel
    implements Constants,
    MouseListener {
        private String url;
        private boolean visited = false;

        public ImageLabel(String url, ImageIcon img, String description) {
            super(new MaxSizeImageIcon(img.getImage()));
            this.url = url;
            if (null != description) {
                this.setToolTipText("<html>" + description);
            }
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.addMouseListener(this);
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                this.visited = true;
                Utils.showURL(this.url);
                this.mouseEntered(null);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Color borderColor = Utils.getColor(this.visited ? "VisitedLinkColor" : "MouseOverLinkColor");
            this.setBorder(BorderFactory.createLineBorder(borderColor, 1));
            StatusDisplayer.getDefault().setStatusText(this.url);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            StatusDisplayer.getDefault().setStatusText("");
        }

        @Override
        public JToolTip createToolTip() {
            return new MyTooltip();
        }
    }

    private static class DemoRSSFeed
    extends RSSFeed {
        public DemoRSSFeed(String url) {
            super(url, false);
        }

        @Override
        protected Component createFeedItemComponent(RSSFeed.FeedItem item) {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setOpaque(false);
            int row = 0;
            if (item.isValid()) {
                if (item.enclosureUrl != null) {
                    panel.add((Component)new ImageLabel(item.link, this.getImage(item.enclosureUrl), item.description), new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
                } else {
                    JLabel label = new JLabel(BundleSupport.getLabel("NoScreenShot"));
                    label.setHorizontalAlignment(0);
                    label.setVerticalAlignment(0);
                    panel.add((Component)label, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
                }
                WebLink linkButton = new WebLink(item.title, item.link, false);
                linkButton.getAccessibleContext().setAccessibleName(BundleSupport.getAccessibilityName("WebLink", item.title));
                linkButton.getAccessibleContext().setAccessibleDescription(BundleSupport.getAccessibilityDescription("WebLink", item.link));
                linkButton.setFont(BUTTON_FONT);
                panel.add((Component)linkButton, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
            } else {
                panel.add((Component)new JLabel(BundleSupport.getLabel("ErrLoadingFeed")), new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 10, 5), 0, 0));
                JButton button = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)button, (String)BundleSupport.getLabel("Reload"));
                button.setOpaque(false);
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        lastReload = 0L;
                        this.reload();
                    }
                });
                panel.add((Component)button, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 10, 5), 0, 0));
            }
            return panel;
        }

        @Override
        protected int getMaxItemCount() {
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ImageIcon getImage(String urlString) {
            URL url = null;
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException mfuE) {
                mfuE.printStackTrace();
            }
            ImageIcon image = null;
            if (this.isContentCached()) {
                ObjectInputStream input = null;
                try {
                    input = new ObjectInputStream(new FileInputStream(this.getCacheFilePath()));
                    image = (ImageIcon)input.readObject();
                    Logger.getLogger(DemoPanel.class.getName()).log(Level.FINE, "Demo image loaded from: " + this.getCacheFilePath());
                }
                catch (Exception e) {
                    image = null;
                }
                finally {
                    if (null != input) {
                        try {
                            input.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            if (null == image) {
                ObjectOutputStream output = null;
                try {
                    URLConnection conn = url.openConnection();
                    boolean defCache = conn.getDefaultUseCaches();
                    conn.setDefaultUseCaches(true);
                    image = new ImageIcon(url);
                    conn.setDefaultUseCaches(defCache);
                    output = new ObjectOutputStream(new FileOutputStream(this.getCacheFilePath()));
                    output.writeObject(image);
                }
                catch (Exception e) {
                    Logger.getLogger(DemoPanel.class.getName()).log(Level.FINE, "Error while caching Welcome Page demo image", e);
                    image = ImageUtilities.loadImageIcon((String)"ancestris/welcome/resources/broken_image.png", (boolean)false);
                }
                finally {
                    if (null != output) {
                        try {
                            output.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            return image;
        }

        private File getCacheFilePath() throws IOException {
            File cacheStore = Utils.getCacheStore();
            cacheStore = new File(cacheStore, "demoimage");
            cacheStore.getParentFile().mkdirs();
            cacheStore.createNewFile();
            return cacheStore;
        }
    }
}

