/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.htmlui;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypeException;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.netbeans.api.htmlui.HTMLComponent;
import org.netbeans.api.htmlui.HTMLDialog;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGenerationException;

public class HTMLDialogProcessor
extends AbstractProcessor
implements Comparator<ExecutableElement> {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> hash = new HashSet<String>();
        hash.add(HTMLDialog.class.getCanonicalName());
        hash.add(HTMLComponent.class.getCanonicalName());
        return hash;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private Set<Element> annotatedWith(RoundEnvironment re, Class<? extends Annotation> type) {
        HashSet<Element> collect = new HashSet<Element>();
        HTMLDialogProcessor.findAllElements(re.getElementsAnnotatedWith(type), collect, type);
        return collect;
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment re) {
        PackageElement pkg;
        String fqn;
        Set<ExecutableElement> elems;
        ExecutableElement ee;
        Annotation reg;
        TreeMap<String, Set<ExecutableElement>> names = new TreeMap<String, Set<ExecutableElement>>();
        for (Element element : this.annotatedWith(re, HTMLDialog.class)) {
            reg = element.getAnnotation(HTMLDialog.class);
            if (reg == null || element.getKind() != ElementKind.METHOD) continue;
            ee = (ExecutableElement)element;
            if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
                this.error("Method annotated by @HTMLDialog needs to be static", element);
            }
            if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.error("Method annotated by @HTMLDialog cannot be private", element);
            }
            if (!ee.getThrownTypes().isEmpty()) {
                this.error("Method annotated by @HTMLDialog cannot throw exceptions", element);
            }
            if ((elems = (TreeSet<ExecutableElement>)names.get(fqn = (pkg = HTMLDialogProcessor.findPkg(ee)).getQualifiedName() + "." + reg.className())) == null) {
                elems = new TreeSet<ExecutableElement>(this);
                names.put(fqn, elems);
            }
            elems.add(ee);
        }
        for (Element element : this.annotatedWith(re, HTMLComponent.class)) {
            reg = element.getAnnotation(HTMLComponent.class);
            if (reg == null || element.getKind() != ElementKind.METHOD) continue;
            ee = (ExecutableElement)element;
            if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
                this.error("Method annotated by @HTMLComponent needs to be static", element);
            }
            if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.error("Method annotated by @HTMLComponent cannot be private", element);
            }
            if (!ee.getThrownTypes().isEmpty()) {
                this.error("Method annotated by @HTMLComponent cannot throw exceptions", element);
            }
            if ((elems = (Set)names.get(fqn = (pkg = HTMLDialogProcessor.findPkg(ee)).getQualifiedName() + "." + reg.className())) == null) {
                elems = new TreeSet<ExecutableElement>(this);
                names.put(fqn, elems);
            }
            elems.add(ee);
        }
        for (Map.Entry entry : names.entrySet()) {
            String clazzName = (String)entry.getKey();
            Set elems2 = (Set)entry.getValue();
            Element first = (Element)elems2.iterator().next();
            try {
                JavaFileObject f = this.processingEnv.getFiler().createSourceFile(clazzName, elems2.toArray(new Element[0]));
                Writer w = f.openWriter();
                String[] arr = this.splitPkg(clazzName, first);
                w.append("package ").append(arr[0]).append(";\n");
                w.append("\n");
                w.append("import org.netbeans.api.htmlui.HTMLDialog.Builder;\n");
                w.append("class ").append(arr[1]).append(" {\n");
                w.append("  private ").append(arr[1]).append("() {\n  }\n");
                w.append("\n");
                for (ExecutableElement ee2 : elems2) {
                    String t;
                    String url;
                    HTMLDialog reg2 = ee2.getAnnotation(HTMLDialog.class);
                    HTMLComponent comp = ee2.getAnnotation(HTMLComponent.class);
                    if (reg2 != null) {
                        url = this.findURL(reg2.url(), ee2);
                        if (url == null) continue;
                        this.generateDialog(w, ee2, url, reg2.techIds());
                    }
                    if (comp == null || (url = this.findURL(comp.url(), ee2)) == null) continue;
                    try {
                        t = comp.type().getName();
                    }
                    catch (MirroredTypeException ex) {
                        t = ex.getTypeMirror().toString();
                    }
                    if (!t.equals("javafx.scene.Node") && !t.equals("javax.swing.JComponent")) {
                        this.error("type() can be either Node.class or JComponent.class", ee2);
                    }
                    this.generateComponent(w, ee2, t, url, comp.techIds());
                }
                w.append("}\n");
                w.close();
            }
            catch (IOException ex) {
                this.error("Cannot create " + clazzName, first);
            }
        }
        return true;
    }

    private String findURL(String relativeURL, ExecutableElement ee) {
        String url;
        try {
            URL u = new URL(relativeURL);
            url = u.toExternalForm();
        }
        catch (MalformedURLException ex2) {
            try {
                String res = LayerBuilder.absolutizeResource((Element)ee, (String)relativeURL);
                this.validateResource(res, ee, null, null, false);
                url = "nbresloc:/" + res;
            }
            catch (LayerGenerationException ex) {
                this.error("Cannot find resource " + relativeURL, ee);
                url = null;
            }
        }
        return url;
    }

    private void generateDialog(Writer w, ExecutableElement ee, String url, String[] techIds) throws IOException {
        w.append("  public static String ").append(ee.getSimpleName());
        w.append("(");
        String sep = "";
        for (VariableElement variableElement : ee.getParameters()) {
            w.append(sep);
            w.append("final ").append(variableElement.asType().toString()).append(" ").append(variableElement.getSimpleName());
            sep = ", ";
        }
        w.append(") {\n");
        w.append("    return Builder.newDialog(\"").append(url).append("\").\n");
        this.generateTechIds(w, techIds);
        w.append("      loadFinished(new Runnable() {\n");
        w.append("        public void run() {\n");
        w.append("          ").append(ee.getEnclosingElement().getSimpleName()).append(".").append(ee.getSimpleName()).append("(");
        sep = "";
        for (VariableElement variableElement : ee.getParameters()) {
            w.append(sep);
            w.append(variableElement.getSimpleName());
            sep = ", ";
        }
        w.append(");\n");
        w.append("        }\n");
        w.append("      }).\n");
        w.append("      showAndWait();\n");
        w.append("  }\n");
    }

    private void generateComponent(Writer w, ExecutableElement ee, String type, String url, String[] techIds) throws IOException {
        w.append("  public static ").append(type).append(" ").append(ee.getSimpleName());
        w.append("(");
        String sep = "";
        for (VariableElement variableElement : ee.getParameters()) {
            w.append(sep);
            w.append("final ").append(variableElement.asType().toString()).append(" ").append(variableElement.getSimpleName());
            sep = ", ";
        }
        w.append(") {\n");
        w.append("    return Builder.newDialog(\"").append(url).append("\").\n");
        this.generateTechIds(w, techIds);
        w.append("      loadFinished(new Runnable() {\n");
        w.append("        public void run() {\n");
        w.append("          ").append(ee.getEnclosingElement().getSimpleName()).append(".").append(ee.getSimpleName()).append("(");
        sep = "";
        for (VariableElement variableElement : ee.getParameters()) {
            w.append(sep);
            w.append(variableElement.getSimpleName());
            sep = ", ";
        }
        w.append(");\n");
        w.append("        }\n");
        w.append("      }).\n");
        w.append("      component(").append(type).append(".class);\n");
        w.append("  }\n");
    }

    private void error(String msg, Element e) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e);
    }

    private static PackageElement findPkg(Element e) {
        while (e.getKind() != ElementKind.PACKAGE) {
            e = e.getEnclosingElement();
        }
        return (PackageElement)e;
    }

    private String[] splitPkg(String s, Element e) {
        int last = s.lastIndexOf(46);
        if (last == -1) {
            this.error("Cannot generate " + s + " into default package!", e);
            return new String[]{"x", s};
        }
        return new String[]{s.substring(0, last), s.substring(last + 1)};
    }

    @Override
    public int compare(ExecutableElement o1, ExecutableElement o2) {
        int id2;
        if (o1 == o2) {
            return 0;
        }
        int names = o1.getSimpleName().toString().compareTo(o2.getSimpleName().toString());
        if (names != 0) {
            return names;
        }
        names = o1.getEnclosingElement().getSimpleName().toString().compareTo(o2.getEnclosingElement().getSimpleName().toString());
        if (names != 0) {
            return names;
        }
        int id1 = System.identityHashCode(o1);
        if (id1 == (id2 = System.identityHashCode(o2))) {
            throw new IllegalStateException("Cannot order " + o1 + " and " + o2);
        }
        return id1 - id2;
    }

    FileObject validateResource(String resource, Element originatingElement, Annotation annotation, String annotationMethod, boolean searchClasspath) throws LayerGenerationException {
        if (resource.startsWith("/")) {
            throw new LayerGenerationException("do not use leading slashes on resource paths", originatingElement, this.processingEnv, annotation, annotationMethod);
        }
        if (searchClasspath) {
            for (JavaFileManager.Location loc : new JavaFileManager.Location[]{StandardLocation.SOURCE_PATH, StandardLocation.CLASS_OUTPUT, StandardLocation.CLASS_PATH, StandardLocation.PLATFORM_CLASS_PATH}) {
                try {
                    FileObject f = this.processingEnv.getFiler().getResource(loc, "", resource);
                    if (loc.isOutputLocation()) {
                        f.openInputStream().close();
                    }
                    return f;
                }
                catch (IOException ex) {
                }
            }
            throw new LayerGenerationException("Cannot find resource " + resource, originatingElement, this.processingEnv, annotation, annotationMethod);
        }
        try {
            try {
                FileObject f = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, "", resource);
                f.openInputStream().close();
                return f;
            }
            catch (FileNotFoundException x) {
                try {
                    FileObject f = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", resource);
                    f.openInputStream().close();
                    return f;
                }
                catch (IOException x2) {
                    throw x;
                }
            }
        }
        catch (IOException x) {
            throw new LayerGenerationException("Cannot find resource " + resource, originatingElement, this.processingEnv, annotation, annotationMethod);
        }
    }

    private static void findAllElements(Set<? extends Element> scan, Set<Element> found, Class<? extends Annotation> type) {
        for (Element element : scan) {
            PackageElement pkg = HTMLDialogProcessor.findPkg(element);
            if (!found.add(pkg)) continue;
            HTMLDialogProcessor.searchSubTree(pkg, found, type);
        }
    }

    private static void searchSubTree(Element e, Set<Element> found, Class<? extends Annotation> type) {
        if (e.getAnnotation(type) != null) {
            found.add(e);
        }
        for (Element element : e.getEnclosedElements()) {
            HTMLDialogProcessor.searchSubTree(element, found, type);
        }
    }

    private void generateTechIds(Writer w, String[] techIds) throws IOException {
        if (techIds.length == 0) {
            return;
        }
        w.append("addTechIds(");
        String sep = "";
        for (String id : techIds) {
            w.append(sep);
            w.append('\"');
            w.append(id);
            w.append('\"');
            sep = ", ";
        }
        w.append(").\n");
    }
}

