/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import org.oxbow.swingbits.list.CheckListFilterType;
import org.oxbow.swingbits.list.ICheckListModel;
import org.oxbow.swingbits.util.DefaultObjectToStringTranslator;
import org.oxbow.swingbits.util.IObjectToStringTranslator;
import org.oxbow.swingbits.util.IValueWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCheckListModel<T>
extends AbstractListModel
implements ICheckListModel<T> {
    private static final long serialVersionUID = 1L;
    private final List<T> data = new ArrayList<T>();
    private final Set<T> checks = new HashSet<T>();
    public static IObjectToStringTranslator DEFAULT_TRANSLATOR = new DefaultObjectToStringTranslator();
    private List<T> filteredData = null;

    public DefaultCheckListModel(Collection<? extends T> collection) {
        if (collection == null) {
            return;
        }
        for (T t : collection) {
            this.data.add(t);
            this.checks.clear();
        }
    }

    public DefaultCheckListModel(T ... TArray) {
        this((Collection<T>)Arrays.asList(TArray));
    }

    @Override
    public int getSize() {
        return this.data().size();
    }

    private List<T> data() {
        return this.filteredData == null ? this.data : this.filteredData;
    }

    public Object getElementAt(int n) {
        return this.data().get(n);
    }

    @Override
    public boolean isCheckedIndex(int n) {
        return this.checks.contains(this.data().get(n));
    }

    @Override
    public void setCheckedIndex(int n, boolean bl) {
        T t = this.data().get(n);
        if (bl) {
            this.checks.add(t);
        } else {
            this.checks.remove(t);
        }
        this.fireContentsChanged(this, n, n);
    }

    @Override
    public Collection<T> getCheckedItems() {
        ArrayList<T> arrayList = new ArrayList<T>(this.checks);
        arrayList.retainAll(this.data);
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public void setCheckedItems(Collection<T> collection) {
        ArrayList<T> arrayList = new ArrayList<T>(collection);
        arrayList.retainAll(this.data);
        this.checks.clear();
        this.checks.addAll(arrayList);
        this.fireContentsChanged(this, 0, this.checks.size() - 1);
    }

    @Override
    public void filter(String string, IObjectToStringTranslator iObjectToStringTranslator, CheckListFilterType checkListFilterType) {
        if (string == null || string.trim().length() == 0) {
            this.filteredData = null;
        } else {
            CheckListFilterType checkListFilterType2 = checkListFilterType == null ? CheckListFilterType.CONTAINS : checkListFilterType;
            IObjectToStringTranslator iObjectToStringTranslator2 = iObjectToStringTranslator == null ? DEFAULT_TRANSLATOR : iObjectToStringTranslator;
            String string2 = string.toLowerCase();
            ArrayList<T> arrayList = new ArrayList<T>();
            for (T t : this.data) {
                T t2 = t instanceof IValueWrapper ? ((IValueWrapper)t).getValue() : t;
                if (!checkListFilterType2.include(iObjectToStringTranslator2.translate(t2), string2)) continue;
                arrayList.add(t);
            }
            this.filteredData = arrayList;
        }
        this.fireContentsChanged(this, 0, this.data.size() - 1);
    }
}

