/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve;

import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.modules.releve.ReleveTopComponent;
import ancestris.modules.releve.model.CompletionProvider;
import ancestris.modules.releve.model.DataManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import org.openide.util.NbBundle;

public class ReleveCompletionDialog
extends JFrame {
    CompletionModel model = new CompletionModel();
    CompletionProvider.CompletionType completionType;
    private JLabel comment;
    private JButton jButtonCancel;
    private JButton jButtonCopyToClipboard;
    private JButton jButtonDelete;
    private JButton jButtonOk;
    private JPanel jPaneTable;
    private JPanel jPanelButton;
    private JPanel jPanelComment;
    private JScrollPane jScrollPane1;
    private JTable jTableExclude;

    public static void showFirstNameCompletionPanel() {
        ReleveCompletionDialog completionDialog = new ReleveCompletionDialog();
        completionDialog.initData(CompletionProvider.CompletionType.firstName);
        completionDialog.setVisible(true);
    }

    public static void showLastNameCompletionPanel() {
        ReleveCompletionDialog completionDialog = new ReleveCompletionDialog();
        completionDialog.initData(CompletionProvider.CompletionType.lastName);
        completionDialog.setVisible(true);
    }

    public static void showOccupationCompletionPanel() {
        ReleveCompletionDialog completionDialog = new ReleveCompletionDialog();
        completionDialog.initData(CompletionProvider.CompletionType.occupation);
        completionDialog.setVisible(true);
    }

    public ReleveCompletionDialog() {
        this.initComponents();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screen.width - this.getWidth()) / 2, (screen.height - this.getHeight()) / 2, this.getWidth(), this.getHeight());
    }

    public void initData(CompletionProvider.CompletionType completionType) {
        List<Object> valueList;
        String columnTitle;
        this.completionType = completionType;
        DataManager dataManager = null;
        Iterator iterator = AncestrisPlugin.lookupAll(ReleveTopComponent.class).iterator();
        if (iterator.hasNext()) {
            ReleveTopComponent tc = (ReleveTopComponent)iterator.next();
            dataManager = tc.getDataManager();
        }
        if (dataManager == null) {
            return;
        }
        List<Object> excludeList = switch (completionType) {
            case CompletionProvider.CompletionType.firstName -> {
                columnTitle = NbBundle.getMessage(ReleveCompletionDialog.class, (String)"ReleveCompletionDialog.firstName");
                valueList = dataManager.getCompletionProvider().getFirstNames().getAll();
                yield CompletionProvider.loadExcludeCompletion(completionType);
            }
            case CompletionProvider.CompletionType.lastName -> {
                columnTitle = NbBundle.getMessage(ReleveCompletionDialog.class, (String)"ReleveCompletionDialog.lastName");
                valueList = dataManager.getCompletionProvider().getLastNames().getAll();
                yield CompletionProvider.loadExcludeCompletion(completionType);
            }
            case CompletionProvider.CompletionType.occupation -> {
                columnTitle = NbBundle.getMessage(ReleveCompletionDialog.class, (String)"ReleveCompletionDialog.occupation");
                valueList = dataManager.getCompletionProvider().getOccupations().getAll();
                yield CompletionProvider.loadExcludeCompletion(completionType);
            }
            default -> {
                columnTitle = "";
                valueList = new ArrayList();
                yield new ArrayList();
            }
        };
        this.setTitle(String.format(NbBundle.getMessage(ReleveCompletionDialog.class, (String)"ReleveCompletionDialog.title"), columnTitle));
        this.model.setColumnTitle(columnTitle);
        HashMap<String, Boolean> lastNameMap = new HashMap<String, Boolean>();
        Iterator<Object> it = valueList.iterator();
        while (it.hasNext()) {
            lastNameMap.put((String)it.next(), true);
        }
        it = excludeList.iterator();
        while (it.hasNext()) {
            lastNameMap.put((String)it.next(), false);
        }
        for (Map.Entry entry : lastNameMap.entrySet()) {
            this.model.add((String)entry.getKey(), (Boolean)entry.getValue());
        }
        this.jTableExclude.setModel(this.model);
        this.jTableExclude.setAutoCreateRowSorter(true);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        sortKeys.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
        this.jTableExclude.getRowSorter().setSortKeys(sortKeys);
        this.jTableExclude.getColumnModel().getColumn(0).setMaxWidth(40);
    }

    private void saveExcluded() {
        ArrayList<String> excludeList = new ArrayList<String>();
        int n = this.model.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (((Boolean)this.model.getValueAt(i, 0)).booleanValue()) continue;
            excludeList.add(this.model.getValueAt(i, 1).toString());
        }
        CompletionProvider.saveExcludedCompletion(excludeList, this.completionType);
        for (ReleveTopComponent tc : AncestrisPlugin.lookupAll(ReleveTopComponent.class)) {
            tc.getDataManager().getCompletionProvider().refreshExcludeCompletion(this.completionType);
        }
    }

    private void initComponents() {
        this.jPanelComment = new JPanel();
        this.comment = new JLabel();
        this.jPaneTable = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableExclude = new JTable();
        this.jPanelButton = new JPanel();
        this.jButtonCopyToClipboard = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                ReleveCompletionDialog.this.formWindowClosed(evt);
            }
        });
        this.comment.setText(NbBundle.getMessage(ReleveCompletionDialog.class, (String)"ReleveCompletionDialog.comment.text"));
        this.jPanelComment.add(this.comment);
        this.comment.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ReleveCompletionDialog.class, (String)"ReleveCompletionDialog.comment.text"));
        this.getContentPane().add((Component)this.jPanelComment, "North");
        this.jPaneTable.setPreferredSize(new Dimension(300, 400));
        this.jPaneTable.setLayout(new BorderLayout());
        this.jTableExclude.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.jTableExclude.setAutoResizeMode(3);
        this.jScrollPane1.setViewportView(this.jTableExclude);
        this.jPaneTable.add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jPaneTable, "Center");
        this.jPanelButton.setBorder(BorderFactory.createBevelBorder(0));
        this.jButtonCopyToClipboard.setText(NbBundle.getMessage(ReleveCompletionDialog.class, (String)"ReleveCompletionDialog.jButtonCopyToClipboard.text"));
        this.jButtonCopyToClipboard.setToolTipText(NbBundle.getMessage(ReleveCompletionDialog.class, (String)"ReleveCompletionDialog.jButtonCopyToClipboard.toolTipText"));
        this.jButtonCopyToClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReleveCompletionDialog.this.jButtonCopyToClipboardActionPerformed(evt);
            }
        });
        this.jPanelButton.add(this.jButtonCopyToClipboard);
        this.jButtonDelete.setText(NbBundle.getMessage(ReleveCompletionDialog.class, (String)"ReleveCompletionDialog.jButtonDelete.text"));
        this.jButtonDelete.setToolTipText(NbBundle.getMessage(ReleveCompletionDialog.class, (String)"ReleveCompletionDialog.jButtonDelete.tooltip"));
        this.jButtonDelete.setHorizontalAlignment(2);
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReleveCompletionDialog.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jPanelButton.add(this.jButtonDelete);
        this.jButtonOk.setText(NbBundle.getMessage(ReleveCompletionDialog.class, (String)"ReleveCompletionDialog.jButtonOk.text"));
        this.jButtonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReleveCompletionDialog.this.jButtonOkActionPerformed(evt);
            }
        });
        this.jPanelButton.add(this.jButtonOk);
        this.jButtonCancel.setText(NbBundle.getMessage(ReleveCompletionDialog.class, (String)"ReleveCompletionDialog.jButtonCancel.text"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReleveCompletionDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanelButton.add(this.jButtonCancel);
        this.getContentPane().add((Component)this.jPanelButton, "South");
        this.pack();
    }

    private void formWindowClosed(WindowEvent evt) {
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        int[] selectedRows;
        for (int row : selectedRows = this.jTableExclude.getSelectedRows()) {
            this.model.remove(this.jTableExclude.convertRowIndexToModel(row));
        }
        this.model.fireTableDataChanged();
        this.jTableExclude.clearSelection();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        this.saveExcluded();
        this.dispose();
    }

    private void jButtonCopyToClipboardActionPerformed(ActionEvent evt) {
        String LINE_BREAK = "\n";
        Clipboard CLIPBOARD = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringBuilder clipboardStr = new StringBuilder();
        int n = this.model.getRowCount();
        for (int i = 0; i < n; ++i) {
            clipboardStr.append(this.model.getValueAt(i, 1).toString()).append("\n");
        }
        StringSelection sel = new StringSelection(clipboardStr.toString());
        CLIPBOARD.setContents(sel, sel);
    }

    private class CompletionModel
    extends AbstractTableModel {
        ArrayList<Boolean> includeList = new ArrayList();
        ArrayList<String> valueList = new ArrayList();
        String itemColumnTitle;
        String includedColumnTitle = NbBundle.getMessage(ReleveCompletionDialog.class, (String)"ReleveCompletionDialog.inludeColumnTitle");
        final Class<?>[] columnClass = new Class[]{Boolean.class, String.class};

        private CompletionModel() {
        }

        public void setColumnTitle(String columnName) {
            this.itemColumnTitle = columnName;
        }

        public void add(String value, boolean include) {
            this.valueList.add(value);
            this.includeList.add(include);
        }

        public void remove(int row) {
            this.valueList.remove(row);
            this.includeList.remove(row);
        }

        @Override
        public int getColumnCount() {
            return this.columnClass.length;
        }

        @Override
        public int getRowCount() {
            return this.valueList.size();
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return this.includedColumnTitle;
                }
                case 1: {
                    return this.itemColumnTitle;
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return this.columnClass[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.includeList.get(row);
                }
                case 1: {
                    return this.valueList.get(row);
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            switch (col) {
                case 0: {
                    this.includeList.set(row, (Boolean)value);
                    break;
                }
            }
            this.fireTableCellUpdated(row, col);
        }
    }
}

