/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.core.actions.MenuScroller;
import ancestris.modules.editors.standard.tools.ImagePanel;
import ancestris.modules.editors.standard.tools.SourceWrapper;
import ancestris.modules.viewers.media.MediaChooser;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertySource;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Source;
import genj.io.InputSource;
import genj.renderer.MediaRenderer;
import genj.renderer.MediaUtils;
import genj.util.Registry;
import genj.util.WordBuffer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class SourceChooser
extends JPanel {
    private static BufferedImage SOURCE_UNKNOWN = null;
    private static ImageIcon DEFAULT_ICON = null;
    private static int THUMB_WIDTH = 90;
    private static int THUMB_HEIGHT = 70;
    private static Map<String, ImageIcon> cacheIcon = new HashMap<String, ImageIcon>();
    private Registry registry = null;
    private ThumbComparator thumbComparator = new ThumbComparator();
    private TreeSet<SourceThumb> allSource = new TreeSet<SourceThumb>(this.thumbComparator);
    private DefaultListModel<SourceThumb> filteredModel = new DefaultListModel();
    private Gedcom gedcom = null;
    private InputSource mainFile = null;
    private Image mainImage = null;
    private SourceWrapper mainSource = null;
    private String mainTitle = "";
    private String mainText = "";
    private JButton okButton = null;
    private JButton cancelButton = null;
    private SwingWorker<Void, Void> worker;
    private ImagePanel imagePanel = null;
    private JLabel filterLabel;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPaneSource;
    private JSplitPane jSplitPane;
    private JSplitPane jSplitPane1;
    private JLabel photoTitle;
    private JList<SourceThumb> sourceList;
    private JPanel sourceMedia;
    private JTextArea sourceText;
    private JTextField textFilter;

    public SourceChooser(Gedcom gedcom, SourceWrapper source, JButton okButton, JButton cancelButton) {
        Optional obi;
        SOURCE_UNKNOWN = MediaUtils.IMG_NO_SOURCE_MEDIA;
        DEFAULT_ICON = new ImageIcon(MediaUtils.IMG_NO_SOURCE_MEDIA_SMALL);
        this.gedcom = gedcom;
        this.mainSource = source;
        if (source != null) {
            this.mainFile = source.getMediaFile();
            this.mainTitle = source.getTitle();
            this.mainText = source.getText();
        }
        this.mainImage = this.mainFile != null ? ((obi = MediaRenderer.getImage((InputSource)this.mainFile)).isPresent() ? (Image)obi.get() : SOURCE_UNKNOWN) : SOURCE_UNKNOWN;
        this.okButton = okButton;
        this.cancelButton = cancelButton;
        this.registry = Registry.get(this.getClass());
        this.initComponents();
        this.setPreferredSize(new Dimension(this.registry.get("sourceWindowWidth", this.getPreferredSize().width), this.registry.get("sourceWindowHeight", this.getPreferredSize().height)));
        this.jSplitPane.setDividerLocation(this.registry.get("sourceSplitDividerLocation", this.jSplitPane.getDividerLocation()));
        this.jSplitPane1.setDividerLocation(this.registry.get("sourceMediaTextSplitDividerLocation", this.jSplitPane1.getDividerLocation()));
        this.displayIconAndTitle();
        this.sourceList.setCellRenderer(new ListEntryCellRenderer());
        okButton.setEnabled(false);
        this.textFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.filter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.filter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            private void filter() {
                SourceChooser.this.filterModel();
            }
        });
        this.worker = null;
        this.jScrollPaneSource.getViewport().addChangeListener(e -> this.executeWorker());
        this.createSourceThumbs();
        this.filteredModel.clear();
        for (SourceThumb item : this.allSource) {
            this.filteredModel.addElement(item);
        }
        SwingUtilities.invokeLater(() -> {
            this.filterModel();
            this.selectSource(this.mainSource);
        });
    }

    private void executeWorker() {
        if (this.worker != null && !this.worker.isDone()) {
            this.worker.cancel(true);
        }
        this.worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                for (int i = SourceChooser.this.sourceList.getFirstVisibleIndex(); i <= SourceChooser.this.sourceList.getLastVisibleIndex() && !this.isCancelled(); ++i) {
                    SourceThumb sourceThumb = SourceChooser.this.sourceList.getModel().getElementAt(i);
                    sourceThumb.setIcon();
                    SourceChooser.this.jScrollPaneSource.getViewport().repaint();
                    if (this.isCancelled()) break;
                }
                return null;
            }
        };
        this.worker.execute();
    }

    private void selectSource(SourceWrapper source) {
        SourceThumb selectedSource = null;
        String memorizedSourceId = this.registry.get("sourceSelected", "");
        for (SourceThumb sourcei : this.allSource) {
            if (source == null && sourcei.entity == null) {
                selectedSource = sourcei;
            }
            if (source == null && sourcei.getId().equals(memorizedSourceId)) {
                selectedSource = sourcei;
            }
            if (source == null || sourcei.entity == null || !sourcei.entity.equals(source.getTargetSource())) continue;
            selectedSource = sourcei;
            break;
        }
        if (selectedSource != null) {
            SourceThumb sourcei = selectedSource;
            WindowManager.getDefault().invokeWhenUIReady(() -> {
                this.sourceList.setSelectedValue(sourcei, true);
                this.sourceList.scrollRectToVisible(this.sourceList.getCellBounds(this.sourceList.getMinSelectionIndex(), this.sourceList.getMaxSelectionIndex()));
                this.textFilter.requestFocus();
            });
        }
    }

    public void filterModel() {
        this.filterModel(this.textFilter.getText());
    }

    public void filterModel(String filter) {
        if (this.sourceList == null) {
            return;
        }
        this.sourceList.clearSelection();
        this.sourceList.setModel(new DefaultListModel());
        this.filteredModel.clear();
        this.allSource.stream().filter(item -> item.searchContent.toLowerCase().contains(filter.toLowerCase())).sorted(this.thumbComparator).forEachOrdered(item -> this.filteredModel.addElement((SourceThumb)item));
        this.sourceList.setModel(this.filteredModel);
        SwingUtilities.invokeLater(() -> this.executeWorker());
    }

    private void displayIconAndTitle() {
        WindowManager.getDefault().invokeWhenUIReady(() -> this.displayIconAndTitle(this.sourceMedia.getWidth()));
    }

    private void displayIconAndTitle(int width) {
        if (this.mainText != null && !this.mainText.isEmpty()) {
            this.sourceText.setText(this.mainText);
            this.sourceText.setCaretPosition(0);
        } else {
            this.sourceText.setText(NbBundle.getMessage(this.getClass(), (String)"SourceChooser.noSourceText.text"));
        }
        if (this.mainImage != null) {
            this.imagePanel.setMedia(this.mainFile, SOURCE_UNKNOWN);
        }
        this.photoTitle.setText("<html><center>&nbsp;" + this.mainTitle + "&nbsp;</center></html>");
        this.photoTitle.setPreferredSize(new Dimension(width, -1));
    }

    private void initComponents() {
        this.jSplitPane = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.photoTitle = new JLabel();
        this.jSplitPane1 = new JSplitPane();
        this.imagePanel = new ImagePanel(null);
        this.sourceMedia = this.imagePanel;
        this.jScrollPane1 = new JScrollPane();
        this.sourceText = new JTextArea();
        this.jPanel2 = new JPanel();
        this.filterLabel = new JLabel();
        this.textFilter = new JTextField();
        this.jScrollPaneSource = new JScrollPane();
        this.sourceList = new JList<SourceThumb>(this.filteredModel);
        this.jLabel1 = new JLabel();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                SourceChooser.this.formComponentResized(evt);
            }
        });
        this.jSplitPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SourceChooser.this.jSplitPanePropertyChange(evt);
            }
        });
        this.jPanel1.setPreferredSize(new Dimension(200, 383));
        this.photoTitle.setFont(new Font("DejaVu Sans", 1, 12));
        this.photoTitle.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.photoTitle, (String)NbBundle.getMessage(SourceChooser.class, (String)"SourceChooser.photoTitle.text"));
        this.photoTitle.setVerticalAlignment(1);
        this.photoTitle.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.jSplitPane1.setDividerLocation(240);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SourceChooser.this.jSplitPane1PropertyChange(evt);
            }
        });
        this.sourceMedia.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                SourceChooser.this.sourceMediaComponentResized(evt);
            }
        });
        GroupLayout sourceMediaLayout = new GroupLayout(this.sourceMedia);
        this.sourceMedia.setLayout(sourceMediaLayout);
        sourceMediaLayout.setHorizontalGroup(sourceMediaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        sourceMediaLayout.setVerticalGroup(sourceMediaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 239, Short.MAX_VALUE));
        this.jSplitPane1.setTopComponent(this.sourceMedia);
        this.sourceText.setEditable(false);
        this.sourceText.setColumns(20);
        this.sourceText.setFont(new Font("DejaVu Sans", 2, 12));
        this.sourceText.setLineWrap(true);
        this.sourceText.setRows(5);
        this.sourceText.setText(NbBundle.getMessage(SourceChooser.class, (String)"SourceChooser.sourceText.text"));
        this.sourceText.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.sourceText);
        this.jSplitPane1.setRightComponent(this.jScrollPane1);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSplitPane1, GroupLayout.Alignment.LEADING, -2, 0, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.photoTitle, -1, 188, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jSplitPane1, -1, 362, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.photoTitle)));
        this.jSplitPane.setLeftComponent(this.jPanel1);
        this.jPanel2.setPreferredSize(new Dimension(200, 58));
        Mnemonics.setLocalizedText((JLabel)this.filterLabel, (String)NbBundle.getMessage(SourceChooser.class, (String)"SourceChooser.filterLabel.text"));
        this.textFilter.setText(NbBundle.getMessage(SourceChooser.class, (String)"SourceChooser.textFilter.text"));
        this.sourceList.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.sourceList.setFont(new Font("DejaVu Sans Condensed", 0, 10));
        this.sourceList.setSelectionMode(0);
        this.sourceList.setLayoutOrientation(2);
        this.sourceList.setVisibleRowCount(-1);
        this.sourceList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SourceChooser.this.sourceListMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                SourceChooser.this.sourceListMousePressed(evt);
            }
        });
        this.sourceList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SourceChooser.this.sourceListValueChanged(evt);
            }
        });
        this.jScrollPaneSource.setViewportView(this.sourceList);
        this.jLabel1.setFont(new Font("DejaVu Sans", 0, 10));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SourceChooser.class, (String)"SourceChooser.jLabel1.text"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneSource).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.filterLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFilter, -1, 102, Short.MAX_VALUE)))).addGroup(jPanel2Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel1, -1, 182, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.filterLabel).addComponent(this.textFilter, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneSource, -1, 326, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.jLabel1, -2, 16, -2)));
        this.jSplitPane.setRightComponent(this.jPanel2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, GroupLayout.Alignment.TRAILING));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, GroupLayout.Alignment.TRAILING));
    }

    private void sourceListValueChanged(ListSelectionEvent evt) {
        if (!this.sourceList.isSelectionEmpty()) {
            SourceThumb source = this.filteredModel.get(this.sourceList.getSelectedIndex());
            this.mainImage = source.getImage();
            this.mainTitle = source.title;
            this.mainFile = source.file;
            this.mainText = source.text;
            this.displayIconAndTitle();
            this.okButton.setEnabled(source.isSource);
            this.okButton.setToolTipText(source.isSource ? null : NbBundle.getMessage(this.getClass(), (String)"SourceChooser.sourceNotAnEntity.tip"));
            this.registry.put("sourceSelected", source.getId());
        } else {
            this.okButton.setEnabled(false);
        }
    }

    private void sourceListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.okButton.doClick();
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        int h;
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int w = evt.getComponent().getWidth();
        if (w > dim.width * 8 / 10) {
            w = dim.width * 8 / 10;
        }
        if ((h = evt.getComponent().getHeight()) > dim.height * 8 / 10) {
            h = dim.height * 8 / 10;
        }
        this.registry.put("sourceWindowWidth", w);
        this.registry.put("sourceWindowHeight", h);
    }

    private void jSplitPanePropertyChange(PropertyChangeEvent evt) {
        this.registry.put("sourceSplitDividerLocation", this.jSplitPane.getDividerLocation());
    }

    private void sourceListMousePressed(MouseEvent evt) {
        if (evt.getButton() == 3) {
            this.sourceList.setSelectedIndex(this.sourceList.locationToIndex(evt.getPoint()));
            JPopupMenu menu = new JPopupMenu();
            SourceThumb source = this.getSelectedThumb();
            Entity entity = source.entity;
            if (entity != null) {
                Entity[] ents = PropertyXRef.getReferences((Entity)entity);
                if (source.isSource && ents.length > 0) {
                    for (Entity ent : ents) {
                        JMenuItem menuItem = new JMenuItem(NbBundle.getMessage(MediaChooser.class, (String)"EditEntity", (Object)ent.toString(true)));
                        menu.add(menuItem);
                        Entity finalEntity = ent;
                        menuItem.addActionListener(ae -> this.edit(finalEntity));
                    }
                } else if (!source.isSource) {
                    JMenuItem menuItem = new JMenuItem(NbBundle.getMessage(MediaChooser.class, (String)"EditEntity", (Object)entity.toString(true)));
                    menu.add(menuItem);
                    menuItem.addActionListener(ae -> this.edit(entity));
                }
                MenuScroller.addSettingsAction((JPopupMenu)menu);
                MenuScroller.setScrollerFor((JPopupMenu)menu, (int)Math.min(menu.getSubElements().length + 2, MenuScroller.getMenuScrollerSize()), (int)40, (int)0, (int)0);
                menu.show(this.sourceList, evt.getX(), evt.getY());
            }
        }
    }

    private void sourceMediaComponentResized(ComponentEvent evt) {
        this.displayIconAndTitle();
    }

    private void jSplitPane1PropertyChange(PropertyChangeEvent evt) {
        this.registry.put("sourceMediaTextSplitDividerLocation", this.jSplitPane1.getDividerLocation());
    }

    private void edit(Entity entity) {
        this.cancelButton.doClick();
        SelectionDispatcher.fireSelection((Context)new Context(entity));
    }

    private void createSourceThumbs() {
        String[] ENTITIES;
        this.allSource.clear();
        this.allSource.add(new SourceThumb());
        for (String type : ENTITIES = new String[]{"INDI", "FAM", "SUBM"}) {
            Collection entities = this.gedcom.getEntities(type);
            for (Entity entity : entities) {
                List properties = entity.getAllProperties("SOUR");
                for (Property sourceProp : properties) {
                    if (sourceProp instanceof PropertySource) continue;
                    String title = sourceProp.getValue().trim();
                    boolean flag = !title.isEmpty();
                    String text = "";
                    Property sourceTextLocal = sourceProp.getProperty("TEXT");
                    if (sourceTextLocal != null && !sourceTextLocal.getDisplayValue().trim().isEmpty()) {
                        text = sourceTextLocal.getDisplayValue().trim();
                    }
                    Property sourceObje = sourceProp.getProperty("OBJE");
                    if (!flag) {
                        Property sourceFileTitl;
                        Property property = sourceFileTitl = sourceObje != null ? sourceObje.getProperty("TITL") : null;
                        if (sourceFileTitl != null && !sourceFileTitl.getDisplayValue().trim().isEmpty()) {
                            title = sourceFileTitl.getDisplayValue().trim();
                            flag = true;
                        } else {
                            title = entity.toString(false).trim();
                            flag = false;
                        }
                    }
                    Property sourceFile = sourceObje != null ? sourceObje.getProperty("FILE") : null;
                    InputSource is = null;
                    if (sourceFile instanceof PropertyFile) {
                        PropertyFile propertyFile = (PropertyFile)sourceFile;
                        is = propertyFile.getInput().orElse(null);
                    }
                    SourceThumb source = new SourceThumb(sourceProp, entity, is, title, text);
                    source.setTrueTitle(flag);
                    this.allSource.add(source);
                }
            }
        }
        Collection entities = this.gedcom.getEntities("SOUR");
        for (Source entity : entities) {
            Property propMedia;
            InputSource file = null;
            String title = "";
            boolean flag = false;
            Property propTitle = entity.getProperty("TITL", true);
            if (propTitle != null) {
                title = propTitle.getDisplayValue().trim();
                flag = true;
            }
            String text = "";
            Property propText = entity.getProperty("TEXT");
            if (propText != null && !propText.getDisplayValue().trim().isEmpty()) {
                text = propText.getDisplayValue().trim();
            }
            if ((propMedia = entity.getProperty("OBJE", true)) != null && propMedia.isValid() && propMedia instanceof PropertyMedia) {
                PropertyMedia pm = (PropertyMedia)propMedia;
                file = ((Media)pm.getTargetEntity().get()).getFile();
            }
            SourceThumb source = new SourceThumb((Property)entity, entity, file, title, text);
            source.setTrueTitle(flag);
            Entity[] ents = PropertyXRef.getReferences((Entity)entity);
            source.setUnused(ents.length == 0);
            this.allSource.add(source);
        }
    }

    private SourceThumb getSelectedThumb() {
        return this.filteredModel.get(this.sourceList.getSelectedIndex());
    }

    public boolean isSelectedEntitySource() {
        SourceThumb source = this.getSelectedThumb();
        return source == null ? false : source.isSource;
    }

    public Entity getSelectedEntity() {
        SourceThumb source = this.getSelectedThumb();
        return source == null ? null : source.entity;
    }

    public InputSource getSelectedInput() {
        SourceThumb source = this.getSelectedThumb();
        return source == null ? null : source.file;
    }

    public String getSelectedTitle() {
        SourceThumb source = this.getSelectedThumb();
        return source == null ? "" : source.title;
    }

    public int getNbSource() {
        return this.allSource.size();
    }

    private class ThumbComparator
    implements Comparator<SourceThumb> {
        private ThumbComparator() {
        }

        @Override
        public int compare(SourceThumb o1, SourceThumb o2) {
            String ent1 = o1.entity == null ? "0" : "1";
            String ent2 = o2.entity == null ? "0" : "1";
            InputSource file1 = o1.file;
            InputSource file2 = o2.file;
            String str1 = file1 != null ? file1.getName() : "";
            String str2 = file2 != null ? file2.getName() : "";
            String id1 = o1.entity != null ? o1.entity.getId() : "";
            String id2 = o2.entity != null ? o2.entity.getId() : "";
            String total1 = ent1 + o1.title.toLowerCase() + str1 + id1;
            String total2 = ent2 + o2.title.toLowerCase() + str2 + id2;
            return total1.compareTo(total2);
        }
    }

    private static class ListEntryCellRenderer
    extends JLabel
    implements ListCellRenderer<SourceThumb> {
        private ListEntryCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends SourceThumb> list, SourceThumb value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(1);
            int labelWidth = THUMB_WIDTH + 30;
            int nbLines = this.getFontMetrics(this.getFont()).stringWidth(value.title) / labelWidth + 3;
            int labelHeight = THUMB_HEIGHT + 12 * nbLines;
            this.setPreferredSize(new Dimension(labelWidth, labelHeight));
            boolean isDarkTheme = UIManager.getBoolean("nb.dark.theme");
            String color = value.isTrueTitle && !value.isUnused ? (isDarkTheme ? "white" : "black") : (!value.isTrueTitle && !value.isUnused ? (isDarkTheme ? "#5066FF" : "blue") : "red");
            String prefix = value.getId().isEmpty() ? "" : "(" + value.getId() + ") ";
            String text = prefix + value.title;
            if (value.entity == null) {
                text = "<center><i><b>" + text + "</b></i></center>";
            }
            this.setText("<html><center><font color=" + color + ">" + text + "</font></center></html>");
            this.setIcon(value.icon);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                this.setBorder(BorderFactory.createRaisedBevelBorder());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
                this.setBorder(BorderFactory.createEmptyBorder());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(false);
            return this;
        }
    }

    public class SourceThumb {
        public String id = "";
        public String ref = "";
        public boolean isSource = false;
        public Entity entity = null;
        public InputSource file = null;
        public ImageIcon icon = null;
        public String title = "";
        public String text = "";
        public boolean isTrueTitle = true;
        public boolean isUnused = false;
        public String searchContent = "";

        private SourceThumb() {
            this.id = "";
            this.ref = "";
            this.isSource = true;
            this.entity = null;
            this.title = NbBundle.getMessage(this.getClass(), (String)"NewSourceTitle");
            this.icon = DEFAULT_ICON;
        }

        private SourceThumb(Property origin, Source entity, InputSource file, String title, String text) {
            String caln;
            this.id = origin.getEntity().getId();
            this.ref = origin.getEntity().getId() + "-" + origin.getPath(true).toString();
            this.isSource = true;
            this.entity = entity;
            this.file = file;
            Entity[] ents = PropertyXRef.getReferences((Entity)entity);
            if (title.isBlank()) {
                for (Entity ent : ents) {
                    if (!(ent instanceof Indi)) continue;
                    Indi indi = (Indi)ent;
                    this.title = indi.toString(true);
                    break;
                }
                if (this.title.isBlank()) {
                    for (Entity ent : ents) {
                        if (!(ent instanceof Fam)) continue;
                        Fam fam = (Fam)ent;
                        this.title = fam.toString(true);
                        break;
                    }
                }
            } else {
                this.title = title;
            }
            this.title = this.title + (String)(!(caln = entity.getCaln()).isBlank() ? "<br>[" + caln + "]" : "<br>") + " (" + ents.length + ")";
            this.text = text;
            this.searchContent = this.getSearchContent();
        }

        private SourceThumb(Property origin, Entity entity, InputSource file, String title, String text) {
            this.id = entity.getId();
            this.ref = entity.getId() + "-" + origin.getPath(true).toString().replaceAll("\\?0", "");
            this.isSource = entity instanceof Source;
            this.entity = entity;
            this.file = file;
            this.title = title;
            this.text = text;
            this.searchContent = this.getSearchContent();
        }

        public Image getImage() {
            return MediaUtils.getImageFromFile((InputSource)this.file, this.getClass(), (BufferedImage)MediaUtils.IMG_NO_SOURCE_MEDIA, (boolean)this.text.trim().isEmpty());
        }

        public void setIcon() {
            ImageIcon imageIcon = this.icon = this.file == null ? null : cacheIcon.get(this.file.getLocation());
            if (this.icon == null) {
                this.icon = new ImageIcon(MediaUtils.scaleImage((InputSource)this.file, this.getClass(), (int)THUMB_WIDTH, (int)THUMB_HEIGHT, (boolean)this.text.trim().isEmpty(), (BufferedImage)MediaUtils.IMG_NO_SOURCE_MEDIA));
                if (this.file != null) {
                    cacheIcon.put(this.file.getLocation(), this.icon);
                } else {
                    this.icon = DEFAULT_ICON;
                }
            }
        }

        private void setTrueTitle(boolean flag) {
            this.isTrueTitle = flag;
        }

        private void setUnused(boolean b) {
            this.isUnused = b;
        }

        private String getId() {
            return this.isSource ? this.id : this.ref;
        }

        private String getSearchContent() {
            WordBuffer wb = new WordBuffer(" ");
            wb.append(this.id);
            wb.append(this.title);
            if (this.isSource && this.entity != null) {
                Source source = (Source)this.entity;
                wb.append(source.getAbbreviation());
                wb.append(source.getAuthor());
                wb.append(source.getRepoName());
                wb.append(source.getCaln());
            }
            wb.append(this.text);
            return wb.toString();
        }
    }
}

