/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import genj.gedcom.TagPath;
import genj.io.GedcomEncodingSniffer;
import genj.io.GedcomFormatException;
import genj.io.PropertyReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.openide.util.Exceptions;

public class GedcomFileReader
extends PropertyReader {
    private String theLine = "";
    private TagPath path = null;
    private Charset charset = null;
    private boolean isSnifferDeterministic = true;

    public TagPath getPath() {
        return this.path;
    }

    public static GedcomFileReader create(File fileIn) {
        Charset charset;
        GedcomEncodingSniffer sniffer;
        try {
            sniffer = new GedcomEncodingSniffer(new BufferedInputStream(new FileInputStream(fileIn)));
            charset = sniffer.getCharset();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        GedcomFileReader reader = new GedcomFileReader(new InputStreamReader((InputStream)sniffer, charset));
        reader.setCharset(charset);
        reader.setCharsetDeterministic(sniffer.isDeterministic());
        return reader;
    }

    private GedcomFileReader(Reader in) {
        super(in, null, false);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public boolean isCharsetDeterministic() {
        return this.isSnifferDeterministic;
    }

    public void setCharsetDeterministic(boolean isDeterministic) {
        this.isSnifferDeterministic = isDeterministic;
    }

    public String getValue() {
        return this.value;
    }

    public String getXref() {
        return this.xref;
    }

    public int getLevel() {
        return this.level;
    }

    public String getNextLine(boolean consume) throws IOException {
        boolean ret = this.readLine(false, true);
        this.theLine = this.line;
        if (!ret && this.tag == null) {
            throw new GedcomFormatException(RESOURCES.getString("read.error.norecord"), 0);
        }
        if (this.level <= 0) {
            this.path = new TagPath(this.tag);
        } else {
            try {
                this.path = new TagPath(new TagPath(this.path, this.level), this.tag);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new GedcomFormatException(RESOURCES.getString("read.warn.badlevel", this.level), this.lines);
            }
        }
        if (consume) {
            this.line = null;
        }
        return this.theLine;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public String getTag() {
        return this.tag;
    }

    public String getLine() {
        return this.theLine;
    }

    public String getRawLine() {
        int i;
        while (this.line == null) {
            try {
                this.line = this.in.readLine();
            }
            catch (IOException ex) {
                return null;
            }
            if (this.line == null) {
                return null;
            }
            ++this.lines;
        }
        for (i = 0; i < this.line.length() && Character.isWhitespace(this.line.charAt(i)); ++i) {
        }
        this.line = this.line.substring(i);
        String[] splitLine = this.line.split("\\s", -1);
        int current_token = 0;
        try {
            this.level = Integer.parseInt(splitLine[current_token], 10);
            if (this.level < 20) {
                ++current_token;
            } else {
                this.level = -1;
            }
        }
        catch (NumberFormatException nfe) {
            this.level = -1;
        }
        if (splitLine.length > 0) {
            while (current_token < splitLine.length) {
                this.tag = splitLine[current_token];
                ++current_token;
                if (this.tag == null || this.tag.isEmpty()) continue;
                break;
            }
        } else {
            this.tag = "????";
        }
        if (this.level == 0 && this.tag.startsWith("@")) {
            if (!this.tag.endsWith("@") || this.tag.length() <= 2) {
                while (current_token < splitLine.length && !this.tag.endsWith("@")) {
                    this.tag = this.tag + " " + splitLine[current_token];
                    ++current_token;
                }
            }
            if (!this.tag.endsWith("@") || this.tag.length() <= 2) {
                this.xref = "?";
                this.tag = "????" + this.tag.substring(1, this.tag.length());
            } else {
                this.xref = this.tag.substring(1, this.tag.length() - 1);
                if (current_token < splitLine.length) {
                    this.tag = splitLine[current_token];
                    ++current_token;
                } else {
                    this.tag = "????";
                }
            }
        } else {
            this.xref = "";
        }
        this.tag = this.tag.intern();
        if (current_token < splitLine.length) {
            this.value = splitLine[current_token];
            ++current_token;
            while (current_token < splitLine.length) {
                this.value = this.value + " " + splitLine[current_token];
                ++current_token;
            }
        } else {
            this.value = "";
        }
        if (this.level == 0) {
            this.path = new TagPath(this.tag);
        } else if (this.level > 0) {
            try {
                this.path = new TagPath(new TagPath(this.path, this.level), this.tag);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                for (int j = this.path.length(); j < this.level; ++j) {
                    this.path = new TagPath(new TagPath(this.path, j), "_LEVEL_PATCHED");
                }
                this.path = new TagPath(new TagPath(this.path, this.level), this.tag);
            }
        }
        this.theLine = this.line;
        this.line = null;
        return this.theLine;
    }
}

