/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.netstream;

import java.lang.reflect.Array;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import org.graphstream.stream.binary.ByteDecoder;
import org.graphstream.stream.binary.ByteEncoder;
import org.graphstream.stream.binary.ByteFactory;
import org.graphstream.stream.netstream.NetStreamConstants;
import org.graphstream.stream.netstream.NetStreamDecoder;
import org.graphstream.stream.netstream.NetStreamEncoder;

public class NetStreamUtils {
    private static ByteBuffer NULL_BUFFER = ByteBuffer.allocate(0);
    private static final Logger LOGGER = Logger.getLogger(NetStreamUtils.class.getName());

    public static ByteFactory getDefaultNetStreamFactory() {
        return new ByteFactory(){

            @Override
            public ByteEncoder createByteEncoder() {
                return new NetStreamEncoder(new ByteEncoder.Transport[0]);
            }

            @Override
            public ByteDecoder createByteDecoder() {
                return new NetStreamDecoder();
            }
        };
    }

    public static int getType(Object value) {
        int valueType = NetStreamConstants.TYPE_UNKNOWN;
        if (value == null) {
            return NetStreamConstants.TYPE_NULL;
        }
        Class<?> valueClass = value.getClass();
        boolean isArray = valueClass.isArray();
        if (isArray) {
            if (Array.getLength(value) > 0) {
                valueClass = Array.get(value, 0).getClass();
            } else {
                return NetStreamConstants.TYPE_ARRAY;
            }
        }
        if (valueClass.equals(Boolean.class)) {
            valueType = isArray ? NetStreamConstants.TYPE_BOOLEAN_ARRAY : NetStreamConstants.TYPE_BOOLEAN;
        } else if (valueClass.equals(Byte.class)) {
            valueType = isArray ? NetStreamConstants.TYPE_BYTE_ARRAY : NetStreamConstants.TYPE_BYTE;
        } else if (valueClass.equals(Short.class)) {
            valueType = isArray ? NetStreamConstants.TYPE_SHORT_ARRAY : NetStreamConstants.TYPE_SHORT;
        } else if (valueClass.equals(Integer.class)) {
            valueType = isArray ? NetStreamConstants.TYPE_INT_ARRAY : NetStreamConstants.TYPE_INT;
        } else if (valueClass.equals(Long.class)) {
            valueType = isArray ? NetStreamConstants.TYPE_LONG_ARRAY : NetStreamConstants.TYPE_LONG;
        } else if (valueClass.equals(Float.class)) {
            valueType = isArray ? NetStreamConstants.TYPE_FLOAT_ARRAY : NetStreamConstants.TYPE_FLOAT;
        } else if (valueClass.equals(Double.class)) {
            valueType = isArray ? NetStreamConstants.TYPE_DOUBLE_ARRAY : NetStreamConstants.TYPE_DOUBLE;
        } else if (valueClass.equals(String.class)) {
            valueType = isArray ? NetStreamConstants.TYPE_STRING_ARRAY : NetStreamConstants.TYPE_STRING;
        } else {
            LOGGER.warning(String.format("can not find type of %s.", valueClass));
        }
        return valueType;
    }

    public static int getVarintSize(long data) {
        if (data < 128L) {
            return 1;
        }
        if (data < 16384L) {
            return 2;
        }
        if (data < 0x200000L) {
            return 3;
        }
        if (data < 0x10000000L) {
            return 4;
        }
        if (data < 0x800000000L) {
            return 5;
        }
        if (data < 0x40000000000L) {
            return 6;
        }
        if (data < 0x2000000000000L) {
            return 7;
        }
        if (data < 0x100000000000000L) {
            return 8;
        }
        return 9;
    }

    public static void putVarint(ByteBuffer buffer, long number, int byteSize) {
        int i = 0;
        while (i < byteSize) {
            int head = 128;
            if (i == byteSize - 1) {
                head = 0;
            }
            long b = number >> 7 * i & 0x7FL ^ (long)head;
            buffer.put((byte)(b & 0xFFL));
            ++i;
        }
    }

    public static ByteBuffer encodeValue(Object in, int valueType) {
        if (NetStreamConstants.TYPE_BOOLEAN == valueType) {
            return NetStreamUtils.encodeBoolean(in);
        }
        if (NetStreamConstants.TYPE_BOOLEAN_ARRAY == valueType) {
            return NetStreamUtils.encodeBooleanArray(in);
        }
        if (NetStreamConstants.TYPE_BYTE == valueType) {
            return NetStreamUtils.encodeByte(in);
        }
        if (NetStreamConstants.TYPE_BYTE_ARRAY == valueType) {
            return NetStreamUtils.encodeByteArray(in);
        }
        if (NetStreamConstants.TYPE_SHORT == valueType) {
            return NetStreamUtils.encodeShort(in);
        }
        if (NetStreamConstants.TYPE_SHORT_ARRAY == valueType) {
            return NetStreamUtils.encodeShortArray(in);
        }
        if (NetStreamConstants.TYPE_INT == valueType) {
            return NetStreamUtils.encodeInt(in);
        }
        if (NetStreamConstants.TYPE_INT_ARRAY == valueType) {
            return NetStreamUtils.encodeIntArray(in);
        }
        if (NetStreamConstants.TYPE_LONG == valueType) {
            return NetStreamUtils.encodeLong(in);
        }
        if (NetStreamConstants.TYPE_LONG_ARRAY == valueType) {
            return NetStreamUtils.encodeLongArray(in);
        }
        if (NetStreamConstants.TYPE_FLOAT == valueType) {
            return NetStreamUtils.encodeFloat(in);
        }
        if (NetStreamConstants.TYPE_FLOAT_ARRAY == valueType) {
            return NetStreamUtils.encodeFloatArray(in);
        }
        if (NetStreamConstants.TYPE_DOUBLE == valueType) {
            return NetStreamUtils.encodeDouble(in);
        }
        if (NetStreamConstants.TYPE_DOUBLE_ARRAY == valueType) {
            return NetStreamUtils.encodeDoubleArray(in);
        }
        if (NetStreamConstants.TYPE_STRING == valueType) {
            return NetStreamUtils.encodeString(in);
        }
        if (NetStreamConstants.TYPE_STRING_ARRAY == valueType) {
            return NetStreamUtils.encodeStringArray(in);
        }
        if (NetStreamConstants.TYPE_ARRAY == valueType) {
            return NetStreamUtils.encodeArray(in);
        }
        if (NetStreamConstants.TYPE_NULL == valueType) {
            return NULL_BUFFER;
        }
        return null;
    }

    public static ByteBuffer encodeUnsignedVarint(Object in) {
        long data = ((Number)in).longValue();
        int size = NetStreamUtils.getVarintSize(data);
        ByteBuffer buff = ByteBuffer.allocate(size);
        int i = 0;
        while (i < size) {
            int head = 128;
            if (i == size - 1) {
                head = 0;
            }
            long b = data >> 7 * i & 0x7FL ^ (long)head;
            buff.put((byte)(b & 0xFFL));
            ++i;
        }
        buff.rewind();
        return buff;
    }

    public static ByteBuffer encodeVarint(Object in) {
        long data = ((Number)in).longValue();
        return NetStreamUtils.encodeUnsignedVarint(data >= 0L ? data << 1 : Math.abs(data) << 1 ^ 1L);
    }

    public static ByteBuffer encodeString(Object in) {
        String s = (String)in;
        byte[] data = s.getBytes(Charset.forName("UTF-8"));
        ByteBuffer lenBuff = NetStreamUtils.encodeUnsignedVarint(data.length);
        ByteBuffer bb = ByteBuffer.allocate(lenBuff.capacity() + data.length);
        bb.put(lenBuff).put(data);
        bb.rewind();
        return bb;
    }

    public static ByteBuffer encodeArray(Object in) {
        return null;
    }

    public static ByteBuffer encodeDoubleArray(Object in) {
        Object[] data = (Object[])in;
        int ssize = NetStreamUtils.getVarintSize(data.length);
        ByteBuffer b = ByteBuffer.allocate(ssize + data.length * 8);
        NetStreamUtils.putVarint(b, data.length, ssize);
        int i = 0;
        while (i < data.length) {
            b.putDouble((Double)data[i]);
            ++i;
        }
        b.rewind();
        return b;
    }

    public static ByteBuffer encodeStringArray(Object in) {
        Object[] data = (Object[])in;
        int ssize = NetStreamUtils.getVarintSize(data.length);
        byte[][] dataArray = new byte[data.length][];
        ByteBuffer[] lenBuffArray = new ByteBuffer[data.length];
        int bufferSize = 0;
        int i = 0;
        while (i < data.length) {
            ByteBuffer lenBuff;
            byte[] bs = ((String)data[i]).getBytes(Charset.forName("UTF-8"));
            dataArray[i] = bs;
            lenBuffArray[i] = lenBuff = NetStreamUtils.encodeUnsignedVarint(bs.length);
            bufferSize += lenBuff.capacity() + bs.length;
            ++i;
        }
        ByteBuffer bb = ByteBuffer.allocate(ssize + bufferSize);
        NetStreamUtils.putVarint(bb, data.length, ssize);
        int i2 = 0;
        while (i2 < data.length) {
            bb.put(lenBuffArray[i2]).put(dataArray[i2]);
            ++i2;
        }
        bb.rewind();
        return bb;
    }

    public static ByteBuffer encodeDouble(Object in) {
        ByteBuffer bb = ByteBuffer.allocate(8).putDouble((Double)in);
        bb.rewind();
        return bb;
    }

    public static ByteBuffer encodeFloatArray(Object in) {
        Object[] data = (Object[])in;
        int ssize = NetStreamUtils.getVarintSize(data.length);
        ByteBuffer b = ByteBuffer.allocate(ssize + data.length * 4);
        NetStreamUtils.putVarint(b, data.length, ssize);
        int i = 0;
        while (i < data.length) {
            b.putFloat(((Float)data[i]).floatValue());
            ++i;
        }
        b.rewind();
        return b;
    }

    public static ByteBuffer encodeFloat(Object in) {
        ByteBuffer b = ByteBuffer.allocate(4);
        b.putFloat(((Float)in).floatValue());
        b.rewind();
        return b;
    }

    public static ByteBuffer encodeLongArray(Object in) {
        return NetStreamUtils.encodeVarintArray(in);
    }

    public static ByteBuffer encodeLong(Object in) {
        return NetStreamUtils.encodeVarint(in);
    }

    public static ByteBuffer encodeIntArray(Object in) {
        return NetStreamUtils.encodeVarintArray(in);
    }

    public static ByteBuffer encodeInt(Object in) {
        return NetStreamUtils.encodeVarint(in);
    }

    public static ByteBuffer encodeShortArray(Object in) {
        return NetStreamUtils.encodeVarintArray(in);
    }

    public static ByteBuffer encodeShort(Object in) {
        return NetStreamUtils.encodeVarint(in);
    }

    public static ByteBuffer encodeByteArray(Object in) {
        Object[] data = (Object[])in;
        int ssize = NetStreamUtils.getVarintSize(data.length);
        ByteBuffer b = ByteBuffer.allocate(ssize + data.length);
        NetStreamUtils.putVarint(b, data.length, ssize);
        int i = 0;
        while (i < data.length) {
            b.put((Byte)data[i]);
            ++i;
        }
        b.rewind();
        return b;
    }

    public static ByteBuffer encodeByte(Object in) {
        ByteBuffer b = ByteBuffer.allocate(1);
        b.put((Byte)in);
        b.rewind();
        return b;
    }

    public static ByteBuffer encodeBooleanArray(Object in) {
        Object[] data = (Object[])in;
        int ssize = NetStreamUtils.getVarintSize(data.length);
        ByteBuffer b = ByteBuffer.allocate(ssize + data.length);
        NetStreamUtils.putVarint(b, data.length, ssize);
        int i = 0;
        while (i < data.length) {
            b.put((byte)((Boolean)data[i] != false ? 1 : 0));
            ++i;
        }
        b.rewind();
        return b;
    }

    public static ByteBuffer encodeBoolean(Object in) {
        ByteBuffer b = ByteBuffer.allocate(1);
        b.put((byte)((Boolean)in != false ? 1 : 0));
        b.rewind();
        return b;
    }

    public static ByteBuffer encodeVarintArray(Object in) {
        Object[] data = (Object[])in;
        int[] sizes = new int[data.length];
        long[] zigzags = new long[data.length];
        int sumsizes = 0;
        int i = 0;
        while (i < data.length) {
            long datum = ((Number)data[i]).longValue();
            zigzags[i] = datum > 0L ? datum << 1 : Math.abs(datum) << 1 ^ 1L;
            sizes[i] = NetStreamUtils.getVarintSize(zigzags[i]);
            sumsizes += sizes[i];
            ++i;
        }
        int ssize = NetStreamUtils.getVarintSize(data.length);
        ByteBuffer b = ByteBuffer.allocate(ssize + sumsizes);
        NetStreamUtils.putVarint(b, data.length, ssize);
        int i2 = 0;
        while (i2 < data.length) {
            NetStreamUtils.putVarint(b, zigzags[i2], sizes[i2]);
            ++i2;
        }
        b.rewind();
        return b;
    }

    public static int decodeType(ByteBuffer bb) {
        try {
            return bb.get();
        }
        catch (BufferUnderflowException e) {
            LOGGER.info("decodeType: could not decode type");
            e.printStackTrace();
            return 0;
        }
    }

    public static Object decodeValue(ByteBuffer bb, int valueType) {
        if (NetStreamConstants.TYPE_BOOLEAN == valueType) {
            return NetStreamUtils.decodeBoolean(bb);
        }
        if (NetStreamConstants.TYPE_BOOLEAN_ARRAY == valueType) {
            return NetStreamUtils.decodeBooleanArray(bb);
        }
        if (NetStreamConstants.TYPE_BYTE == valueType) {
            return NetStreamUtils.decodeByte(bb);
        }
        if (NetStreamConstants.TYPE_BYTE_ARRAY == valueType) {
            return NetStreamUtils.decodeByteArray(bb);
        }
        if (NetStreamConstants.TYPE_SHORT == valueType) {
            return NetStreamUtils.decodeShort(bb);
        }
        if (NetStreamConstants.TYPE_SHORT_ARRAY == valueType) {
            return NetStreamUtils.decodeShortArray(bb);
        }
        if (NetStreamConstants.TYPE_INT == valueType) {
            return NetStreamUtils.decodeInt(bb);
        }
        if (NetStreamConstants.TYPE_INT_ARRAY == valueType) {
            return NetStreamUtils.decodeIntArray(bb);
        }
        if (NetStreamConstants.TYPE_LONG == valueType) {
            return NetStreamUtils.decodeLong(bb);
        }
        if (NetStreamConstants.TYPE_LONG_ARRAY == valueType) {
            return NetStreamUtils.decodeLongArray(bb);
        }
        if (NetStreamConstants.TYPE_FLOAT == valueType) {
            return NetStreamUtils.decodeFloat(bb);
        }
        if (NetStreamConstants.TYPE_FLOAT_ARRAY == valueType) {
            return NetStreamUtils.decodeFloatArray(bb);
        }
        if (NetStreamConstants.TYPE_DOUBLE == valueType) {
            return NetStreamUtils.decodeDouble(bb);
        }
        if (NetStreamConstants.TYPE_DOUBLE_ARRAY == valueType) {
            return NetStreamUtils.decodeDoubleArray(bb);
        }
        if (NetStreamConstants.TYPE_STRING == valueType) {
            return NetStreamUtils.decodeString(bb);
        }
        if (NetStreamConstants.TYPE_STRING_ARRAY == valueType) {
            return NetStreamUtils.decodeStringArray(bb);
        }
        if (NetStreamConstants.TYPE_ARRAY == valueType) {
            return NetStreamUtils.decodeArray(bb);
        }
        return null;
    }

    public static Object[] decodeArray(ByteBuffer bb) {
        int len = (int)NetStreamUtils.decodeUnsignedVarint(bb);
        Object[] array = new Object[len];
        int i = 0;
        while (i < len) {
            array[i] = NetStreamUtils.decodeValue(bb, NetStreamUtils.decodeType(bb));
            ++i;
        }
        return array;
    }

    public static String decodeString(ByteBuffer bb) {
        try {
            int len = (int)NetStreamUtils.decodeUnsignedVarint(bb);
            byte[] data = new byte[len];
            bb.get(data);
            return new String(data, Charset.forName("UTF-8"));
        }
        catch (BufferUnderflowException e) {
            LOGGER.info("decodeString: could not decode string");
            e.printStackTrace();
            return null;
        }
    }

    public static String[] decodeStringArray(ByteBuffer bb) {
        int len = (int)NetStreamUtils.decodeUnsignedVarint(bb);
        String[] array = new String[len];
        int i = 0;
        while (i < len) {
            array[i] = NetStreamUtils.decodeString(bb);
            ++i;
        }
        return array;
    }

    public static Boolean decodeBoolean(ByteBuffer bb) {
        byte data = 0;
        try {
            data = bb.get();
        }
        catch (BufferUnderflowException e) {
            LOGGER.info("decodeByte: could not decode");
            e.printStackTrace();
        }
        if (data != 0) {
            return true;
        }
        return false;
    }

    public static Byte decodeByte(ByteBuffer bb) {
        byte data = 0;
        try {
            data = bb.get();
        }
        catch (BufferUnderflowException e) {
            LOGGER.info("decodeByte: could not decode");
            e.printStackTrace();
        }
        return data;
    }

    public static long decodeUnsignedVarint(ByteBuffer bb) {
        try {
            int size = 0;
            long[] data = new long[9];
            do {
                data[size] = bb.get();
            } while ((data[++size - 1] & 0x80L) == 128L);
            long number = 0L;
            int i = 0;
            while (i < size) {
                number ^= (data[i] & 0x7FL) << (int)((long)i * 7L);
                ++i;
            }
            return number;
        }
        catch (BufferUnderflowException e) {
            LOGGER.info("decodeUnsignedVarintFromInteger: could not decode");
            e.printStackTrace();
            return 0L;
        }
    }

    public static long decodeVarint(ByteBuffer bb) {
        long number = NetStreamUtils.decodeUnsignedVarint(bb);
        return (number & 1L) == 0L ? number >> 1 : -(number >> 1);
    }

    public static Short decodeShort(ByteBuffer bb) {
        return (short)NetStreamUtils.decodeVarint(bb);
    }

    public static Integer decodeInt(ByteBuffer bb) {
        return (int)NetStreamUtils.decodeVarint(bb);
    }

    public static Long decodeLong(ByteBuffer bb) {
        return NetStreamUtils.decodeVarint(bb);
    }

    public static Float decodeFloat(ByteBuffer bb) {
        return Float.valueOf(bb.getFloat());
    }

    public static Double decodeDouble(ByteBuffer bb) {
        return bb.getDouble();
    }

    public static Integer[] decodeIntArray(ByteBuffer bb) {
        int len = (int)NetStreamUtils.decodeUnsignedVarint(bb);
        Integer[] res = new Integer[len];
        int i = 0;
        while (i < len) {
            res[i] = (int)NetStreamUtils.decodeVarint(bb);
            ++i;
        }
        return res;
    }

    public static Boolean[] decodeBooleanArray(ByteBuffer bb) {
        try {
            int len = (int)NetStreamUtils.decodeUnsignedVarint(bb);
            Boolean[] res = new Boolean[len];
            int i = 0;
            while (i < len) {
                byte b = bb.get();
                res[i] = b != 0;
                ++i;
            }
            return res;
        }
        catch (BufferUnderflowException e) {
            LOGGER.info("decodeBooleanArray: could not decode array");
            e.printStackTrace();
            return null;
        }
    }

    public static Byte[] decodeByteArray(ByteBuffer bb) {
        try {
            int len = (int)NetStreamUtils.decodeUnsignedVarint(bb);
            Byte[] res = new Byte[len];
            int i = 0;
            while (i < len) {
                res[i] = bb.get();
                ++i;
            }
            return res;
        }
        catch (BufferUnderflowException e) {
            LOGGER.info("decodeBooleanArray: could not decode array");
            e.printStackTrace();
            return null;
        }
    }

    public static Double[] decodeDoubleArray(ByteBuffer bb) {
        try {
            int len = (int)NetStreamUtils.decodeUnsignedVarint(bb);
            Double[] res = new Double[len];
            int i = 0;
            while (i < len) {
                res[i] = bb.getDouble();
                ++i;
            }
            return res;
        }
        catch (BufferUnderflowException e) {
            LOGGER.info("decodeDoubleArray: could not decode array");
            e.printStackTrace();
            return null;
        }
    }

    public static Float[] decodeFloatArray(ByteBuffer bb) {
        try {
            int len = (int)NetStreamUtils.decodeUnsignedVarint(bb);
            Float[] res = new Float[len];
            int i = 0;
            while (i < len) {
                res[i] = Float.valueOf(bb.getFloat());
                ++i;
            }
            return res;
        }
        catch (BufferUnderflowException e) {
            LOGGER.info("decodeFloatArray: could not decode array");
            e.printStackTrace();
            return null;
        }
    }

    public static Long[] decodeLongArray(ByteBuffer bb) {
        int len = (int)NetStreamUtils.decodeUnsignedVarint(bb);
        Long[] res = new Long[len];
        int i = 0;
        while (i < len) {
            res[i] = NetStreamUtils.decodeVarint(bb);
            ++i;
        }
        return res;
    }

    public static Short[] decodeShortArray(ByteBuffer bb) {
        int len = (int)NetStreamUtils.decodeUnsignedVarint(bb);
        Short[] res = new Short[len];
        int i = 0;
        while (i < len) {
            res[i] = (short)NetStreamUtils.decodeVarint(bb);
            ++i;
        }
        return res;
    }
}

