/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.api.imports.ImportFix;
import ancestris.modules.imports.gedcom.Bundle;
import ancestris.modules.imports.gedcom.FixesWindow;
import genj.gedcom.Context;
import genj.gedcom.TagPath;
import java.io.IOException;

public class ImportFamilyTreeMaker
extends Import {
    public boolean isGeneric() {
        return false;
    }

    public String toString() {
        return Bundle.importfamilytreemaker_name();
    }

    protected String getImportComment() {
        return Bundle.importfamilytreemaker_note();
    }

    public void showDetails(Context context, boolean extract) {
        new FixesWindow(this.summary, context, this.fixes).displayFixes(extract);
    }

    protected void firstPass() {
        super.firstPass();
        this.GEDCOM_VERSION = "5.5.1";
    }

    protected boolean process() throws IOException {
        String tag = this.input.getTag();
        TagPath path = this.input.getPath();
        String pathBefore = path.getShortName();
        String valueBefore = this.input.getValue();
        if ("HEAD:GEDC:VERS".equalsIgnoreCase(pathBefore)) {
            String valueAfter = this.GEDCOM_VERSION;
            if (!valueBefore.equals(valueAfter)) {
                this.output.writeLine(2, "VERS", this.GEDCOM_VERSION);
                this.fixes.add(new ImportFix(this.currentXref, "header.Version", pathBefore, pathBefore, valueBefore, valueAfter));
                return true;
            }
            return false;
        }
        if (this.input.getLevel() == 1 && this.input.getTag().equals("ALIA")) {
            this.output.writeLine(1, "NAME", this.input.getValue());
            this.fixes.add(new ImportFix(this.currentXref, "invalidTag.3", path.getShortName(), path.getParent().getShortName() + ":NAME", valueBefore, valueBefore));
            return true;
        }
        if ("OBJE:FILE:TEXT".equalsIgnoreCase(path.toString()) || "OBJE:FILE:DATE".equalsIgnoreCase(path.toString())) {
            this.output.writeLine(this.input.getLevel() - 1, "NOTE", this.input.getValue());
            this.fixes.add(new ImportFix(this.currentXref, "invalidTagLocation.2", path.getShortName(), "OBJE:NOTE", valueBefore, valueBefore));
            return true;
        }
        if ("OBJE:FILE:TEXT:CONC".equalsIgnoreCase(path.toString()) || "OBJE:FILE:TEXT:CONT".equalsIgnoreCase(path.toString())) {
            this.output.writeLine(this.input.getLevel() - 1, tag, this.input.getValue());
            return true;
        }
        return super.process();
    }
}

