/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import ancestris.reports.utils.ColorUtils;
import java.awt.Color;
import javax.swing.UIManager;

public class SimpleColorsOptions {
    public Color fgText = ColorUtils.string2color("#000000");
    public Color bgColor = ColorUtils.string2color("#ffffff");
    public Color bgHeaderRow = ColorUtils.string2color("#cccccc");
    public Color bgEvenRow = ColorUtils.string2color("#ffffff");
    public Color bgOddRow = ColorUtils.string2color("#eeeeee");
    private static final String BG_HEADER_ROW = "#cccccc";
    private static final String BG_ODD_ROW = "#eeeeee";
    protected static final String FG_TEXT = "#000000";
    protected static final String BG_COLOR = "#ffffff";
    private static final String BG_ODD_ROW_DARK = "#666666";

    public SimpleColorsOptions() {
        this.fgText = UIManager.getColor("Label.foreground");
        this.bgEvenRow = this.bgColor = UIManager.getColor("TextField.background");
        this.bgHeaderRow = UIManager.getColor("Panel.background");
        if (SimpleColorsOptions.getLuminosity(this.fgText) > SimpleColorsOptions.getLuminosity(this.bgColor)) {
            this.bgOddRow = ColorUtils.string2color(BG_ODD_ROW_DARK);
        }
    }

    public String getHeaderRowColor() {
        return ColorUtils.color2string(this.bgHeaderRow);
    }

    public String getEvenRowColor() {
        return ColorUtils.color2string(this.bgEvenRow);
    }

    public String getOddRowColor() {
        return ColorUtils.color2string(this.bgOddRow);
    }

    public String getTextColor() {
        return ColorUtils.color2string(this.fgText);
    }

    public String getBackgroundColor() {
        return ColorUtils.color2string(this.bgColor);
    }

    private static double getLuminosity(Color color) {
        return 0.299 * (double)color.getRed() + 0.587 * (double)color.getGreen() + 0.114 * (double)color.getBlue();
    }
}

