/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.calendar;

import ancestris.core.TextOptions;
import ancestris.reports.FilterOptions;
import ancestris.reports.FormatDateOptions;
import ancestris.reports.FormatFirstNameOptions;
import ancestris.reports.FormatIDOptions;
import ancestris.reports.FormatPlaceOptions;
import ancestris.reports.FormattingIcsOptions;
import ancestris.reports.FormattingOptions;
import ancestris.reports.ScopeIndiOptions;
import ancestris.reports.SimpleColorsOptions;
import ancestris.reports.utils.PropUtils;
import ancestris.util.swing.DialogManager;
import genj.fo.Document;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyEventDetails;
import genj.gedcom.PropertyHusband;
import genj.gedcom.PropertyWife;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.option.Multiline;
import genj.report.Report;
import java.time.Year;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ReportCalendar
extends Report {
    public MyFormattingOptions formattingOptions = new MyFormattingOptions();
    public ScopeIndiOptions scope = new ScopeIndiOptions();
    @Multiline
    public int[] eventSelector = new int[]{0, 1, 2, 3, 4};
    public String[] eventSelectors = PropUtils.getEventNames(TAGS);
    public boolean reportDay = true;
    public boolean reportEntity = true;
    public boolean reportEvent = true;
    public boolean reportDate = true;
    public boolean reportYears = true;
    public boolean reportPlace = true;
    public MyFilterOptions filterOptions = new MyFilterOptions();
    public MyDataFormatOptions dataFormatOptions = new MyDataFormatOptions();
    public SimpleColorsOptions colors = new SimpleColorsOptions();
    private Document doc;
    private Gedcom gedcom;
    private static final String SPAN_ALL = "number-columns-spanned=";
    private static final String[] TAGS = new String[]{"BIRT", "CHR", "MARR", "DEAT", "BURI"};

    public String accepts(Object context) {
        if (context instanceof Gedcom || context instanceof Indi || context instanceof Fam || context instanceof Indi[]) {
            return super.getName();
        }
        return null;
    }

    public Document start(Gedcom gedcom) {
        this.gedcom = gedcom;
        List<Indi> indis = this.scope.getScope(gedcom, this);
        return indis != null ? this.start((Indi[])indis.toArray(Indi[]::new)) : null;
    }

    public Document start(Entity entity) {
        this.gedcom = entity.getGedcom();
        List<Indi> indis = this.scope.getScope(entity, this);
        return indis != null ? this.start((Indi[])indis.toArray(Indi[]::new)) : null;
    }

    public Document start(Indi[] indis) {
        ArrayList events = new ArrayList();
        HashSet<Fam> seen = new HashSet<Fam>();
        for (Indi indi : indis) {
            events.addAll(indi.getProperties(PropertyEventDetails.class));
            for (Fam fam : indi.getFamiliesWhereSpouse()) {
                if (seen.contains(fam)) continue;
                events.addAll(fam.getProperties(PropertyEventDetails.class));
                seen.add(fam);
            }
        }
        return this.main(events);
    }

    /*
     * WARNING - void declaration
     */
    public Document main(List<? extends Property> events) {
        void var16_19;
        String dayLabel = this.translate("dayLabel");
        String entityLabel = this.translate("entityLabel");
        String eventLabel = Gedcom.getName((String)"EVEN");
        String dateLabel = Gedcom.getName((String)"DATE");
        String yearsLabel = this.translate("yearsLabel");
        String placeLabel = Gedcom.getName((String)"PLAC");
        String header_row = this.colors.getHeaderRowColor();
        String even_row = this.colors.getEvenRowColor();
        String odd_row = this.colors.getOddRowColor();
        String textColor = this.colors.getTextColor();
        String backColor = this.colors.getBackgroundColor();
        ArrayList<Event> records = new ArrayList<Event>();
        String selectedEventsFilter = PropUtils.getEventTags(this.eventSelector, TAGS);
        for (Property property : events) {
            if (!property.isEvent() || !(property instanceof PropertyEventDetails)) continue;
            PropertyEventDetails pEvent = (PropertyEventDetails)property;
            if (!property.getTag().matches(selectedEventsFilter)) continue;
            Event event = new Event(pEvent);
            if (this.filterOptions.hideDivorceMarriages && event.isDivorcedMarriage() || this.filterOptions.hideWidowMarriages && event.isWidowMarriage() || this.filterOptions.hideUnknown && (event.month == Integer.MAX_VALUE || event.day == Integer.MAX_VALUE) || !this.filterOptions.filter.matchRecord(property, event.getEntityString(), event.toString())) continue;
            records.add(event);
        }
        Collections.sort(records);
        if (this.formattingOptions.ics.isOutputICal) {
            this.formattingOptions.ics.createFile(this, "ReportCalendar", this.formattingOptions.common.internalOutput, records);
            return null;
        }
        String number = "" + records.size();
        String string = this.translate("title", new Object[]{number, this.gedcom.getDisplayName()});
        if (this.formattingOptions.calendarLayout && this.scope.scopeType == 2) {
            String string2 = this.translate("titleFamily", new Object[]{number, this.scope.getRootEntity().getDisplayTitle(false).split("\\(")[0].trim()});
        }
        this.doc = this.formattingOptions.common.createDocument(this.translate("name"), textColor, backColor);
        this.doc.startSection((String)var16_19, "title", 1, false, false, "font-size=" + this.formattingOptions.common.getTitleSize() + ",text-align=center, space-before=0cm, space-after=1cm");
        if (this.formattingOptions.calendarLayout) {
            return this.calendarLayout(records, header_row, even_row, odd_row, backColor);
        }
        if (this.formattingOptions.common.includeTOC) {
            this.doc.addTOC(2, false, false);
            this.doc.nextParagraph("space-before=1cm");
        }
        if (this.scope.isLimited()) {
            this.doc.addText(this.scope.getMainMessage(), "font-weight=bold");
            for (String[] stringArray : this.scope.getMessages()) {
                this.doc.nextParagraph();
                this.doc.addText("\u2219  " + stringArray[0]);
                if (stringArray[1].isBlank()) continue;
                this.doc.addText(" : " + stringArray[1], "font-weight=bold");
            }
            this.doc.nextParagraph("space-before=1cm");
        }
        if (this.filterOptions.filter.isFilterOn()) {
            this.doc.addText(this.filterOptions.filter.getMainMessage(), "font-weight=bold");
            List<String[]> filters = this.filterOptions.filter.getMessages();
            if (this.filterOptions.hideDivorceMarriages) {
                filters.add(new String[]{this.translate("hideDivorceMarriages"), ""});
            }
            if (this.filterOptions.hideWidowMarriages) {
                filters.add(new String[]{this.translate("hideWidowMarriages"), ""});
            }
            if (this.filterOptions.hideUnknown) {
                filters.add(new String[]{this.translate("hideUnknown"), ""});
            }
            for (String[] filterLine : filters) {
                this.doc.nextParagraph();
                this.doc.addText("\u2219  " + filterLine[0]);
                if (filterLine[1].isBlank()) continue;
                this.doc.addText(" : " + filterLine[1], "font-weight=bold");
            }
            this.doc.nextParagraph("space-before=1cm");
        }
        this.doc.startTable("genj:csv=true, width=100%, border-style=none, border=0, space-before=1cm, border-color=" + textColor);
        int nbColumns = this.getNbColumns();
        if (nbColumns == 0) {
            DialogManager.createError((String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"OptionError"), (String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ErrorNoColumnSelected")).show();
            return null;
        }
        String string3 = SPAN_ALL + nbColumns;
        int row = 0;
        String month = "---";
        for (Event event : records) {
            String newMonth = this.monthIntToString(event.getMonth());
            if (!newMonth.equals(month)) {
                month = newMonth;
                this.doc.nextTableRow();
                this.doc.nextTableCell(string3 + ", height=48px");
                int counter = this.getRecordsCount(records, event.getMonth());
                String eventTitle = month + " (" + counter + ")";
                if (this.formattingOptions.common.includeTOC) {
                    this.doc.addTOCEntry(eventTitle);
                    this.doc.nextParagraph();
                    this.doc.addLink("^^^", "title");
                }
                this.doc.nextTableRow("font-size=" + (this.formattingOptions.common.getTextSize() + 2) + ", text-align=center, font-weight=bold, background-color=" + header_row);
                this.doc.nextTableCell(string3);
                this.doc.addText(eventTitle);
                this.doc.nextTableRow("font-size=" + (this.formattingOptions.common.getTextSize() + 2) + ", text-align=center, font-weight=bold, background-color=" + header_row);
                if (this.reportDay) {
                    this.doc.nextTableCell();
                    this.doc.addText(dayLabel);
                }
                if (this.reportEntity) {
                    this.doc.nextTableCell();
                    this.doc.addText(entityLabel);
                }
                if (this.reportEvent) {
                    this.doc.nextTableCell();
                    this.doc.addText(eventLabel);
                }
                if (this.reportDate) {
                    this.doc.nextTableCell();
                    this.doc.addText(dateLabel);
                }
                if (this.reportYears) {
                    this.doc.nextTableCell();
                    this.doc.addText(yearsLabel);
                }
                if (this.reportPlace) {
                    this.doc.nextTableCell();
                    this.doc.addText(placeLabel);
                }
                row = 0;
            }
            String bgColor = row % 2 == 0 ? even_row : odd_row;
            ++row;
            this.doc.nextTableRow("background-color=" + bgColor);
            if (this.reportDay) {
                this.doc.nextTableCell("text-align=center");
                this.doc.addText(event.getDay());
            }
            if (this.reportEntity) {
                this.doc.nextTableCell();
                for (String[] bit : event.getEntityArray()) {
                    this.doc.addText(bit[0]);
                    if (bit[1].isBlank()) continue;
                    this.doc.addText(" (");
                    this.doc.addLink(bit[1], bit[2]);
                    this.doc.addText(")");
                }
            }
            if (this.reportEvent) {
                this.doc.nextTableCell("text-align=center");
                this.doc.addText(event.getName());
            }
            if (this.reportDate) {
                this.doc.nextTableCell("text-align=center");
                this.doc.addText(event.getDate());
            }
            if (this.reportYears) {
                this.doc.nextTableCell("text-align=center");
                this.doc.addText(event.getYears());
            }
            if (!this.reportPlace) continue;
            this.doc.nextTableCell("text-align=center");
            this.doc.addText(event.getPlace());
        }
        this.doc.endTable();
        return this.doc;
    }

    private int getRecordsCount(List<Event> records, int month) {
        int counter = 0;
        for (Event record : records) {
            if (record.getMonth() != month) continue;
            ++counter;
        }
        return counter;
    }

    private int getNbColumns() {
        int ret = 0;
        ret += this.reportDay ? 1 : 0;
        ret += this.reportEntity ? 1 : 0;
        ret += this.reportEvent ? 1 : 0;
        ret += this.reportDate ? 1 : 0;
        ret += this.reportYears ? 1 : 0;
        return ret += this.reportPlace ? 1 : 0;
    }

    private String monthIntToString(int month) {
        if (month == Integer.MAX_VALUE) {
            return this.translate("Unknown");
        }
        return PointInTime.GREGORIAN.getDisplayMonthLocalized(month, false, Locale.getDefault());
    }

    private Document calendarLayout(List<Event> records, String header_row, String even_row, String odd_row, String backColor) {
        int nbCols = this.formattingOptions.common.isPortraitOrientation() ? 3 : 4;
        String spanAll = SPAN_ALL + nbCols * 2;
        String spanMonth = "number-columns-spanned=2,text-align=center, font-weight=bold, background-color=" + header_row;
        int baseFontSize = this.formattingOptions.common.getTextSize();
        int headerFontSize = baseFontSize + 2;
        int headerHeight = headerFontSize * 2;
        this.doc.startTable("genj:csv=true, width=100%, border-collapse=separate, border-width=3, border-style=solid, border-color=" + header_row + ", space-before=0,5cm, padding=0pt");
        int widthNames = 100 / nbCols - 5;
        for (int col = 1; col < nbCols * 2 + 1; ++col) {
            if (col % 2 == 1) {
                this.doc.addTableColumn("column-width=5%");
                continue;
            }
            this.doc.addTableColumn("column-width=" + widthNames + "%");
        }
        this.doc.nextTableRow("font-size=" + (headerFontSize + 2) + ", text-align=center, border-width=3, border-style=solid, border-color=" + backColor + ", font-weight=bold, background-color=" + header_row);
        this.doc.nextTableCell(spanAll + ", height=" + headerHeight + "px, display-align=center, border-width=2, border-style=solid, border-color=" + backColor);
        this.doc.addText(Year.now().toString());
        String[] months = PointInTime.GREGORIAN.getMonths(true);
        String cellAttr2 = "border-width=2, border-style=solid, border-color=" + backColor;
        String cellAttr1 = "text-align=center, " + cellAttr2;
        for (int mth = 0; mth < months.length; mth += nbCols) {
            this.doc.nextTableRow("border=1, font-size=" + headerFontSize);
            for (int col = 0; col < nbCols; ++col) {
                this.doc.nextTableCell(spanMonth + ", height=" + headerHeight + "px, display-align=center, " + cellAttr2);
                this.doc.addText(this.monthIntToString(mth + col).toUpperCase());
            }
            Cell[] cells = new Cell[nbCols];
            int maxLines = 0;
            for (int col = 0; col < nbCols; ++col) {
                Cell cell;
                List<Event> events = this.getRecords(records, mth + col);
                cells[col] = cell = new Cell();
                if (events.size() > maxLines) {
                    maxLines = events.size();
                }
                for (int line = 0; line < events.size(); ++line) {
                    cell.days.add(events.get(line).getDay());
                    Object name = "";
                    for (String[] bit : events.get(line).getEntityArray()) {
                        name = (String)name + bit[0];
                    }
                    cell.names.add((String)name);
                }
            }
            for (int line = 0; line < maxLines + 1; ++line) {
                boolean even = line % 2 == 0;
                String bg = ", background-color=" + (even ? even_row : odd_row);
                this.doc.nextTableRow();
                for (int col = 0; col < nbCols; ++col) {
                    Cell cell = cells[col];
                    if (cell.days.size() > line) {
                        this.doc.nextTableCell(cellAttr1 + bg);
                        this.doc.addText(cell.days.get(line));
                        this.doc.nextTableCell(cellAttr2 + bg);
                        this.doc.addText(cell.names.get(line));
                        continue;
                    }
                    this.doc.nextTableCell(cellAttr1 + bg);
                    this.doc.addText("\u00a0");
                    this.doc.nextTableCell(cellAttr2 + bg);
                    this.doc.addText("\u00a0");
                }
            }
        }
        this.doc.endTable();
        return this.doc;
    }

    private List<Event> getRecords(List<Event> records, int mth) {
        ArrayList<Event> ret = new ArrayList<Event>();
        for (Event event : records) {
            if (event.getMonth() != mth) continue;
            ret.add(event);
        }
        return ret;
    }

    public class MyFormattingOptions {
        public FormattingOptions common = new FormattingOptions();
        public FormattingIcsOptions ics = new FormattingIcsOptions();
        public boolean calendarLayout = false;
    }

    public class MyFilterOptions {
        public FilterOptions filter = new FilterOptions(){

            @Override
            public boolean isFilterOn() {
                return MyFilterOptions.this.hideDivorceMarriages || MyFilterOptions.this.hideWidowMarriages || MyFilterOptions.this.hideUnknown || super.isFilterOn();
            }
        };
        public boolean hideDivorceMarriages = false;
        public boolean hideWidowMarriages = false;
        public boolean hideUnknown = true;
    }

    public class MyDataFormatOptions {
        public FormatFirstNameOptions firstname = new FormatFirstNameOptions();
        public FormatPlaceOptions place = new FormatPlaceOptions();
        public FormatDateOptions date = new FormatDateOptions();
        public FormatIDOptions id = new FormatIDOptions();
    }

    private class Event
    implements Comparable<Event>,
    FormattingIcsOptions.CalendarRecord {
        private final PropertyEventDetails event;
        private int day;
        private final PointInTime pit;
        private final String date;
        private int month;
        private boolean isPrecise;
        private final Entity entity;
        private final String tag;
        private final String name;
        private int years;
        private final String place;

        private Event(PropertyEventDetails event) {
            this.event = event;
            this.tag = event.getTag();
            this.name = Gedcom.getName((String)this.tag);
            Property pDate = event.getProperty("DATE");
            this.date = ReportCalendar.this.dataFormatOptions.date.getDate(pDate);
            if (pDate != null && pDate instanceof PropertyDate) {
                PropertyDate ptyDate = (PropertyDate)pDate;
                this.pit = ptyDate.getStart();
                this.isPrecise = ptyDate.getFormat().toString().isEmpty();
            } else {
                this.pit = null;
                this.isPrecise = false;
            }
            this.day = Integer.MAX_VALUE;
            this.month = Integer.MAX_VALUE;
            this.years = Integer.MAX_VALUE;
            if (this.pit != null) {
                try {
                    this.pit.convertIncomplete((Calendar)PointInTime.GREGORIAN);
                    this.day = this.pit.getDay();
                    this.month = this.pit.getMonth();
                    this.years = PointInTime.getNow().getYear() - this.pit.getYear();
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            this.place = ReportCalendar.this.dataFormatOptions.place.getPlace(event.getProperty("PLAC"));
            this.entity = event.getEntity();
        }

        @Override
        public Entity getEntity() {
            return this.entity;
        }

        @Override
        public PropertyEventDetails getProperty() {
            return this.event;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDate() {
            return this.date;
        }

        @Override
        public PointInTime getPit() {
            return this.pit;
        }

        @Override
        public String getPlace() {
            return this.place;
        }

        @Override
        public boolean isDatePrecise() {
            return this.isPrecise;
        }

        private String getEntityString() {
            StringBuilder sb = new StringBuilder();
            String[][] data = this.getEntityArray();
            sb.append(data[0][0]);
            sb.append(" ");
            if (data.length > 2) {
                sb.append(data[2][0]);
                sb.append(" ");
            }
            return sb.toString();
        }

        private int getMonth() {
            return this.month;
        }

        private String getDay() {
            return this.day == Integer.MAX_VALUE ? ReportCalendar.this.translate("Unknown") : String.valueOf(this.day + 1);
        }

        private String[][] getEntityArray() {
            Entity entity = this.entity;
            if (entity instanceof Indi) {
                Indi indi = (Indi)entity;
                return new String[][]{this.getName(indi, indi.getLinkAnchor())};
            }
            entity = this.entity;
            if (entity instanceof Fam) {
                Fam fam = (Fam)entity;
                String[][] ret = new String[4][3];
                String[] blank = new String[]{"?", "", ""};
                String anchor = "";
                Indi husb = fam.getHusband();
                Property husbProp = fam.getProperty("HUSB", true);
                if (husbProp instanceof PropertyHusband) {
                    PropertyHusband pHusb = (PropertyHusband)husbProp;
                    anchor = pHusb.getTarget().getLinkAnchor();
                }
                ret[0] = husb != null ? this.getName(husb, anchor) : blank;
                anchor = "";
                ret[1] = new String[]{" " + TextOptions.getInstance().getMarriageSymbol() + " ", "", ""};
                Indi wife = fam.getWife();
                Property wifeProp = fam.getProperty("WIFE", true);
                if (wifeProp instanceof PropertyWife) {
                    PropertyWife pWife = (PropertyWife)wifeProp;
                    anchor = pWife.getTarget().getLinkAnchor();
                }
                ret[2] = wife != null ? this.getName(wife, anchor) : blank;
                ret[3] = new String[]{"", ReportCalendar.this.dataFormatOptions.id.displayId == 0 ? "" : this.entity.getId(), this.entity.getLinkAnchor()};
                return ret;
            }
            return null;
        }

        private String[] getName(Indi indi, String anchor) {
            String[] ret = new String[]{ReportCalendar.this.dataFormatOptions.firstname.getFirstName((Property)indi.getNameProperty()) + " " + indi.getLastName(), ReportCalendar.this.dataFormatOptions.id.displayId == 0 ? "" : ReportCalendar.this.dataFormatOptions.id.getId(indi), ReportCalendar.this.dataFormatOptions.id.displayId == 0 ? "" : anchor};
            return ret;
        }

        private String getYears() {
            return this.years == Integer.MAX_VALUE ? ReportCalendar.this.translate("Unknown") : String.valueOf(this.years);
        }

        private boolean isDivorcedMarriage() {
            if (!this.tag.equals("MARR")) {
                return false;
            }
            PropertyEvent div = (PropertyEvent)this.entity.getProperty("DIV");
            if (this.isDefined(div)) {
                return true;
            }
            div = (PropertyEvent)this.entity.getProperty("DIVF");
            return this.isDefined(div);
        }

        private boolean isWidowMarriage() {
            if (!this.tag.equals("MARR")) {
                return false;
            }
            Entity entity = this.entity;
            if (entity instanceof Fam) {
                Fam fam = (Fam)entity;
                Indi husb = fam.getHusband();
                if (husb != null && husb.isDeceased()) {
                    return true;
                }
                Indi wife = fam.getWife();
                if (wife != null && wife.isDeceased()) {
                    return true;
                }
            }
            return this.years > 90;
        }

        private boolean isDefined(PropertyEvent prop) {
            if (prop != null) {
                if (prop.isKnownToHaveHappened().booleanValue()) {
                    return true;
                }
                PropertyDate localDate = prop.getDate();
                if (localDate != null && localDate.isValid()) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int compareTo(Event other) {
            if (this.month != other.month) {
                return Integer.compare(this.month, other.month);
            }
            if (this.day != other.day) {
                return Integer.compare(this.day, other.day);
            }
            if (!this.date.equals(other.date)) {
                return this.sortDate(this, other);
            }
            if (this.entity.getDisplayTitle(true).compareToIgnoreCase(other.entity.getDisplayTitle(true)) != 0) {
                return this.entity.getDisplayTitle(true).compareToIgnoreCase(other.entity.getDisplayTitle(true));
            }
            if (!this.name.equals(other.name)) {
                return this.name.toLowerCase(Locale.getDefault()).compareTo(other.name.toLowerCase(Locale.getDefault()));
            }
            return this.place.toLowerCase(Locale.getDefault()).compareTo(other.place.toLowerCase(Locale.getDefault()));
        }

        private int sortDate(Event e1, Event e2) {
            if (e1.pit == null && e2.pit == null) {
                return 0;
            }
            if (e2.pit == null) {
                return 1;
            }
            if (e1.pit == null) {
                return -1;
            }
            return e1.pit.compareTo(e2.pit);
        }

        public boolean equals(Object that) {
            return that instanceof Event ? this.event == ((Event)that).event : false;
        }

        public int hashCode() {
            int hash = 3;
            hash = 19 * hash + Objects.hashCode(this.event);
            hash = 19 * hash + Objects.hashCode(this.tag);
            hash = 19 * hash + Objects.hashCode(this.name);
            hash = 19 * hash + Objects.hashCode(this.date);
            hash = 19 * hash + Objects.hashCode(this.place);
            hash = 19 * hash + Objects.hashCode(this.entity);
            return hash;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name);
            sb.append(" ");
            sb.append(this.date);
            sb.append(" ");
            sb.append(this.place);
            sb.append(" ");
            sb.append(this.entity.getDisplayTitle(true));
            sb.append(" ");
            sb.append(this.years);
            return sb.toString();
        }
    }

    private class Cell {
        List<String> days = new ArrayList<String>();
        List<String> names = new ArrayList<String>();

        private Cell() {
        }
    }
}

