/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.missinginformation;

import ancestris.reports.FilterOptions;
import ancestris.reports.FormatDateOptions;
import ancestris.reports.FormattingOptions;
import ancestris.reports.ScopeIndiOptions;
import ancestris.reports.SimpleColorsOptions;
import ancestris.reports.utils.PropUtils;
import ancestris.util.EventUsage;
import ancestris.util.swing.DialogManager;
import genj.fo.Document;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomConstants;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertySex;
import genj.gedcom.PropertySource;
import genj.gedcom.TagPath;
import genj.option.Multiline;
import genj.option.Sorter;
import genj.report.Report;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openide.util.NbBundle;

public class ReportMissingInformation
extends Report {
    private final String[] COMPLETE_OPTIONS = new String[]{this.translate("complete.media"), this.translate("complete.repo"), this.translate("complete.title"), this.translate("complete.text"), this.translate("complete.quay")};
    public FormattingOptions formattingOptions = new FormattingOptions();
    public ScopeIndiOptions scope = new ScopeIndiOptions();
    @Multiline
    public int[] eventSelector = new int[]{6, 15, 29};
    public String[] eventSelectors = EVENTNAMES;
    public boolean truncateLabels = false;
    public String symbolComplete = "1";
    public String symbolIncomplete = "~";
    public String symbolAbsent = ".";
    @Multiline
    public int[] completeSelector = new int[]{0};
    public String[] completeSelectors = this.COMPLETE_OPTIONS;
    public Sorter sorter = new Sorter((Object[])SORT_FIELD_NAMES);
    public FilterOptions filterOptions = new FilterOptions();
    public FormatDateOptions dataFormatOptions = new FormatDateOptions();
    public SimpleColorsOptions colors = new SimpleColorsOptions();
    private final String UNKNOWN = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"Unknown");
    private Document doc;
    private Gedcom gedcom;
    private static final String SPAN_ALL = "number-columns-spanned=";
    private static final String BORDER_RIGHT = "border-left-width=0,   border-left-style=none, border-top-width=0,    border-top-style=none, border-bottom-width=0, border-bottom-style=none, border-right-width=1,  border-right-style=dotted, border-style=dotted";
    private static final String BORDER_BOTTOM = "border-left-width=0,   border-left-style=none, border-top-width=0,    border-top-style=none,  border-right-width=0,  border-right-style=none, border-bottom-width=1, border-bottom-style=dotted, border-style=dotted";
    private static final String[] EVENTNAMES = (String[])PropUtils.getEventNames().toArray(String[]::new);
    private String[] columnNames;
    private TagPath[] columnTagPaths;
    private Set<Integer> borders;
    private static final String[] SORT_FIELD_NAMES = new String[]{Gedcom.getName((String)"NAME"), NbBundle.getMessage(ReportMissingInformation.class, (String)"label_id"), NbBundle.getMessage(ReportMissingInformation.class, (String)"label_gen")};
    private static final String[] SORT_FIELD_TAGPATH = new String[]{"", "ID", ""};
    private static final String[] SORT_FIELD_STYLES = new String[]{"text-align=left", "text-align=center", "text-align=left"};
    private Map<Integer, Integer> mapSort;

    public String accepts(Object context) {
        if (context instanceof Gedcom || context instanceof Indi || context instanceof Fam || context instanceof Indi[]) {
            return super.getName();
        }
        return null;
    }

    public Document start(Gedcom gedcom) {
        this.gedcom = gedcom;
        List<Indi> indis = this.scope.getScope(gedcom, this);
        return indis != null ? this.main(indis) : null;
    }

    public Document start(Entity entity) {
        this.gedcom = entity.getGedcom();
        List<Indi> indis = this.scope.getScope(entity, this);
        return indis != null ? this.main(indis) : null;
    }

    public Document start(Indi[] indis) {
        if (indis.length == 0) {
            return null;
        }
        this.gedcom = indis[0].getGedcom();
        List<Indi> indisList = Arrays.asList(indis);
        return this.main(indisList);
    }

    public Document main(List<Indi> indis) {
        if (this.eventSelector.length == 0) {
            DialogManager.createError((String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"OptionError"), (String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ErrorNoColumnSelected")).show();
            return null;
        }
        this.symbolComplete = this.checkSymbol(this.symbolComplete, "1");
        this.symbolIncomplete = this.checkSymbol(this.symbolIncomplete, "~");
        this.symbolAbsent = this.checkSymbol(this.symbolAbsent, ".");
        String header_row = this.colors.getHeaderRowColor();
        String even_row = this.colors.getEvenRowColor();
        String odd_row = this.colors.getOddRowColor();
        String textColor = this.colors.getTextColor();
        this.mapSort = this.sorter.getMap((Object[])SORT_FIELD_NAMES);
        this.columnNames = this.getColumnNames();
        this.columnTagPaths = this.getColumnsTagPaths();
        ArrayList<Line> records = new ArrayList<Line>();
        for (Indi indi : indis) {
            Iterator<String[]> record;
            if (!this.filterOptions.matchRecord((Property)indi, ((Line)((Object)(record = new Line(indi)))).getName(), ((Line)((Object)record)).toString())) continue;
            records.add((Line)((Object)record));
        }
        Collections.sort(records);
        String number = String.valueOf(records.size());
        String title = this.translate("title", new Object[]{number, this.gedcom.getDisplayName()});
        this.doc = this.formattingOptions.createDocument(this.translate("name"), this.colors.getTextColor(), this.colors.getBackgroundColor());
        this.doc.startSection(title, "title", 1, false, false, "font-size=" + this.formattingOptions.getTitleSize() + ",text-align=center, space-before=0cm, space-after=1cm");
        if (this.formattingOptions.includeTOC) {
            this.doc.addTOC(2, false, true);
            this.doc.nextParagraph("space-before=1cm");
        }
        if (this.scope.isLimited()) {
            this.doc.addText(this.scope.getMainMessage(), "font-weight=bold");
            for (String[] scopeLine : this.scope.getMessages()) {
                this.doc.nextParagraph();
                this.doc.addText("\u2219  " + scopeLine[0]);
                if (scopeLine[1].isBlank()) continue;
                this.doc.addText(" : " + scopeLine[1], "font-weight=bold");
            }
            this.doc.nextParagraph("space-before=1cm");
        }
        if (this.filterOptions.isFilterOn()) {
            this.doc.addText(this.filterOptions.getMainMessage(), "font-weight=bold");
            for (String[] filterLine : this.filterOptions.getMessages()) {
                this.doc.nextParagraph();
                this.doc.addText("\u2219  " + filterLine[0]);
                if (filterLine[1].isBlank()) continue;
                this.doc.addText(" : " + filterLine[1], "font-weight=bold");
            }
            this.doc.nextParagraph("space-before=1cm");
        }
        this.doc.addText(this.translate("sortKey"), "font-weight=bold");
        for (int i = 0; i < SORT_FIELD_NAMES.length; ++i) {
            this.doc.nextParagraph();
            this.doc.addText("\u2219  " + SORT_FIELD_NAMES[this.mapSort.get(i)]);
        }
        this.doc.nextParagraph("space-before=1cm");
        this.doc.startTable("genj:csv=true, width=100%, border-style=none, border-color=" + textColor + ", border=0, space-before=1cm");
        int nbColumns = this.columnNames.length;
        String spanAll = SPAN_ALL + nbColumns;
        this.setColumnsWidth(nbColumns, records);
        int row = 0;
        String key = "";
        for (Line record : records) {
            String newKey = record.getKey();
            if (!newKey.equals(key)) {
                key = newKey;
                this.doc.nextTableRow();
                this.doc.nextTableCell(spanAll + ", height=48, border-style=none, border-color=" + textColor);
                this.doc.nextParagraph();
                this.doc.addText("\u00a0");
                if (this.formattingOptions.includeTOC) {
                    this.doc.addTOCEntry(key);
                    this.doc.nextParagraph();
                    this.doc.addLink("^^^", "title");
                }
                this.doc.nextTableRow("font-size=" + this.formattingOptions.getTextSize() + ", text-align=center, font-weight=bold, background-color=" + header_row);
                this.doc.nextTableCell(spanAll + ", border-left-width=0,   border-left-style=none, border-top-width=0,    border-top-style=none,  border-right-width=0,  border-right-style=none, border-bottom-width=1, border-bottom-style=dotted, border-style=dotted, border-bottom-color=" + textColor);
                this.doc.addText(SORT_FIELD_NAMES[this.mapSort.get(0)] + " " + key);
                this.doc.nextTableRow("font-size=" + (this.formattingOptions.getTextSize() - 1) + ", text-align=center, background-color=" + header_row);
                for (int col = 0; col < this.columnNames.length; ++col) {
                    this.displayLabel(this.columnNames[col], col);
                }
                row = 0;
            }
            String bgColor = row % 2 == 0 ? even_row : odd_row;
            ++row;
            this.doc.nextTableRow("font-size=" + this.formattingOptions.getTextSize() + ", background-color=" + bgColor);
            for (int col = 0; col < this.columnNames.length; ++col) {
                this.displayValue(record, col);
            }
        }
        this.doc.endTable();
        return this.doc;
    }

    private List<String> getSortedSelectedTags() {
        List<String> tags = Arrays.asList(PropUtils.getEventTags(this.eventSelector).split("\\|"));
        HashMap eventUsages = new HashMap();
        EventUsage.init(eventUsages);
        Comparator comparator = (s1, s2) -> {
            Integer i1 = ((EventUsage)eventUsages.get(s1)).getOrder();
            Integer i2 = ((EventUsage)eventUsages.get(s2)).getOrder();
            return i1.compareTo(i2);
        };
        Collections.sort(tags, comparator);
        return tags;
    }

    private String[] getColumnNames() {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (int i = 0; i < SORT_FIELD_NAMES.length; ++i) {
            String label = SORT_FIELD_NAMES[this.mapSort.get(i)];
            ret.add(this.mapSort.get(i) != 0 && this.truncateLabels && label.length() > 3 ? label.substring(0, 3) + "." : label);
        }
        ret.add(this.getTruncatedLabel("SURN", 3));
        ret.add(this.getTruncatedLabel("GIVN", 3));
        ret.add(this.getTruncatedLabel("SEX", 3));
        for (String tag : this.getSortedSelectedTags()) {
            if (this.isTagEventNotDescriptionOnly(tag)) {
                ret.add(this.getTruncatedLabel(tag, 3) + " " + this.getTruncatedLabel("DATE", 1));
                ret.add(this.getTruncatedLabel(tag, 3) + " " + this.getTruncatedLabel("PLAC", 1));
                ret.add(this.getTruncatedLabel(tag, 3) + " " + this.getTruncatedLabel("SOUR", 1));
                continue;
            }
            ret.add(this.getTruncatedLabel(tag, 3));
        }
        return (String[])ret.toArray(String[]::new);
    }

    private String getTruncatedLabel(String tag, int length) {
        String label = Gedcom.getName((String)tag);
        return this.truncateLabels && label.length() > 3 ? label.substring(0, length) : label;
    }

    private TagPath[] getColumnsTagPaths() {
        ArrayList<TagPath> ret = new ArrayList<TagPath>();
        this.borders = new HashSet<Integer>();
        for (String fieldName : SORT_FIELD_NAMES) {
            ret.add(null);
        }
        this.borders.add(ret.size() - 1);
        ret.add(new TagPath("INDI:NAME:SURN"));
        ret.add(new TagPath("INDI:NAME:GIVN"));
        ret.add(new TagPath("INDI:SEX"));
        this.borders.add(ret.size() - 1);
        HashMap eventUsages = new HashMap();
        EventUsage.init(eventUsages);
        for (String tag : this.getSortedSelectedTags()) {
            String type = "INDI:FAMS:*:..:";
            if (((EventUsage)eventUsages.get(tag)).getType().matches("INDI|ALL")) {
                type = "INDI:";
            }
            if (this.isTagEventNotDescriptionOnly(tag)) {
                ret.add(new TagPath(type + tag + ":DATE"));
                ret.add(new TagPath(type + tag + ":PLAC"));
                ret.add(new TagPath(type + tag + ":SOUR"));
                this.borders.add(ret.size() - 1);
                continue;
            }
            ret.add(new TagPath(type + tag));
            this.borders.add(ret.size() - 1);
        }
        return (TagPath[])ret.toArray(TagPath[]::new);
    }

    private boolean isTagEventNotDescriptionOnly(String tag) {
        return GedcomConstants.TAG_YES_EVENTS.contains(tag) || tag.matches("RESI|EVEN|NO");
    }

    private boolean isBolderColumn(int col) {
        return this.borders.contains(col);
    }

    private void setColumnsWidth(int nbColumns, List<Line> records) {
        int col;
        int col2;
        int minPercent;
        int[] widthsPix = new int[nbColumns];
        Arrays.fill(widthsPix, Integer.MIN_VALUE);
        for (Line record : records) {
            for (int col3 = 0; col3 < nbColumns; ++col3) {
                String textValue = record.getColum(col3) + "W";
                int textSize = textValue.length();
                if (textSize <= widthsPix[col3]) continue;
                widthsPix[col3] = textSize;
            }
        }
        int sumpx = 0;
        for (int col4 = 0; col4 < nbColumns; ++col4) {
            sumpx += widthsPix[col4];
        }
        int n = nbColumns < 10 ? 5 : (nbColumns < 18 ? 4 : (minPercent = nbColumns < 24 ? 3 : 2));
        if (!this.truncateLabels) {
            ++minPercent;
        }
        int totalPercentage = 100;
        for (col2 = nbColumns - 1; col2 >= SORT_FIELD_NAMES.length; --col2) {
            int w;
            widthsPix[col2] = w = Math.max(minPercent, 100 * widthsPix[col2] / sumpx);
            if ((totalPercentage -= w) >= 10) continue;
            return;
        }
        sumpx = 0;
        for (col2 = 0; col2 < SORT_FIELD_NAMES.length; ++col2) {
            sumpx += widthsPix[col2];
        }
        int leftPercentage = totalPercentage;
        minPercent = 4;
        for (col = 1; col < SORT_FIELD_NAMES.length; ++col) {
            int w;
            widthsPix[col] = w = Math.max(minPercent, leftPercentage * widthsPix[col] / sumpx);
            if ((totalPercentage -= w) >= 1) continue;
            return;
        }
        widthsPix[0] = Math.max(minPercent, totalPercentage);
        for (col = 0; col < nbColumns; ++col) {
            this.doc.addTableColumn("column-width=" + widthsPix[col] + "%");
        }
    }

    private void displayLabel(String label, int col) {
        this.doc.nextTableCell((String)(this.isBolderColumn(col) ? "border-left-width=0,   border-left-style=none, border-top-width=0,    border-top-style=none, border-bottom-width=0, border-bottom-style=none, border-right-width=1,  border-right-style=dotted, border-style=dotted, border-right-color=" + this.colors.getTextColor() : ""));
        this.doc.addText(label);
    }

    private void displayValue(Line record, int col) {
        Object style = col < SORT_FIELD_STYLES.length ? SORT_FIELD_STYLES[this.mapSort.get(col)] : "text-align=center";
        if (this.isBolderColumn(col)) {
            if (!((String)style).isBlank()) {
                style = (String)style + ", ";
            }
            style = (String)style + "border-left-width=0,   border-left-style=none, border-top-width=0,    border-top-style=none, border-bottom-width=0, border-bottom-style=none, border-right-width=1,  border-right-style=dotted, border-style=dotted, border-right-color=" + this.colors.getTextColor();
        }
        this.doc.nextTableCell((String)style);
        if (col < SORT_FIELD_NAMES.length && "ID".equals(SORT_FIELD_TAGPATH[this.mapSort.get(col)])) {
            this.doc.addLink(record.getColum(col), record.getAnchor());
        } else {
            this.doc.addText(record.getColum(col));
        }
    }

    private String checkSymbol(String symbol, String defaultSymbol) {
        return symbol.isBlank() ? defaultSymbol : symbol.substring(0, 1);
    }

    private class Line
    implements Comparable<Line> {
        private final Indi indi;
        private final String[] columns;

        public Line(Indi indi) {
            this.indi = indi;
            this.columns = new String[ReportMissingInformation.this.columnTagPaths.length];
            for (int col = 0; col < ReportMissingInformation.this.columnTagPaths.length; ++col) {
                if (col < SORT_FIELD_NAMES.length) {
                    switch (ReportMissingInformation.this.mapSort.get(col)) {
                        case 0: {
                            this.columns[col] = this.getName();
                            break;
                        }
                        case 1: {
                            this.columns[col] = indi.getId();
                            break;
                        }
                        case 2: {
                            if (col == SORT_FIELD_NAMES.length - 1) {
                                this.columns[col] = this.parseGen(indi.getSosaString());
                                break;
                            }
                            this.columns[col] = indi.getSosaString();
                            break;
                        }
                    }
                    continue;
                }
                TagPath tagpath = ReportMissingInformation.this.columnTagPaths[col];
                Property property = indi.getProperty(tagpath);
                if (property == null || property.getDisplayValue().isBlank()) {
                    this.columns[col] = ReportMissingInformation.this.symbolAbsent;
                    continue;
                }
                if (property instanceof PropertyDate) {
                    PropertyDate pDate = (PropertyDate)property;
                    if (pDate.isValid() && !pDate.isRange() && pDate.getStart().isComplete()) {
                        this.columns[col] = ReportMissingInformation.this.symbolComplete;
                        continue;
                    }
                    this.columns[col] = ReportMissingInformation.this.symbolIncomplete;
                    continue;
                }
                if (property instanceof PropertyPlace) {
                    PropertyPlace pPlace = (PropertyPlace)property;
                    if (pPlace.isValid() && !pPlace.getCity().isBlank() && !pPlace.getCountry().isBlank()) {
                        this.columns[col] = ReportMissingInformation.this.symbolComplete;
                        continue;
                    }
                    this.columns[col] = ReportMissingInformation.this.symbolIncomplete;
                    continue;
                }
                if (property instanceof PropertySource) {
                    PropertySource pSource = (PropertySource)property;
                    this.managePropertySource(col, pSource);
                    continue;
                }
                if (property.getTag().equals("SOUR")) {
                    this.manageSourceTag(property, col);
                    continue;
                }
                if (property instanceof PropertySex) {
                    PropertySex pSex = (PropertySex)property;
                    if (pSex.isValid() && (pSex.getSex() == 1 || pSex.getSex() == 2)) {
                        this.columns[col] = ReportMissingInformation.this.symbolComplete;
                        continue;
                    }
                    this.columns[col] = ReportMissingInformation.this.symbolIncomplete;
                    continue;
                }
                this.columns[col] = ReportMissingInformation.this.symbolComplete;
            }
        }

        private void manageSourceTag(Property property, int col) {
            boolean complete = true;
            block7: for (int i : ReportMissingInformation.this.completeSelector) {
                switch (i) {
                    case 0: {
                        if (property.getProperty("OBJE") != null) {
                            complete &= true;
                            continue block7;
                        }
                        complete &= false;
                        continue block7;
                    }
                    case 1: {
                        if (property.getProperty("REPO") != null) {
                            complete &= true;
                            continue block7;
                        }
                        complete &= false;
                        continue block7;
                    }
                    case 2: {
                        if (property.getProperty("TITL") != null) {
                            complete &= true;
                            continue block7;
                        }
                        complete &= false;
                        continue block7;
                    }
                    case 3: {
                        if (property.getProperty("TEXT") != null) {
                            complete &= true;
                            continue block7;
                        }
                        complete &= false;
                        continue block7;
                    }
                    case 4: {
                        if (property.getProperty("QUAY") != null) {
                            complete &= true;
                            continue block7;
                        }
                        complete &= false;
                        continue block7;
                    }
                    default: {
                        complete |= true;
                    }
                }
            }
            this.columns[col] = complete ? ReportMissingInformation.this.symbolComplete : ReportMissingInformation.this.symbolIncomplete;
        }

        private void managePropertySource(int col, PropertySource pSource) {
            boolean complete = true;
            if (pSource.getTargetEntity().isEmpty()) {
                this.columns[col] = ReportMissingInformation.this.symbolIncomplete;
                return;
            }
            Entity eSource = (Entity)pSource.getTargetEntity().get();
            block7: for (int i : ReportMissingInformation.this.completeSelector) {
                switch (i) {
                    case 0: {
                        if (pSource.getProperty("OBJE") != null) {
                            complete &= true;
                            continue block7;
                        }
                        if (eSource.getProperty("OBJE") != null) {
                            complete &= true;
                            continue block7;
                        }
                        complete &= false;
                        continue block7;
                    }
                    case 1: {
                        if (eSource.getProperty("REPO") != null) {
                            complete &= true;
                            continue block7;
                        }
                        complete &= false;
                        continue block7;
                    }
                    case 2: {
                        if (eSource.getProperty("TITL") != null) {
                            complete &= true;
                            continue block7;
                        }
                        complete &= false;
                        continue block7;
                    }
                    case 3: {
                        if (pSource.getProperty(new TagPath(".:DATA:TEXT")) != null) {
                            complete &= true;
                            continue block7;
                        }
                        if (eSource.getProperty("TEXT") != null) {
                            complete &= true;
                            continue block7;
                        }
                        complete &= false;
                        continue block7;
                    }
                    case 4: {
                        if (pSource.getProperty("QUAY") != null) {
                            complete &= true;
                            continue block7;
                        }
                        complete &= false;
                        continue block7;
                    }
                    default: {
                        complete |= true;
                    }
                }
            }
            this.columns[col] = complete ? ReportMissingInformation.this.symbolComplete : ReportMissingInformation.this.symbolIncomplete;
        }

        @Override
        public int compareTo(Line record) {
            int diff = 0;
            for (int col = 0; col < ReportMissingInformation.this.columnTagPaths.length; ++col) {
                switch (ReportMissingInformation.this.mapSort.get(col)) {
                    case 0: {
                        diff = this.indi.getDisplayComparator().compare((Object)this.indi, (Object)record.indi);
                        break;
                    }
                    case 1: {
                        diff = this.indi.getComparator().compare((Object)this.indi, (Object)record.indi);
                        break;
                    }
                    case 2: {
                        diff = this.parseGen(this.columns[col]).compareTo(this.parseGen(record.columns[col]));
                        if (diff == 0) {
                            diff = this.parseSosa(this.columns[col]).compareTo(this.parseSosa(record.columns[col]));
                        }
                        if (diff != 0) break;
                        diff = this.columns[col].compareTo(record.columns[col]);
                        break;
                    }
                }
                if (diff == 0) continue;
                return diff;
            }
            return diff;
        }

        private String getName() {
            String ddate;
            String bdate = ReportMissingInformation.this.dataFormatOptions.getDate((Property)this.indi.getBirthDateOption());
            String dates = (bdate + (ddate = ReportMissingInformation.this.dataFormatOptions.getDate((Property)this.indi.getDeathDateOption()))).isBlank() ? "" : " (" + bdate + " - " + ddate + ")";
            return this.indi != null ? this.indi.getName() + dates : "";
        }

        private String getKey() {
            String key = "";
            switch (ReportMissingInformation.this.mapSort.get(0)) {
                case 0: {
                    key = this.columns[0].substring(0, 1).toUpperCase();
                    break;
                }
                case 1: {
                    long l = Long.parseLong(this.columns[0].replaceAll("[^\\d.]", ""));
                    long blockSizel = l / 100L * 100L;
                    key = String.valueOf(blockSizel);
                    break;
                }
                case 2: {
                    key = this.parseGen(this.columns[0]);
                    break;
                }
            }
            return key;
        }

        private String getColum(int col) {
            return this.columns[col];
        }

        private String getAnchor() {
            return this.indi.getLinkAnchor();
        }

        private String parseGen(String sosaString) {
            int index = sosaString.indexOf("G");
            if (index < 0) {
                return ReportMissingInformation.this.UNKNOWN;
            }
            String gen = sosaString.substring(index + 1).replaceAll("[^\\d.]", "");
            if (gen.isBlank()) {
                return ReportMissingInformation.this.UNKNOWN;
            }
            return String.format("%02d", Integer.valueOf(gen));
        }

        private BigInteger parseSosa(String sosaString) {
            String[] bits = sosaString.split("-|\\s");
            String sosaDigits = bits[0].replaceAll("[^\\d.]", "");
            if (sosaDigits.isBlank()) {
                return BigInteger.ZERO;
            }
            return new BigInteger(sosaDigits);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (String column : this.columns) {
                sb.append(column);
                sb.append(" ");
            }
            return sb.toString();
        }
    }
}

