/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.document.view;

import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.util.swing.EditorHyperlinkSupport;
import java.awt.AWTEvent;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

class HyperLinkTextPane
extends JEditorPane
implements MouseListener,
MouseMotionListener {
    private String id = null;
    private Gedcom gedcom = null;

    public HyperLinkTextPane() {
        this.setContentType("text/plain");
        this.setFont(new Font("Monospaced", 0, 12));
        this.setEditable(false);
        this.addHyperlinkListener((HyperlinkListener)new EditorHyperlinkSupport((JEditorPane)this));
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.id = this.markIDat(e.getPoint());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Entity entity;
        if (this.id != null && this.gedcom != null && (entity = this.gedcom.getEntity(this.id)) != null) {
            SelectionDispatcher.fireSelection((AWTEvent)e, (Context)new Context(entity));
        }
    }

    private String markIDat(Point loc) {
        try {
            int pos = this.viewToModel2D(loc);
            if (pos < 0) {
                return null;
            }
            Document doc = this.getDocument();
            int i = 0;
            while (true) {
                if (i == 10) {
                    return null;
                }
                if (pos == 0 || !Character.isLetterOrDigit(doc.getText(pos - 1, 1).charAt(0))) break;
                --pos;
                ++i;
            }
            int len = 0;
            while (true) {
                if (len == 10) {
                    return null;
                }
                if (pos + len == doc.getLength() || !Character.isLetterOrDigit(doc.getText(pos + len, 1).charAt(0))) break;
                ++len;
            }
            if (len < 2) {
                return null;
            }
            String _id = doc.getText(pos, len);
            if (this.gedcom == null || this.gedcom.getEntity(_id) == null) {
                return null;
            }
            this.setCaretPosition(pos);
            this.moveCaretPosition(pos + len);
            return _id;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    public void clear() {
        this.setContentType("text/plain");
        this.setText("");
    }

    public void add(String txt) {
        Document doc = this.getDocument();
        try {
            doc.insertString(doc.getLength(), txt, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void setGedcom(Gedcom gedcom) {
        this.gedcom = gedcom;
    }
}

