/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.matchers;

import ancestris.modules.gedcom.matchers.EntityMatcher;
import ancestris.modules.gedcom.matchers.MediaMatcherOptions;
import ancestris.util.GedcomUtilities;
import genj.gedcom.Media;
import genj.gedcom.Property;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MediaMatcher
extends EntityMatcher<Media, MediaMatcherOptions> {
    private final Map<Media, Map<String, Integer>> noteMaps;
    private final Set<String> alreadyCompared;
    protected static final int[] points = new int[]{-50, -30, 3, 25, 50};

    public MediaMatcher() {
        this.options = new MediaMatcherOptions();
        this.noteMaps = new HashMap<Media, Map<String, Integer>>();
        this.alreadyCompared = new HashSet<String>();
    }

    @Override
    public int compare(Media left, Media right) {
        String key = this.getIdKey(left.getId(), right.getId());
        if (this.alreadyCompared.contains(key)) {
            return 0;
        }
        this.alreadyCompared.add(key);
        int score = 0;
        int itemScore = 0;
        int nbSure_Different = 0;
        String lF = this.getFileName(left);
        String rF = this.getFileName(right);
        itemScore = lF.isBlank() || rF.isBlank() ? COMPARE_UNKNOWN : this.getLevel(GedcomUtilities.similarity((String)lF, (String)rF, (int)3));
        if (itemScore == COMPARE_SURE_DIFFERENT) {
            ++nbSure_Different;
        }
        score += points[itemScore];
        String lT = GedcomUtilities.normalizeString((String)left.getTitle());
        String rT = GedcomUtilities.normalizeString((String)right.getTitle());
        itemScore = lT.isBlank() || rT.isBlank() ? COMPARE_UNKNOWN : this.getLevel(GedcomUtilities.similarity((String)lT, (String)rT, (int)3));
        if (itemScore == COMPARE_SURE_DIFFERENT && ++nbSure_Different > 1) {
            return 0;
        }
        score += points[itemScore];
        String lN = this.getNote(left);
        String rN = this.getNote(right);
        if (!lN.isBlank() && !rN.isBlank()) {
            if (lN.equals(rN)) {
                itemScore = COMPARE_SURE_SAME;
                score += points[itemScore];
            } else {
                Map<String, Integer> lMap = this.noteMaps.get(left);
                Map<String, Integer> rMap = this.noteMaps.get(right);
                if (lMap != null && rMap != null) {
                    itemScore = this.getLevel(GedcomUtilities.calcCosine(lMap, rMap));
                    score += points[itemScore] / 2;
                }
            }
        }
        return score;
    }

    private String getFileName(Media media) {
        String filename = "";
        try {
            Property file = media.getProperty("FILE", false);
            String value = file.getValue();
            int i = value.lastIndexOf(File.separator) + 1;
            filename = i > 0 && i < value.length() ? value.substring(i) : value;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return filename.replaceAll("\\s+", "_");
    }

    private String getNote(Media media) {
        Property note = media.getProperty("NOTE");
        if (note != null) {
            return note.getValue();
        }
        note = media.getProperty("SNOTE");
        return note == null ? "" : note.getValue();
    }

    @Override
    public String[] getKeys(Media media) {
        String note;
        String filename;
        HashSet<String> keys = new HashSet<String>();
        String title = media.getTitle();
        if (!title.isBlank()) {
            keys.addAll(MediaMatcher.getKeyWords(title, 3));
        }
        if (!(filename = this.getFileName(media)).isBlank()) {
            keys.add(filename);
        }
        if (!(note = this.getNote(media)).isBlank()) {
            this.noteMaps.put(media, MediaMatcher.getWordsMap(note));
        }
        return (String[])keys.toArray(String[]::new);
    }

    @Override
    public String getHexaKey(Media media) {
        int num = 0;
        if (!media.getTitle().isBlank()) {
            num = (byte)(num + 4);
        }
        if (!this.getFileName(media).isBlank()) {
            num = (byte)(num + 2);
        }
        if (!this.getNote(media).isBlank()) {
            num = (byte)(num + 1);
        }
        char[] hexDigits = new char[]{Character.forDigit(num & 0xF, 16)};
        return new String(hexDigits);
    }

    @Override
    public void reset() {
        this.alreadyCompared.clear();
    }
}

