/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.gedcom.GedcomDirectory;
import ancestris.view.Images;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.apache.commons.lang.WordUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ActionOpen
extends AbstractAncestrisAction {
    private FileObject file = null;

    public ActionOpen() {
        this.setTip(NbBundle.getMessage(ActionOpen.class, (String)"HINT_ActionOpen"));
        this.setText(NbBundle.getMessage(ActionOpen.class, (String)"CTL_ActionOpen"));
        this.setImage((Icon)Images.imgOpen);
    }

    public ActionOpen(FileObject file) {
        this.file = file;
        this.setText(NbBundle.getMessage(ActionOpen.class, (String)"CTL_ActionOpen_file", (Object)this.getDisplayName(file.getNameExt())));
        this.setImage((Icon)Images.imgOpen);
    }

    public void actionPerformed(ActionEvent event) {
        if (this.file != null) {
            GedcomDirectory.getDefault().openGedcom(this.file);
        } else {
            GedcomDirectory.getDefault().openGedcom();
        }
    }

    private String getDisplayName(String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        name = name.replace("_", " ");
        char[] delimiters = new char[]{' ', '-'};
        return WordUtils.capitalize((String)name.substring(0, name.lastIndexOf(".") == -1 ? name.length() : name.lastIndexOf(".")), (char[])delimiters);
    }
}

