/*
 * Decompiled with CFR 0.152.
 */
package ancestris.startup.settings;

import ancestris.startup.settings.PropertiesLike;
import ancestris.startup.settings.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Utilities;

public class StartupOptions {
    private String jdkHomePath = "";
    private String userDirPath = "";
    private String macuserDirPath = "";
    private final Map<String, String> hParam = new HashMap<String, String>(10);
    private final File ancestrisUserConfFile = new File(new File(System.getProperty("user.home.ancestris")).getParent() + "/etc/ancestris.conf");
    private Properties ancestrisConfProps;

    public StartupOptions() {
        File conf;
        String prefix = "";
        this.ancestrisConfProps = Util.loadProperties(this.ancestrisUserConfFile);
        if (this.ancestrisConfProps == null && (conf = InstalledFileLocator.getDefault().locate("../etc/ancestris.conf", "org.netbeans.core.startup", false)) != null) {
            this.ancestrisConfProps = Util.loadProperties(conf);
        }
        if (this.ancestrisConfProps == null) {
            conf = InstalledFileLocator.getDefault().locate("../etc/netbeans.conf", "org.netbeans.core.startup", false);
            if (conf != null) {
                this.ancestrisConfProps = Util.loadProperties(conf);
            }
            prefix = "netbeans_";
        }
        if (this.ancestrisConfProps != null) {
            this.loadConf(this.ancestrisConfProps, prefix);
        }
    }

    public void applyChanges() {
        this.ancestrisConfProps = this.getProperties();
        this.persistSettings();
    }

    private void persistSettings() {
        FileOutputStream fileOut = null;
        try {
            Util.createRecursively(this.ancestrisUserConfFile);
            fileOut = new FileOutputStream(this.ancestrisUserConfFile);
            this.ancestrisConfProps.store(fileOut, "properties written ancestris");
            Util.close(fileOut);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            Util.close(fileOut);
        }
    }

    private Properties getProperties() {
        PropertiesLike props = new PropertiesLike();
        if (this.userDirPath.length() > 0) {
            props.setProperty("default_userdir", "\"" + this.userDirPath + "\"");
        }
        if (this.macuserDirPath.length() > 0) {
            props.setProperty("default_mac_userdir", "\"" + this.macuserDirPath + "\"");
        }
        if (this.jdkHomePath.length() > 0) {
            props.setProperty("jdkhome", "\"" + this.jdkHomePath + "\"");
        }
        props.setProperty("default_options", "\"" + this.getJvmParametersAsString() + "\"");
        return props;
    }

    private void loadConf(Properties confProperties, String prefix) {
        this.jdkHomePath = confProperties.getProperty(prefix + "jdkhome", "");
        if (Utilities.isWindows()) {
            this.jdkHomePath = this.jdkHomePath.replace('\\', '/');
        }
        if (this.jdkHomePath.indexOf(34) > -1) {
            this.jdkHomePath = this.jdkHomePath.substring(1, this.jdkHomePath.length() - 1);
        }
        this.userDirPath = confProperties.getProperty(prefix + "default_userdir", "");
        if (this.userDirPath.indexOf(34) > -1) {
            this.userDirPath = this.userDirPath.substring(1, this.userDirPath.length() - 1);
        }
        this.macuserDirPath = confProperties.getProperty(prefix + "default_mac_userdir", "");
        if (this.macuserDirPath.indexOf(34) > -1) {
            this.macuserDirPath = this.macuserDirPath.substring(1, this.macuserDirPath.length() - 1);
        }
        this.loadJvmParameters(confProperties, prefix);
    }

    private void loadJvmParameters(Properties confProperties, String prefix) {
        String val = confProperties.getProperty(prefix + "default_options", "");
        if (val.indexOf(34) > -1) {
            val = val.substring(1, val.length() - 1).trim();
        }
        if (val.length() == 0) {
            return;
        }
        String[] _v = val.split("\\s+");
        for (int j = 0; j < _v.length; ++j) {
            String parameter = _v[j];
            if (parameter.substring(0, 2).equals("--")) {
                this.hParam.put(parameter, _v[++j]);
                continue;
            }
            if (parameter.startsWith("-J-Xm")) {
                this.hParam.put(parameter.substring(0, 6), parameter.substring(6));
                continue;
            }
            if (parameter.startsWith("-J-D")) {
                String[] kv = parameter.split("=");
                if (kv.length <= 1) continue;
                this.hParam.put(kv[0], kv[1]);
                continue;
            }
            this.hParam.put(parameter, "");
        }
    }

    public String getUserDir() {
        return this.userDirPath;
    }

    public String getJdkHomeDir() {
        return this.jdkHomePath;
    }

    public boolean setJvmParameter(String parameter, String value) {
        String oldValue = this.getJvmParameter(parameter);
        if (value == null) {
            this.hParam.remove(parameter);
            return oldValue != null;
        }
        this.hParam.put(parameter, value);
        return !value.equals(oldValue);
    }

    public String getJvmParameter(String parameter) {
        return this.hParam.get(parameter);
    }

    public boolean setJvmLocale(Locale locale) {
        return this.setJvmParameter("--locale", locale == null ? null : locale.toString().replace('_', ':'));
    }

    public Locale getJvmLocale() {
        return this.getLocaleFromString(this.getJvmParameter("--locale"));
    }

    private Locale getLocaleFromString(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        String[] locale = (str + "::").split(":", 3);
        return new Locale(locale[0], locale[1], locale[2]);
    }

    public String getJvmParametersAsString() {
        StringBuilder sb = new StringBuilder(120);
        for (String key : this.hParam.keySet()) {
            if (key.contentEquals("-J-Duser.language")) continue;
            sb.append(" ").append(key);
            if (key.startsWith("--")) {
                sb.append(" ").append(this.hParam.get(key));
                continue;
            }
            if (key.startsWith("-J-D")) {
                sb.append("=").append(this.hParam.get(key));
                continue;
            }
            sb.append(this.hParam.get(key));
        }
        return sb.length() > 0 ? sb.substring(1) : "";
    }
}

