/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLExecutionContext;
import org.jkiss.dbeaver.ext.mysql.model.MySQLProcedure;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableColumn;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableConstraint;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableForeignKey;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCStructureAssistant;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractObjectReference;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;

public class MySQLStructureAssistant
extends JDBCStructureAssistant<MySQLExecutionContext> {
    private final MySQLDataSource dataSource;

    public MySQLStructureAssistant(MySQLDataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected JDBCDataSource getDataSource() {
        return this.dataSource;
    }

    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_CONSTRAINT, RelationalObjectType.TYPE_PROCEDURE, RelationalObjectType.TYPE_TABLE_COLUMN};
    }

    public DBSObjectType[] getHyperlinkObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_PROCEDURE};
    }

    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_PROCEDURE};
    }

    protected void findObjectsByMask(@NotNull MySQLExecutionContext executionContext, @NotNull JDBCSession session, @NotNull DBSObjectType objectType, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull List<DBSObjectReference> references) throws SQLException {
        MySQLCatalog catalog;
        MySQLCatalog mySQLCatalog = catalog = params.getParentObject() instanceof MySQLCatalog ? (MySQLCatalog)params.getParentObject() : null;
        if (catalog == null && !params.isGlobalSearch()) {
            catalog = executionContext.getContextDefaults().getDefaultCatalog();
        }
        if (objectType == RelationalObjectType.TYPE_TABLE) {
            this.findTablesByMask(session, catalog, params, references);
        } else if (objectType == RelationalObjectType.TYPE_CONSTRAINT) {
            this.findConstraintsByMask(session, catalog, params, references);
        } else if (objectType == RelationalObjectType.TYPE_PROCEDURE) {
            this.findProceduresByMask(session, catalog, params, references);
        } else if (objectType == RelationalObjectType.TYPE_TABLE_COLUMN) {
            this.findTableColumnsByMask(session, catalog, params, references);
        }
    }

    private void findTablesByMask(JDBCSession session, final @Nullable MySQLCatalog catalog, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> objects) throws SQLException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        String sql = MySQLStructureAssistant.generateQuery(params, "TABLE_NAME", "TABLE_COMMENT", "TABLE_SCHEMA", "TABLE_SCHEMA,TABLE_NAME", "information_schema.TABLES", catalog, objects);
        Throwable throwable = null;
        Object var8_9 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            MySQLStructureAssistant.fillParameters(dbStat, params, catalog, true);
            Throwable throwable2 = null;
            Object var11_14 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    final String catalogName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_SCHEMA");
                    final String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_NAME");
                    objects.add((DBSObjectReference)new AbstractObjectReference(tableName, (DBSObject)this.dataSource.getCatalog(catalogName), null, MySQLTableBase.class, RelationalObjectType.TYPE_TABLE){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            MySQLCatalog tableCatalog;
                            MySQLCatalog mySQLCatalog = tableCatalog = catalog != null ? catalog : MySQLStructureAssistant.this.dataSource.getCatalog(catalogName);
                            if (tableCatalog == null) {
                                throw new DBException("Table catalog '" + catalogName + "' not found");
                            }
                            MySQLTableBase table = (MySQLTableBase)tableCatalog.getTableCache().getObject(monitor, (DBSObject)tableCatalog, tableName);
                            if (table == null) {
                                throw new DBException("Table '" + tableName + "' not found in catalog '" + catalogName + "'");
                            }
                            return table;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findProceduresByMask(JDBCSession session, final @Nullable MySQLCatalog catalog, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> objects) throws SQLException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        String sql = MySQLStructureAssistant.generateQuery(params, "ROUTINE_NAME", "ROUTINE_COMMENT", "ROUTINE_SCHEMA", "ROUTINE_SCHEMA,ROUTINE_NAME", "information_schema.ROUTINES", catalog, objects);
        Throwable throwable = null;
        Object var8_9 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            MySQLStructureAssistant.fillParameters(dbStat, params, catalog, true);
            Throwable throwable2 = null;
            Object var11_14 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    final String catalogName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ROUTINE_SCHEMA");
                    final String procName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ROUTINE_NAME");
                    objects.add((DBSObjectReference)new AbstractObjectReference(procName, (DBSObject)this.dataSource.getCatalog(catalogName), null, MySQLProcedure.class, RelationalObjectType.TYPE_PROCEDURE){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            MySQLCatalog procCatalog;
                            MySQLCatalog mySQLCatalog = procCatalog = catalog != null ? catalog : MySQLStructureAssistant.this.dataSource.getCatalog(catalogName);
                            if (procCatalog == null) {
                                throw new DBException("Procedure catalog '" + catalogName + "' not found");
                            }
                            MySQLProcedure procedure = procCatalog.getProcedure(monitor, procName);
                            if (procedure == null) {
                                throw new DBException("Procedure '" + procName + "' not found in catalog '" + procCatalog.getName() + "'");
                            }
                            return procedure;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findConstraintsByMask(JDBCSession session, final @Nullable MySQLCatalog catalog, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> objects) throws SQLException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        String sql = MySQLStructureAssistant.generateQuery(params, "CONSTRAINT_NAME", null, "TABLE_SCHEMA", "TABLE_SCHEMA,TABLE_NAME,CONSTRAINT_NAME,CONSTRAINT_TYPE", "information_schema.TABLE_CONSTRAINTS", catalog, objects);
        Throwable throwable = null;
        Object var8_9 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            MySQLStructureAssistant.fillParameters(dbStat, params, catalog, false);
            Throwable throwable2 = null;
            Object var11_14 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    final String catalogName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_SCHEMA");
                    final String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_NAME");
                    final String constrName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_NAME");
                    String constrType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_TYPE");
                    final boolean isFK = "FOREIGN KEY".equals(constrType);
                    final boolean isCheck = "CHECK".equals(constrType);
                    objects.add((DBSObjectReference)new AbstractObjectReference(constrName, (DBSObject)this.dataSource.getCatalog(catalogName), null, isFK ? MySQLTableForeignKey.class : MySQLTableConstraint.class, RelationalObjectType.TYPE_CONSTRAINT){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            MySQLCatalog tableCatalog;
                            MySQLCatalog mySQLCatalog = tableCatalog = catalog != null ? catalog : MySQLStructureAssistant.this.dataSource.getCatalog(catalogName);
                            if (tableCatalog == null) {
                                throw new DBException("Constraint catalog '" + catalogName + "' not found");
                            }
                            MySQLTable table = tableCatalog.getTable(monitor, tableName);
                            if (table == null) {
                                throw new DBException("Constraint table '" + tableName + "' not found in catalog '" + tableCatalog.getName() + "'");
                            }
                            Object constraint = isFK ? table.getAssociation(monitor, constrName) : (isCheck ? table.getCheckConstraint(monitor, constrName) : table.getUniqueKey(monitor, constrName));
                            if (constraint == null) {
                                throw new DBException("Constraint '" + constrName + "' not found in table '" + table.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'");
                            }
                            return constraint;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findTableColumnsByMask(JDBCSession session, final @Nullable MySQLCatalog catalog, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> objects) throws SQLException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        String sql = MySQLStructureAssistant.generateQuery(params, "COLUMN_NAME", "COLUMN_COMMENT", "TABLE_SCHEMA", "TABLE_SCHEMA,TABLE_NAME,COLUMN_NAME", "information_schema.COLUMNS", catalog, objects);
        Throwable throwable = null;
        Object var8_9 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            MySQLStructureAssistant.fillParameters(dbStat, params, catalog, true);
            Throwable throwable2 = null;
            Object var11_14 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    final String catalogName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_SCHEMA");
                    final String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_NAME");
                    final String columnName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_NAME");
                    objects.add((DBSObjectReference)new AbstractObjectReference(columnName, (DBSObject)this.dataSource.getCatalog(catalogName), null, MySQLTableColumn.class, RelationalObjectType.TYPE_TABLE_COLUMN){

                        @NotNull
                        public String getFullyQualifiedName(DBPEvaluationContext context) {
                            return String.valueOf(DBUtils.getQuotedIdentifier((DBPDataSource)MySQLStructureAssistant.this.dataSource, (String)catalogName)) + '.' + DBUtils.getQuotedIdentifier((DBPDataSource)MySQLStructureAssistant.this.dataSource, (String)tableName) + '.' + DBUtils.getQuotedIdentifier((DBPDataSource)MySQLStructureAssistant.this.dataSource, (String)columnName);
                        }

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            MySQLCatalog tableCatalog;
                            MySQLCatalog mySQLCatalog = tableCatalog = catalog != null ? catalog : MySQLStructureAssistant.this.dataSource.getCatalog(catalogName);
                            if (tableCatalog == null) {
                                throw new DBException("Column catalog '" + catalogName + "' not found");
                            }
                            MySQLTableBase table = (MySQLTableBase)tableCatalog.getTableCache().getObject(monitor, (DBSObject)tableCatalog, tableName);
                            if (table == null) {
                                throw new DBException("Column table '" + tableName + "' not found in catalog '" + tableCatalog.getName() + "'");
                            }
                            MySQLTableColumn column = table.getAttribute(monitor, columnName);
                            if (column == null) {
                                throw new DBException("Column '" + columnName + "' not found in table '" + table.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'");
                            }
                            return column;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private static String generateQuery(@NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull String objectNameColumn, @Nullable String commentColumnName, @NotNull String schemaColumnName, @NotNull String select, @NotNull String from, @Nullable MySQLCatalog catalog, @NotNull Collection<DBSObjectReference> references) {
        StringBuilder sql = new StringBuilder("SELECT ").append(select).append(" FROM ").append(from).append(" WHERE ");
        if (params.isSearchInComments() && commentColumnName != null) {
            sql.append("(");
        }
        sql.append(objectNameColumn).append(" LIKE ? ");
        if (params.isSearchInComments() && commentColumnName != null) {
            sql.append("OR ").append(commentColumnName).append(" LIKE ?) ");
        }
        if (catalog != null) {
            sql.append("AND ").append(schemaColumnName).append(" = ? ");
        }
        sql.append("ORDER BY ").append(objectNameColumn).append(" LIMIT ").append(params.getMaxResults() - references.size());
        return sql.toString();
    }

    private static void fillParameters(@NotNull JDBCPreparedStatement statement, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @Nullable MySQLCatalog catalog, boolean hasCommentColumn) throws SQLException {
        String mask = params.getMask().toLowerCase(Locale.ENGLISH);
        statement.setString(1, mask);
        int catalogNameIdx = 2;
        if (params.isSearchInComments() && hasCommentColumn) {
            statement.setString(2, mask);
            ++catalogNameIdx;
        }
        if (catalog != null) {
            statement.setString(catalogNameIdx, catalog.getName());
        }
    }
}

