/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools.fdw;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreForeignDataWrapper;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.fdw.FDWConfigDescriptor;
import org.jkiss.dbeaver.ext.postgresql.model.fdw.FDWConfigRegistry;
import org.jkiss.dbeaver.ext.postgresql.tools.fdw.PostgreFDWConfigWizard;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;
import org.jkiss.utils.CommonUtils;

class PostgreFDWConfigWizardPageConfig
extends ActiveWizardPage<PostgreFDWConfigWizard> {
    private static final Log log = Log.getLog(PostgreFDWConfigWizardPageConfig.class);
    private boolean activated;
    private Table entityTable;
    private Combo fdwCombo;
    private Text fdwServerText;
    private Combo schemaCombo;
    private PropertyTreeViewer propsEditor;
    private Text targetDataSourceText;
    private Text targetDriverText;
    private List<PostgreSchema> schemaList;
    private List<PostgreFDWConfigWizard.FDWInfo> fdwList;

    protected PostgreFDWConfigWizardPageConfig(PostgreFDWConfigWizard wizard) {
        super("Configuration");
        this.setTitle("Configure foreign data wrappers");
        this.setDescription("Choose foreign wrapper and set option");
        this.setWizard((IWizard)wizard);
    }

    public boolean isPageComplete() {
        PostgreFDWConfigWizard wizard = (PostgreFDWConfigWizard)this.getWizard();
        return this.activated && !CommonUtils.isEmpty((String)wizard.getFdwServerId()) && wizard.getSelectedFDW() != null && wizard.getSelectedSchema() != null && !wizard.getSelectedEntities().isEmpty();
    }

    public void createControl(Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        Composite fdwGroup = UIUtils.createComposite((Composite)composite, (int)2);
        fdwGroup.setLayoutData((Object)new GridData(768));
        this.fdwCombo = UIUtils.createLabelCombo((Composite)fdwGroup, (String)"Wrapper", (int)12);
        this.fdwCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((PostgreFDWConfigWizard)PostgreFDWConfigWizardPageConfig.this.getWizard()).setSelectedFDW((PostgreFDWConfigWizard.FDWInfo)PostgreFDWConfigWizardPageConfig.this.fdwList.get(PostgreFDWConfigWizardPageConfig.this.fdwCombo.getSelectionIndex()));
                PostgreFDWConfigWizardPageConfig.this.refreshFDWProperties();
            }
        });
        UIUtils.createEmptyLabel((Composite)fdwGroup, (int)1, (int)1);
        UIUtils.createLink((Composite)fdwGroup, (String)"If you don't see right data wrapper in the list then try to <a>install it</a>", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        SashForm sashForm = new SashForm(composite, 256);
        sashForm.setLayoutData((Object)new GridData(1808));
        Group settingsGroup = UIUtils.createControlGroup((Composite)sashForm, (String)"Settings", (int)2, (int)1808, (int)0);
        this.fdwServerText = UIUtils.createLabelText((Composite)settingsGroup, (String)"Server ID", (String)"", (int)2048);
        this.fdwServerText.addModifyListener(e -> ((PostgreFDWConfigWizard)this.getWizard()).setFdwServerId(this.fdwServerText.getText()));
        this.schemaCombo = UIUtils.createLabelCombo((Composite)settingsGroup, (String)"Target schema", (int)12);
        this.schemaCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((PostgreFDWConfigWizard)PostgreFDWConfigWizardPageConfig.this.getWizard()).setSelectedSchema((PostgreSchema)PostgreFDWConfigWizardPageConfig.this.schemaList.get(PostgreFDWConfigWizardPageConfig.this.schemaCombo.getSelectionIndex()));
                PostgreFDWConfigWizardPageConfig.this.updatePageCompletion();
            }
        });
        this.propsEditor = new PropertyTreeViewer((Composite)settingsGroup, 2048);
        this.propsEditor.setNamesEditable(true);
        this.propsEditor.setNewPropertiesAllowed(true);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.propsEditor.getControl().setLayoutData((Object)gd);
        Group tablesGroup = UIUtils.createControlGroup((Composite)sashForm, (String)"Tables", (int)2, (int)1808, (int)0);
        this.targetDataSourceText = UIUtils.createLabelText((Composite)tablesGroup, (String)"Data source", (String)"", (int)2056);
        this.targetDriverText = UIUtils.createLabelText((Composite)tablesGroup, (String)"Driver", (String)"", (int)2056);
        this.entityTable = new Table((Composite)tablesGroup, 67588);
        this.entityTable.setHeaderVisible(true);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.entityTable.setLayoutData((Object)gd);
        UIUtils.createTableColumn((Table)this.entityTable, (int)16384, (String)"Table");
        this.setControl((Control)composite);
    }

    private void refreshFDWProperties() {
        DBPDataSourceContainer targetDataSource = ((PostgreFDWConfigWizard)this.getWizard()).getSelectedDataSource();
        PostgreFDWConfigWizard.FDWInfo selectedFDW = ((PostgreFDWConfigWizard)this.getWizard()).getSelectedFDW();
        PropertySourceCustom propertySource = ((PostgreFDWConfigWizard)this.getWizard()).getFdwPropertySource();
        propertySource.setDefValueResolver(targetDataSource.getVariablesResolver(false));
        propertySource.removeAll();
        if (selectedFDW != null && selectedFDW.fdwDescriptor != null) {
            propertySource.addProperties(selectedFDW.fdwDescriptor.getProperties());
        } else if (selectedFDW != null) {
            propertySource.addProperty((DBPPropertyDescriptor)new PropertyDescriptor(null, "host", "host", "Remote database host", false, String.class, (Object)"${host}", null));
            propertySource.addProperty((DBPPropertyDescriptor)new PropertyDescriptor(null, "port", "port", "Remote database port", false, String.class, (Object)"${port}", null));
            propertySource.addProperty((DBPPropertyDescriptor)new PropertyDescriptor(null, "dbname", "dbname", "Remote database name", false, String.class, (Object)"${database}", null));
        }
        this.propsEditor.loadProperties((DBPPropertySource)propertySource);
    }

    public void activatePage() {
        if (!this.activated) {
            this.activated = true;
        }
        this.loadSettings();
        super.activatePage();
    }

    private void loadSettings() {
        FDWConfigDescriptor fdwConfig;
        DBPDataSourceContainer targetDataSource = ((PostgreFDWConfigWizard)this.getWizard()).getSelectedDataSource();
        if (targetDataSource == null) {
            this.setErrorMessage("No target data source");
            return;
        }
        try {
            ((PostgreFDWConfigWizard)this.getWizard()).getRunnableContext().run(false, true, monitor -> {
                try {
                    this.schemaList = new ArrayList<PostgreSchema>();
                    this.schemaList.addAll(((PostgreFDWConfigWizard)this.getWizard()).getDatabase().getSchemas(monitor));
                    this.fdwList = new ArrayList<PostgreFDWConfigWizard.FDWInfo>();
                    for (PostgreForeignDataWrapper fdw : CommonUtils.safeCollection((Collection)((PostgreFDWConfigWizard)this.getWizard()).getDatabase().getForeignDataWrappers(monitor))) {
                        PostgreFDWConfigWizard.FDWInfo fdwInfo = new PostgreFDWConfigWizard.FDWInfo();
                        fdwInfo.installedFDW = fdw;
                        this.fdwList.add(fdwInfo);
                    }
                    for (PostgreForeignDataWrapper fdw : FDWConfigRegistry.getInstance().getConfigDescriptors()) {
                        PostgreFDWConfigWizard.FDWInfo fdwInfo2;
                        boolean found = false;
                        for (PostgreFDWConfigWizard.FDWInfo fdwInfo2 : this.fdwList) {
                            if (!fdwInfo2.getId().equals(fdw.getFdwId())) continue;
                            fdwInfo2.fdwDescriptor = fdw;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        fdwInfo2 = new PostgreFDWConfigWizard.FDWInfo();
                        fdwInfo2.fdwDescriptor = fdw;
                        this.fdwList.add(fdwInfo2);
                    }
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            log.debug((Object)e.getTargetException());
            this.setErrorMessage(e.getTargetException().getMessage());
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.setErrorMessage(null);
        PostgreFDWConfigWizard.FDWInfo fdwInfo = ((PostgreFDWConfigWizard)this.getWizard()).getSelectedFDW();
        if (fdwInfo == null && (fdwConfig = FDWConfigRegistry.getInstance().findFirstMatch(targetDataSource)) != null) {
            for (PostgreFDWConfigWizard.FDWInfo fDWInfo : this.fdwList) {
                if (fDWInfo.fdwDescriptor != fdwConfig) continue;
                fdwInfo = fDWInfo;
                break;
            }
        }
        this.fdwCombo.removeAll();
        for (PostgreFDWConfigWizard.FDWInfo fdw : this.fdwList) {
            String fdwName = fdw.getId();
            if (!CommonUtils.isEmpty((String)fdw.getDescription())) {
                fdwName = String.valueOf(fdwName) + " (" + fdw.getDescription() + ")";
            }
            this.fdwCombo.add(fdwName);
        }
        if (fdwInfo != null) {
            ((PostgreFDWConfigWizard)this.getWizard()).setSelectedFDW(fdwInfo);
            this.fdwCombo.setText(fdwInfo.getId());
        }
        this.schemaCombo.removeAll();
        for (PostgreSchema schema : this.schemaList) {
            this.schemaCombo.add(schema.getName());
        }
        PostgreSchema selectedSchema = ((PostgreFDWConfigWizard)this.getWizard()).getSelectedSchema();
        if (selectedSchema != null) {
            this.schemaCombo.setText(selectedSchema.getName());
        } else {
            PostgreSchema postgreSchema = (PostgreSchema)DBUtils.findObject(this.schemaList, (String)"public");
            if (postgreSchema != null) {
                this.schemaCombo.setText(postgreSchema.getName());
                ((PostgreFDWConfigWizard)this.getWizard()).setSelectedSchema(postgreSchema);
            }
        }
        this.refreshFDWProperties();
        if (CommonUtils.isEmpty((String)this.fdwServerText.getText())) {
            String string = String.valueOf(fdwInfo == null ? targetDataSource.getDriver().getId() : fdwInfo.getId()) + "_srv";
            ((PostgreFDWConfigWizard)this.getWizard()).setFdwServerId(string);
            this.fdwServerText.setText(string);
        }
        this.targetDataSourceText.setText(targetDataSource.getName());
        this.targetDriverText.setText(targetDataSource.getDriver().getName());
        this.entityTable.removeAll();
        for (DBNDatabaseNode dBNDatabaseNode : ((PostgreFDWConfigWizard)this.getWizard()).getSelectedEntities()) {
            TableItem item = new TableItem(this.entityTable, 0);
            item.setImage(0, DBeaverIcons.getImage((DBPImage)dBNDatabaseNode.getNodeIconDefault()));
            item.setText(0, dBNDatabaseNode.getNodeFullName());
        }
        UIUtils.packColumns((Table)this.entityTable, (boolean)false);
        this.propsEditor.repackColumns();
        this.updatePageCompletion();
    }

    public void deactivatePage() {
        this.propsEditor.saveEditorValues();
        super.deactivatePage();
    }
}

