/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.freedesktop.dbus.utils.Util;
import org.freedesktop.dbus.utils.XmlErrorHandlers;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class XmlUtil {
    private XmlUtil() {
    }

    public static boolean isElementType(Node _node) {
        return _node instanceof Element;
    }

    public static Element toElement(Node _node) {
        if (XmlUtil.isElementType(_node)) {
            return (Element)_node;
        }
        return null;
    }

    public static NodeList applyXpathExpressionToDocument(String _xpathExpression, Node _xmlDocumentOrNode) throws IOException {
        XPathFactory xfactory = XPathFactory.newInstance();
        XPath xpath = xfactory.newXPath();
        XPathExpression expr = null;
        try {
            expr = xpath.compile(_xpathExpression);
        }
        catch (XPathExpressionException _ex) {
            throw new IOException(_ex);
        }
        Object result = null;
        try {
            result = expr.evaluate(_xmlDocumentOrNode, XPathConstants.NODESET);
        }
        catch (Exception _ex) {
            throw new IOException(_ex);
        }
        return (NodeList)result;
    }

    public static Document parseXmlString(String _xmlStr, boolean _validating, boolean _namespaceAware) throws IOException {
        DocumentBuilderFactory dbFac = DocumentBuilderFactory.newInstance();
        dbFac.setNamespaceAware(_namespaceAware);
        dbFac.setValidating(_validating);
        try {
            return dbFac.newDocumentBuilder().parse(new ByteArrayInputStream(_xmlStr.getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException _ex) {
            throw _ex;
        }
        catch (Exception _ex) {
            throw new IOException("Failed to parse " + Util.abbreviate(_xmlStr, 500), _ex);
        }
    }

    public static List<Element> convertToElementList(NodeList _nodeList) {
        ArrayList<Element> elemList = new ArrayList<Element>();
        for (int i = 0; i < _nodeList.getLength(); ++i) {
            Element elem = (Element)_nodeList.item(i);
            elemList.add(elem);
        }
        return elemList;
    }

    public static Map<String, String> convertToAttributeMap(NamedNodeMap _nodeMap) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < _nodeMap.getLength(); ++i) {
            Node node = _nodeMap.item(i);
            map.put(node.getNodeName(), node.getNodeValue());
        }
        return map;
    }

    public static Document parseXmlStringWithXsdValidation(String _xmlStr, boolean _namespaceAware, ErrorHandler _errorHandler) throws IOException {
        if (_errorHandler == null) {
            _errorHandler = new XmlErrorHandlers.XmlErrorHandlerQuiet();
        }
        DocumentBuilderFactory dbFac = DocumentBuilderFactory.newInstance();
        dbFac.setValidating(true);
        dbFac.setNamespaceAware(_namespaceAware);
        dbFac.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        try {
            DocumentBuilder builder = dbFac.newDocumentBuilder();
            builder.setErrorHandler(_errorHandler);
            return builder.parse(new ByteArrayInputStream(_xmlStr.getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException _ex) {
            throw _ex;
        }
        catch (Exception _ex) {
            throw new IOException("Failed to parse " + Util.abbreviate(_xmlStr, 500), _ex);
        }
    }

    public static Document parseXmlStringWithXsdValidation(String _xmlStr, boolean _namespaceAware) throws IOException {
        return XmlUtil.parseXmlStringWithXsdValidation(_xmlStr, _namespaceAware, null);
    }

    public static void printDocument(Node _docOrNode, OutputStream _outStream) throws IOException {
        if (_docOrNode == null || _outStream == null) {
            throw new IOException("Cannot print (on) 'null' object");
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(new DOMSource(_docOrNode), new StreamResult(new OutputStreamWriter(_outStream, "UTF-8")));
        }
        catch (UnsupportedEncodingException | TransformerException _ex) {
            throw new IOException("Could not print Document or Node.", _ex);
        }
    }
}

