/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.common;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Function;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.inject.Provider;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxmlFile;

public class FxmlLoaderFactory {
    private final Map<Class<? extends FxController>, Provider<FxController>> controllerFactories;
    private final Function<Parent, Scene> sceneFactory;
    private final ResourceBundle resourceBundle;

    public FxmlLoaderFactory(Map<Class<? extends FxController>, Provider<FxController>> controllerFactories, Function<Parent, Scene> sceneFactory, ResourceBundle resourceBundle) {
        this.controllerFactories = controllerFactories;
        this.sceneFactory = sceneFactory;
        this.resourceBundle = resourceBundle;
    }

    private FXMLLoader construct(String fxmlResourceName) {
        URL url = this.getClass().getResource(fxmlResourceName);
        return new FXMLLoader(url, this.resourceBundle, null, this::constructController);
    }

    public FXMLLoader load(String fxmlResourceName) throws IOException {
        FXMLLoader loader = this.construct(fxmlResourceName);
        loader.load();
        return loader;
    }

    public Scene createScene(FxmlFile fxmlFile) {
        return this.createScene(fxmlFile.getRessourcePathString());
    }

    private Scene createScene(String fxmlResourceName) {
        FXMLLoader loader;
        try {
            loader = this.load(fxmlResourceName);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to load " + fxmlResourceName, e);
        }
        Parent root = (Parent)loader.getRoot();
        return this.sceneFactory.apply(root);
    }

    private FxController constructController(Class<?> aClass) {
        if (!this.controllerFactories.containsKey(aClass)) {
            throw new IllegalArgumentException("ViewController not registered: " + aClass);
        }
        return (FxController)this.controllerFactories.get(aClass).get();
    }
}

