/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.preferences;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.inject.Inject;
import org.cryptomator.common.Environment;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.fxapp.UpdateChecker;
import org.cryptomator.ui.preferences.PreferencesScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreferencesScoped
public class AboutController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(AboutController.class);
    private final String thirdPartyLicenseText = AboutController.loadThirdPartyLicenseFile();
    private final String applicationVersion;

    @Inject
    AboutController(UpdateChecker updateChecker, Environment environment) {
        StringBuilder sb = new StringBuilder((String)updateChecker.currentVersionProperty().get());
        environment.getBuildNumber().ifPresent(s -> sb.append(" (").append((String)s).append(')'));
        this.applicationVersion = sb.toString();
    }

    private static String loadThirdPartyLicenseFile() {
        String string;
        block8: {
            InputStream in = AboutController.class.getResourceAsStream("/license/THIRD-PARTY.txt");
            try {
                string = CharStreams.toString((Readable)new InputStreamReader(in));
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NullPointerException e) {
                    LOG.error("Failed to load /license/THIRD-PARTY.txt", (Throwable)e);
                    return "";
                }
            }
            in.close();
        }
        return string;
    }

    public String getThirdPartyLicenseText() {
        return this.thirdPartyLicenseText;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }
}

