/*
 * Copyright (c) 2020 Bitdefender
 * SPDX-License-Identifier: Apache-2.0
 */
#ifndef REGISTERS_H
#define REGISTERS_H

//
// Registers enumerations
//
enum
{
    NDR_RAX, NDR_RCX, NDR_RDX, NDR_RBX, NDR_RSP, NDR_RBP, NDR_RSI, NDR_RDI,
    NDR_R8,  NDR_R9,  NDR_R10, NDR_R11, NDR_R12, NDR_R13, NDR_R14, NDR_R15,
};

enum
{
    NDR_EAX, NDR_ECX, NDR_EDX, NDR_EBX, NDR_ESP, NDR_EBP, NDR_ESI, NDR_EDI,
    NDR_R8D, NDR_R9D, NDR_R10D,NDR_R11D,NDR_R12D,NDR_R13D,NDR_R14D,NDR_R15D,
};

enum
{
    NDR_AX,  NDR_CX,  NDR_DX,  NDR_BX,  NDR_SP,  NDR_BP,  NDR_SI,  NDR_DI,
    NDR_R8W, NDR_R9W, NDR_R10W,NDR_R11W,NDR_R12W,NDR_R13W,NDR_R14W,NDR_R15W,
};

enum
{
    NDR_AL, NDR_CL, NDR_DL, NDR_BL, NDR_AH, NDR_CH, NDR_DH, NDR_BH,
};

enum
{
    NDR_AL64, NDR_CL64, NDR_DL64, NDR_BL64, NDR_SPL, NDR_BPL, NDR_SIL, NDR_DIL,
    NDR_R8L, NDR_R9L, NDR_R10L, NDR_R11L, NDR_R12L, NDR_R13L, NDR_R14L, NDR_R15L,
};

enum
{
    NDR_ES, NDR_CS, NDR_SS, NDR_DS, NDR_FS, NDR_GS, NDR_INV6, NDR_INV7,
};

enum
{
    NDR_CR0, NDR_CR1, NDR_CR2, NDR_CR3, NDR_CR4, NDR_CR5, NDR_CR6, NDR_CR7,
    NDR_CR8, NDR_CR9, NDR_CR10, NDR_CR11, NDR_CR12, NDR_CR13, NDR_CR14, NDR_CR15,
};

enum
{
    NDR_DR0, NDR_DR1, NDR_DR2, NDR_DR3, NDR_DR4, NDR_DR5, NDR_DR6, NDR_DR7,
    NDR_DR8, NDR_DR9, NDR_DR10, NDR_DR11, NDR_DR12, NDR_DR13, NDR_DR14, NDR_DR15,
};

enum
{
    NDR_TR0, NDR_TR1, NDR_TR2, NDR_TR3, NDR_TR4, NDR_TR5, NDR_TR6, NDR_TR7,
    NDR_TR8, NDR_TR9, NDR_TR10, NDR_TR11, NDR_TR12, NDR_TR13, NDR_TR14, NDR_TR15,
};

enum
{
    NDR_K0, NDR_K1, NDR_K2, NDR_K3, NDR_K4, NDR_K5, NDR_K6, NDR_K7,
};

enum
{
    NDR_BND0, NDR_BND1, NDR_BND2, NDR_BND3,
};

enum
{
    NDR_ST0, NDR_ST1, NDR_ST2, NDR_ST3, NDR_ST4, NDR_ST5, NDR_ST6, NDR_ST7,
};

enum
{
    NDR_XMM0, NDR_XMM1, NDR_XMM2, NDR_XMM3, NDR_XMM4, NDR_XMM5, NDR_XMM6, NDR_XMM7,
    NDR_XMM8, NDR_XMM9, NDR_XMM10, NDR_XMM11, NDR_XMM12, NDR_XMM13, NDR_XMM14, NDR_XMM15,
    NDR_XMM16, NDR_XMM17, NDR_XMM18, NDR_XMM19, NDR_XMM20, NDR_XMM21, NDR_XMM22, NDR_XMM23,
    NDR_XMM24, NDR_XMM25, NDR_XMM26, NDR_XMM27, NDR_XMM28, NDR_XMM29, NDR_XMM30, NDR_XMM31,
};

enum
{
    NDR_YMM0, NDR_YMM1, NDR_YMM2, NDR_YMM3, NDR_YMM4, NDR_YMM5, NDR_YMM6, NDR_YMM7,
    NDR_YMM8, NDR_YMM9, NDR_YMM10, NDR_YMM11, NDR_YMM12, NDR_YMM13, NDR_YMM14, NDR_YMM15,
    NDR_YMM16, NDR_YMM17, NDR_YMM18, NDR_YMM19, NDR_YMM20, NDR_YMM21, NDR_YMM22, NDR_YMM23,
    NDR_YMM24, NDR_YMM25, NDR_YMM26, NDR_YMM27, NDR_YMM28, NDR_YMM29, NDR_YMM30, NDR_YMM31,
};

enum
{
    NDR_ZMM0, NDR_ZMM1, NDR_ZMM2, NDR_ZMM3, NDR_ZMM4, NDR_ZMM5, NDR_ZMM6, NDR_ZMM7,
    NDR_ZMM8, NDR_ZMM9, NDR_ZMM10, NDR_ZMM11, NDR_ZMM12, NDR_ZMM13, NDR_ZMM14, NDR_ZMM15,
    NDR_ZMM16, NDR_ZMM17, NDR_ZMM18, NDR_ZMM19, NDR_ZMM20, NDR_ZMM21, NDR_ZMM22, NDR_ZMM23,
    NDR_ZMM24, NDR_ZMM25, NDR_ZMM26, NDR_ZMM27, NDR_ZMM28, NDR_ZMM29, NDR_ZMM30, NDR_ZMM31,
};

enum
{
    NDR_GDTR, NDR_IDTR, NDR_LDTR, NDR_TR,
};

enum
{
    NDR_X87_CONTROL, NDR_X87_TAG, NDR_X87_STATUS,
};

enum
{
    NDR_XCR0, NDR_XCR1, NDR_XCR_ANY = 0xFF,
};

#define NDR_IA32_TSC                    0x00000010
#define NDR_IA32_SYSENTER_CS            0x00000174
#define NDR_IA32_SYSENTER_ESP           0x00000175
#define NDR_IA32_SYSENTER_EIP           0x00000176
#define NDR_IA32_STAR                   0xC0000081
#define NDR_IA32_LSTAR                  0xC0000082
#define NDR_IA32_FMASK                  0xC0000084
#define NDR_IA32_FS_BASE                0xC0000100
#define NDR_IA32_GS_BASE                0xC0000101
#define NDR_IA32_KERNEL_GS_BASE         0xC0000102
#define NDR_IA32_TSC_AUX                0xC0000103
#define NDR_MSR_ANY                     0xFFFFFFFF

#define NDR_RFLAG_CF                    (1 << 0)
#define NDR_RFLAG_PF                    (1 << 2)
#define NDR_RFLAG_AF                    (1 << 4)
#define NDR_RFLAG_ZF                    (1 << 6)
#define NDR_RFLAG_SF                    (1 << 7)
#define NDR_RFLAG_TF                    (1 << 8)
#define NDR_RFLAG_IF                    (1 << 9)
#define NDR_RFLAG_DF                    (1 << 10)
#define NDR_RFLAG_OF                    (1 << 11)
#define NDR_RFLAG_IOPL                  (3 << 12)
#define NDR_RFLAG_NT                    (1 << 14)
#define NDR_RFLAG_RF                    (1 << 16)
#define NDR_RFLAG_VM                    (1 << 17)
#define NDR_RFLAG_AC                    (1 << 18)
#define NDR_RFLAG_VIF                   (1 << 19)
#define NDR_RFLAG_VIP                   (1 << 20)
#define NDR_RFLAG_ID                    (1 << 21)

#endif
