<p align="center">
  <img src="https://user-images.githubusercontent.com/38039349/60953119-d3c6f300-a2fc-11e9-9596-4978e5d52180.png" width="176" height="170" alt="Framer Motion" />
</p>

<h3 align="center">
  An open source and production-ready motion<br>library for React on the web.
</h3>

<br>

<p align="center">
  <a href="https://www.npmjs.com/package/framer-motion" target="_blank">
    <img src="https://img.shields.io/npm/v/framer-motion.svg?style=flat-square" />
  </a>
  <a href="https://www.npmjs.com/package/framer-motion" target="_blank">
  <img src="https://img.shields.io/npm/dm/framer-motion.svg?style=flat-square" />
  </a>
  <a href="http://twitter.com/framer" target="_blank">
  <img src="https://img.shields.io/twitter/follow/framer.svg?style=social&label=Follow"  />
  </a>
  <a href="https://spectrum.chat/framer" target="_blank">
  <img src="https://withspectrum.github.io/badge/badge.svg" />
  </a>
</p>

<br>

Motion is an open source, production-ready library that's designed for all creative developers.

It looks like this:

```jsx
<motion.div animate={{ x: 0 }} />
```

And does this:

-   Spring physics
-   Keyframes
-   Drag
-   SVG paths
-   Server-side rendering
-   Pose-inspired tree animations
-   CSS variables
-   Position transitions
-   Unmount transitions

...and a whole lot more.

## Get started

### Quick start

```
npm install framer-motion
```

```jsx
import { motion } from "framer-motion"

export const MyComponent = ({ isVisible }) => (
  <motion.div animate={{ opacity: isVisible ? 1 : 0 }}>
)
```

### Docs

Check out [our documentation](https://framer.com/api/motion) for guides and a full API reference.

Or checkout [our examples](https://framer.com/motion) for inspiration.

## Contribute

Want to contribute to Motion? Our [contributing guide](https://github.com/framer/motion/blob/master/CONTRIBUTING.md) has you covered.

## License

Motion is MIT licensed.
