import { PickerStateProps } from '../../hooks/usePickerState';
export interface BasePickerProps<TInputValue, TValue> extends PickerStateProps<TInputValue, TValue> {
    /**
     * className applied to the root component.
     */
    className?: string;
    /**
     * If `true`, the picker and text field are disabled.
     * @default false
     */
    disabled?: boolean;
    /**
     * Format string.
     */
    inputFormat?: string;
    /**
     * Force rendering in particular orientation.
     */
    orientation?: 'portrait' | 'landscape';
    /**
     * Make picker read only.
     * @default false
     */
    readOnly?: boolean;
    /**
     * If `true`, show the toolbar even in desktop mode.
     */
    showToolbar?: boolean;
}
