function _typeof(o) {"@babel/helpers - typeof";return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) {return typeof o;} : function (o) {return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o;}, _typeof(o);}function ownKeys(e, r) {var t = Object.keys(e);if (Object.getOwnPropertySymbols) {var o = Object.getOwnPropertySymbols(e);r && (o = o.filter(function (r) {return Object.getOwnPropertyDescriptor(e, r).enumerable;})), t.push.apply(t, o);}return t;}function _objectSpread(e) {for (var r = 1; r < arguments.length; r++) {var t = null != arguments[r] ? arguments[r] : {};r % 2 ? ownKeys(Object(t), !0).forEach(function (r) {_defineProperty(e, r, t[r]);}) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) {Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r));});}return e;}function _defineProperty(obj, key, value) {key = _toPropertyKey(key);if (key in obj) {Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });} else {obj[key] = value;}return obj;}function _toPropertyKey(t) {var i = _toPrimitive(t, "string");return "symbol" == _typeof(i) ? i : String(i);}function _toPrimitive(t, r) {if ("object" != _typeof(t) || !t) return t;var e = t[Symbol.toPrimitive];if (void 0 !== e) {var i = e.call(t, r || "default");if ("object" != _typeof(i)) return i;throw new TypeError("@@toPrimitive must return a primitive value.");}return ("string" === r ? String : Number)(t);}(function (_window$dateFns) {var __defProp = Object.defineProperty;
  var __export = function __export(target, all) {
    for (var name in all)
    __defProp(target, name, {
      get: all[name],
      enumerable: true,
      configurable: true,
      set: function set(newValue) {return all[name] = function () {return newValue;};}
    });
  };

  // lib/locale/gd/_lib/formatDistance.mjs
  var formatDistanceLocale = {
    lessThanXSeconds: {
      one: "nas lugha na diog",
      other: "nas lugha na {{count}} diogan"
    },
    xSeconds: {
      one: "1 diog",
      two: "2 dhiog",
      twenty: "20 diog",
      other: "{{count}} diogan"
    },
    halfAMinute: "leth mhionaid",
    lessThanXMinutes: {
      one: "nas lugha na mionaid",
      other: "nas lugha na {{count}} mionaidean"
    },
    xMinutes: {
      one: "1 mionaid",
      two: "2 mhionaid",
      twenty: "20 mionaid",
      other: "{{count}} mionaidean"
    },
    aboutXHours: {
      one: "mu uair de th\xECde",
      other: "mu {{count}} uairean de th\xECde"
    },
    xHours: {
      one: "1 uair de th\xECde",
      two: "2 uair de th\xECde",
      twenty: "20 uair de th\xECde",
      other: "{{count}} uairean de th\xECde"
    },
    xDays: {
      one: "1 l\xE0",
      other: "{{count}} l\xE0"
    },
    aboutXWeeks: {
      one: "mu 1 seachdain",
      other: "mu {{count}} seachdainean"
    },
    xWeeks: {
      one: "1 seachdain",
      other: "{{count}} seachdainean"
    },
    aboutXMonths: {
      one: "mu mh\xECos",
      other: "mu {{count}} m\xECosan"
    },
    xMonths: {
      one: "1 m\xECos",
      other: "{{count}} m\xECosan"
    },
    aboutXYears: {
      one: "mu bhliadhna",
      other: "mu {{count}} bliadhnaichean"
    },
    xYears: {
      one: "1 bhliadhna",
      other: "{{count}} bliadhna"
    },
    overXYears: {
      one: "c\xF2rr is bliadhna",
      other: "c\xF2rr is {{count}} bliadhnaichean"
    },
    almostXYears: {
      one: "cha mh\xF2r bliadhna",
      other: "cha mh\xF2r {{count}} bliadhnaichean"
    }
  };
  var formatDistance = function formatDistance(token, count, options) {
    var result;
    var tokenValue = formatDistanceLocale[token];
    if (typeof tokenValue === "string") {
      result = tokenValue;
    } else if (count === 1) {
      result = tokenValue.one;
    } else if (count === 2 && !!tokenValue.two) {
      result = tokenValue.two;
    } else if (count === 20 && !!tokenValue.twenty) {
      result = tokenValue.twenty;
    } else {
      result = tokenValue.other.replace("{{count}}", String(count));
    }
    if (options !== null && options !== void 0 && options.addSuffix) {
      if (options.comparison && options.comparison > 0) {
        return "ann an " + result;
      } else {
        return "o chionn " + result;
      }
    }
    return result;
  };

  // lib/locale/_lib/buildFormatLongFn.mjs
  function buildFormatLongFn(args) {
    return function () {var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var width = options.width ? String(options.width) : args.defaultWidth;
      var format = args.formats[width] || args.formats[args.defaultWidth];
      return format;
    };
  }

  // lib/locale/gd/_lib/formatLong.mjs
  var dateFormats = {
    full: "EEEE, MMMM do, y",
    long: "MMMM do, y",
    medium: "MMM d, y",
    short: "MM/dd/yyyy"
  };
  var timeFormats = {
    full: "h:mm:ss a zzzz",
    long: "h:mm:ss a z",
    medium: "h:mm:ss a",
    short: "h:mm a"
  };
  var dateTimeFormats = {
    full: "{{date}} 'aig' {{time}}",
    long: "{{date}} 'aig' {{time}}",
    medium: "{{date}}, {{time}}",
    short: "{{date}}, {{time}}"
  };
  var formatLong = {
    date: buildFormatLongFn({
      formats: dateFormats,
      defaultWidth: "full"
    }),
    time: buildFormatLongFn({
      formats: timeFormats,
      defaultWidth: "full"
    }),
    dateTime: buildFormatLongFn({
      formats: dateTimeFormats,
      defaultWidth: "full"
    })
  };

  // lib/locale/gd/_lib/formatRelative.mjs
  var formatRelativeLocale = {
    lastWeek: "'mu dheireadh' eeee 'aig' p",
    yesterday: "'an-d\xE8 aig' p",
    today: "'an-diugh aig' p",
    tomorrow: "'a-m\xE0ireach aig' p",
    nextWeek: "eeee 'aig' p",
    other: "P"
  };
  var formatRelative = function formatRelative(token, _date, _baseDate, _options) {return formatRelativeLocale[token];};

  // lib/locale/_lib/buildLocalizeFn.mjs
  function buildLocalizeFn(args) {
    return function (value, options) {
      var context = options !== null && options !== void 0 && options.context ? String(options.context) : "standalone";
      var valuesArray;
      if (context === "formatting" && args.formattingValues) {
        var defaultWidth = args.defaultFormattingWidth || args.defaultWidth;
        var width = options !== null && options !== void 0 && options.width ? String(options.width) : defaultWidth;
        valuesArray = args.formattingValues[width] || args.formattingValues[defaultWidth];
      } else {
        var _defaultWidth = args.defaultWidth;
        var _width = options !== null && options !== void 0 && options.width ? String(options.width) : args.defaultWidth;
        valuesArray = args.values[_width] || args.values[_defaultWidth];
      }
      var index = args.argumentCallback ? args.argumentCallback(value) : value;
      return valuesArray[index];
    };
  }

  // lib/locale/gd/_lib/localize.mjs
  var eraValues = {
    narrow: ["R", "A"],
    abbreviated: ["RC", "AD"],
    wide: ["ro Chr\xECosta", "anno domini"]
  };
  var quarterValues = {
    narrow: ["1", "2", "3", "4"],
    abbreviated: ["C1", "C2", "C3", "C4"],
    wide: [
    "a' chiad chairteal",
    "an d\xE0rna cairteal",
    "an treas cairteal",
    "an ceathramh cairteal"]

  };
  var monthValues = {
    narrow: ["F", "G", "M", "G", "C", "\xD2", "I", "L", "S", "D", "S", "D"],
    abbreviated: [
    "Faoi",
    "Gear",
    "M\xE0rt",
    "Gibl",
    "C\xE8it",
    "\xD2gmh",
    "Iuch",
    "L\xF9n",
    "Sult",
    "D\xE0mh",
    "Samh",
    "D\xF9bh"],

    wide: [
    "Am Faoilleach",
    "An Gearran",
    "Am M\xE0rt",
    "An Giblean",
    "An C\xE8itean",
    "An t-\xD2gmhios",
    "An t-Iuchar",
    "An L\xF9nastal",
    "An t-Sultain",
    "An D\xE0mhair",
    "An t-Samhain",
    "An D\xF9bhlachd"]

  };
  var dayValues = {
    narrow: ["D", "L", "M", "C", "A", "H", "S"],
    short: ["D\xF2", "Lu", "M\xE0", "Ci", "Ar", "Ha", "Sa"],
    abbreviated: ["Did", "Dil", "Dim", "Dic", "Dia", "Dih", "Dis"],
    wide: [
    "Did\xF2mhnaich",
    "Diluain",
    "Dim\xE0irt",
    "Diciadain",
    "Diardaoin",
    "Dihaoine",
    "Disathairne"]

  };
  var dayPeriodValues = {
    narrow: {
      am: "m",
      pm: "f",
      midnight: "m.o.",
      noon: "m.l.",
      morning: "madainn",
      afternoon: "feasgar",
      evening: "feasgar",
      night: "oidhche"
    },
    abbreviated: {
      am: "M.",
      pm: "F.",
      midnight: "meadhan oidhche",
      noon: "meadhan l\xE0",
      morning: "madainn",
      afternoon: "feasgar",
      evening: "feasgar",
      night: "oidhche"
    },
    wide: {
      am: "m.",
      pm: "f.",
      midnight: "meadhan oidhche",
      noon: "meadhan l\xE0",
      morning: "madainn",
      afternoon: "feasgar",
      evening: "feasgar",
      night: "oidhche"
    }
  };
  var formattingDayPeriodValues = {
    narrow: {
      am: "m",
      pm: "f",
      midnight: "m.o.",
      noon: "m.l.",
      morning: "sa mhadainn",
      afternoon: "feasgar",
      evening: "feasgar",
      night: "air an oidhche"
    },
    abbreviated: {
      am: "M.",
      pm: "F.",
      midnight: "meadhan oidhche",
      noon: "meadhan l\xE0",
      morning: "sa mhadainn",
      afternoon: "feasgar",
      evening: "feasgar",
      night: "air an oidhche"
    },
    wide: {
      am: "m.",
      pm: "f.",
      midnight: "meadhan oidhche",
      noon: "meadhan l\xE0",
      morning: "sa mhadainn",
      afternoon: "feasgar",
      evening: "feasgar",
      night: "air an oidhche"
    }
  };
  var ordinalNumber = function ordinalNumber(dirtyNumber) {
    var number = Number(dirtyNumber);
    var rem100 = number % 100;
    if (rem100 > 20 || rem100 < 10) {
      switch (rem100 % 10) {
        case 1:
          return number + "d";
        case 2:
          return number + "na";
      }
    }
    if (rem100 === 12) {
      return number + "na";
    }
    return number + "mh";
  };
  var localize = {
    ordinalNumber: ordinalNumber,
    era: buildLocalizeFn({
      values: eraValues,
      defaultWidth: "wide"
    }),
    quarter: buildLocalizeFn({
      values: quarterValues,
      defaultWidth: "wide",
      argumentCallback: function argumentCallback(quarter) {return quarter - 1;}
    }),
    month: buildLocalizeFn({
      values: monthValues,
      defaultWidth: "wide"
    }),
    day: buildLocalizeFn({
      values: dayValues,
      defaultWidth: "wide"
    }),
    dayPeriod: buildLocalizeFn({
      values: dayPeriodValues,
      defaultWidth: "wide",
      formattingValues: formattingDayPeriodValues,
      defaultFormattingWidth: "wide"
    })
  };

  // lib/locale/_lib/buildMatchFn.mjs
  function buildMatchFn(args) {
    return function (string) {var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var width = options.width;
      var matchPattern = width && args.matchPatterns[width] || args.matchPatterns[args.defaultMatchWidth];
      var matchResult = string.match(matchPattern);
      if (!matchResult) {
        return null;
      }
      var matchedString = matchResult[0];
      var parsePatterns = width && args.parsePatterns[width] || args.parsePatterns[args.defaultParseWidth];
      var key = Array.isArray(parsePatterns) ? findIndex(parsePatterns, function (pattern) {return pattern.test(matchedString);}) : findKey(parsePatterns, function (pattern) {return pattern.test(matchedString);});
      var value;
      value = args.valueCallback ? args.valueCallback(key) : key;
      value = options.valueCallback ? options.valueCallback(value) : value;
      var rest = string.slice(matchedString.length);
      return { value: value, rest: rest };
    };
  }
  var findKey = function findKey(object, predicate) {
    for (var key in object) {
      if (Object.prototype.hasOwnProperty.call(object, key) && predicate(object[key])) {
        return key;
      }
    }
    return;
  };
  var findIndex = function findIndex(array, predicate) {
    for (var key = 0; key < array.length; key++) {
      if (predicate(array[key])) {
        return key;
      }
    }
    return;
  };

  // lib/locale/_lib/buildMatchPatternFn.mjs
  function buildMatchPatternFn(args) {
    return function (string) {var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var matchResult = string.match(args.matchPattern);
      if (!matchResult)
      return null;
      var matchedString = matchResult[0];
      var parseResult = string.match(args.parsePattern);
      if (!parseResult)
      return null;
      var value = args.valueCallback ? args.valueCallback(parseResult[0]) : parseResult[0];
      value = options.valueCallback ? options.valueCallback(value) : value;
      var rest = string.slice(matchedString.length);
      return { value: value, rest: rest };
    };
  }

  // lib/locale/gd/_lib/match.mjs
  var matchOrdinalNumberPattern = /^(\d+)(d|na|tr|mh)?/i;
  var parseOrdinalNumberPattern = /\d+/i;
  var matchEraPatterns = {
    narrow: /^(r|a)/i,
    abbreviated: /^(r\.?\s?c\.?|r\.?\s?a\.?\s?c\.?|a\.?\s?d\.?|a\.?\s?c\.?)/i,
    wide: /^(ro Chrìosta|ron aois choitchinn|anno domini|aois choitcheann)/i
  };
  var parseEraPatterns = {
    any: [/^b/i, /^(a|c)/i]
  };
  var matchQuarterPatterns = {
    narrow: /^[1234]/i,
    abbreviated: /^c[1234]/i,
    wide: /^[1234](cd|na|tr|mh)? cairteal/i
  };
  var parseQuarterPatterns = {
    any: [/1/i, /2/i, /3/i, /4/i]
  };
  var matchMonthPatterns = {
    narrow: /^[fgmcòilsd]/i,
    abbreviated: /^(faoi|gear|màrt|gibl|cèit|ògmh|iuch|lùn|sult|dàmh|samh|dùbh)/i,
    wide: /^(am faoilleach|an gearran|am màrt|an giblean|an cèitean|an t-Ògmhios|an t-Iuchar|an lùnastal|an t-Sultain|an dàmhair|an t-Samhain|an dùbhlachd)/i
  };
  var parseMonthPatterns = {
    narrow: [
    /^f/i,
    /^g/i,
    /^m/i,
    /^g/i,
    /^c/i,
    /^ò/i,
    /^i/i,
    /^l/i,
    /^s/i,
    /^d/i,
    /^s/i,
    /^d/i],

    any: [
    /^fa/i,
    /^ge/i,
    /^mà/i,
    /^gi/i,
    /^c/i,
    /^ò/i,
    /^i/i,
    /^l/i,
    /^su/i,
    /^d/i,
    /^sa/i,
    /^d/i]

  };
  var matchDayPatterns = {
    narrow: /^[dlmcahs]/i,
    short: /^(dò|lu|mà|ci|ar|ha|sa)/i,
    abbreviated: /^(did|dil|dim|dic|dia|dih|dis)/i,
    wide: /^(didòmhnaich|diluain|dimàirt|diciadain|diardaoin|dihaoine|disathairne)/i
  };
  var parseDayPatterns = {
    narrow: [/^d/i, /^l/i, /^m/i, /^c/i, /^a/i, /^h/i, /^s/i],
    any: [/^d/i, /^l/i, /^m/i, /^c/i, /^a/i, /^h/i, /^s/i]
  };
  var matchDayPeriodPatterns = {
    narrow: /^(a|p|mi|n|(san|aig) (madainn|feasgar|feasgar|oidhche))/i,
    any: /^([ap]\.?\s?m\.?|meadhan oidhche|meadhan là|(san|aig) (madainn|feasgar|feasgar|oidhche))/i
  };
  var parseDayPeriodPatterns = {
    any: {
      am: /^m/i,
      pm: /^f/i,
      midnight: /^meadhan oidhche/i,
      noon: /^meadhan là/i,
      morning: /sa mhadainn/i,
      afternoon: /feasgar/i,
      evening: /feasgar/i,
      night: /air an oidhche/i
    }
  };
  var match = {
    ordinalNumber: buildMatchPatternFn({
      matchPattern: matchOrdinalNumberPattern,
      parsePattern: parseOrdinalNumberPattern,
      valueCallback: function valueCallback(value) {return parseInt(value, 10);}
    }),
    era: buildMatchFn({
      matchPatterns: matchEraPatterns,
      defaultMatchWidth: "wide",
      parsePatterns: parseEraPatterns,
      defaultParseWidth: "any"
    }),
    quarter: buildMatchFn({
      matchPatterns: matchQuarterPatterns,
      defaultMatchWidth: "wide",
      parsePatterns: parseQuarterPatterns,
      defaultParseWidth: "any",
      valueCallback: function valueCallback(index) {return index + 1;}
    }),
    month: buildMatchFn({
      matchPatterns: matchMonthPatterns,
      defaultMatchWidth: "wide",
      parsePatterns: parseMonthPatterns,
      defaultParseWidth: "any"
    }),
    day: buildMatchFn({
      matchPatterns: matchDayPatterns,
      defaultMatchWidth: "wide",
      parsePatterns: parseDayPatterns,
      defaultParseWidth: "any"
    }),
    dayPeriod: buildMatchFn({
      matchPatterns: matchDayPeriodPatterns,
      defaultMatchWidth: "any",
      parsePatterns: parseDayPeriodPatterns,
      defaultParseWidth: "any"
    })
  };

  // lib/locale/gd.mjs
  var gd = {
    code: "gd",
    formatDistance: formatDistance,
    formatLong: formatLong,
    formatRelative: formatRelative,
    localize: localize,
    match: match,
    options: {
      weekStartsOn: 0,
      firstWeekContainsDate: 1
    }
  };

  // lib/locale/gd/cdn.js
  window.dateFns = _objectSpread(_objectSpread({},
  window.dateFns), {}, {
    locale: _objectSpread(_objectSpread({}, (_window$dateFns =
    window.dateFns) === null || _window$dateFns === void 0 ? void 0 : _window$dateFns.locale), {}, {
      gd: gd }) });



  //# debugId=511FE1278F38227964756e2164756e21
})();

//# sourceMappingURL=cdn.js.map