/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.fileloader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jd.gui.api.API;
import org.jd.gui.service.fileloader.AbstractTypeFileLoaderProvider;
import org.jd.gui.util.exception.ExceptionUtil;
import org.objectweb.asm.ClassReader;

public class ClassFileLoaderProvider
extends AbstractTypeFileLoaderProvider {
    protected static final String[] EXTENSIONS = new String[]{"class"};

    @Override
    public String[] getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getDescription() {
        return "Class files (*.class)";
    }

    @Override
    public boolean accept(API api, File file) {
        return file.exists() && file.isFile() && file.canRead() && file.getName().toLowerCase().endsWith(".class");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean load(API api, File file) {
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            ClassReader classReader = new ClassReader((InputStream)bis);
            String pathInFile = classReader.getClassName().replace("/", File.separator) + ".class";
            boolean bl = this.load(api, file, pathInFile);
            return bl;
        }
        catch (IOException e) {
            if ($assertionsDisabled) return false;
            if (ExceptionUtil.printStackTrace(e)) return false;
            throw new AssertionError();
        }
    }
}

