/*
 * Decompiled with CFR 0.152.
 */
package eu.bibl.banalysis.asm;

import eu.bibl.banalysis.filter.Filter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class InfoVector<T> {
    protected Map<Integer, T> numericalMap = new HashMap<Integer, T>();
    protected Map<T, Integer> retrievalMap = new HashMap<T, Integer>();

    public InfoVector(List<T> ts) {
        this(ts, true, new Filter<T>(){

            @Override
            public boolean accept(T t) {
                return true;
            }
        });
    }

    public InfoVector(List<T> ts, boolean definiteCount, Filter<T> filter) {
        if (definiteCount) {
            this.buildDefiniteMap(ts, filter);
        } else {
            this.buildRelativeMap(ts, filter);
        }
    }

    public void buildDefiniteMap(List<T> ts, Filter<T> filter) {
        for (int i = 0; i < ts.size(); ++i) {
            T t = ts.get(i);
            if (!filter.accept(t)) continue;
            this.numericalMap.put(i, ts.get(i));
            this.retrievalMap.put(ts.get(i), i);
        }
    }

    public void buildRelativeMap(List<T> ts, Filter<T> filter) {
        int count = 0;
        for (T t : ts) {
            if (!filter.accept(t)) continue;
            this.numericalMap.put(count, t);
            this.retrievalMap.put(t, count);
            ++count;
        }
    }

    public T getAt(int index) {
        return this.numericalMap.get(index);
    }
}

