/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.FreeformListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

class FreeformHelper
implements FreeformListener {
    private FreeformFigure host;
    private Rectangle freeformExtent;
    private FigureListener figureListener = new ChildTracker();

    FreeformHelper(FreeformFigure host) {
        this.host = host;
    }

    public Rectangle getFreeformExtent() {
        if (this.freeformExtent != null) {
            return this.freeformExtent;
        }
        for (IFigure iFigure : this.host.getChildren()) {
            Rectangle r = iFigure instanceof FreeformFigure ? ((FreeformFigure)iFigure).getFreeformExtent() : iFigure.getBounds();
            if (this.freeformExtent == null) {
                this.freeformExtent = r.getCopy();
                continue;
            }
            this.freeformExtent.union(r);
        }
        Insets insets = this.host.getInsets();
        if (this.freeformExtent == null) {
            this.freeformExtent = new Rectangle(0, 0, insets.getWidth(), insets.getHeight());
        } else {
            this.host.translateToParent(this.freeformExtent);
            this.freeformExtent.expand(insets);
        }
        return this.freeformExtent;
    }

    public void hookChild(IFigure child) {
        this.invalidate();
        if (child instanceof FreeformFigure) {
            ((FreeformFigure)child).addFreeformListener(this);
        } else {
            child.addFigureListener(this.figureListener);
        }
    }

    void invalidate() {
        this.freeformExtent = null;
        this.host.fireExtentChanged();
        if (this.host.getParent() != null) {
            this.host.getParent().revalidate();
        } else {
            this.host.revalidate();
        }
    }

    @Override
    public void notifyFreeformExtentChanged() {
        this.invalidate();
    }

    public void setFreeformBounds(Rectangle bounds) {
        this.host.setBounds(bounds);
        bounds = bounds.getCopy();
        this.host.translateFromParent(bounds);
        for (IFigure iFigure : this.host.getChildren()) {
            if (!(iFigure instanceof FreeformFigure)) continue;
            ((FreeformFigure)iFigure).setFreeformBounds(bounds);
        }
    }

    public void unhookChild(IFigure child) {
        this.invalidate();
        if (child instanceof FreeformFigure) {
            ((FreeformFigure)child).removeFreeformListener(this);
        } else {
            child.removeFigureListener(this.figureListener);
        }
    }

    class ChildTracker
    implements FigureListener {
        ChildTracker() {
        }

        @Override
        public void figureMoved(IFigure source) {
            FreeformHelper.this.invalidate();
        }
    }
}

