/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.runtime;

import java.io.PrintStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;

public class LoggingProgressMonitor
extends DefaultProgressMonitor {
    public LoggingProgressMonitor(Log log) {
        super(new LoggingMonitorProxy(log));
    }

    public LoggingProgressMonitor() {
        super(new LoggingMonitorProxy(null));
    }

    private static class LoggingMonitorProxy
    implements IProgressMonitor {
        private final Log log;
        private PrintStream out = System.out;

        public LoggingMonitorProxy(Log log) {
            this.log = log;
        }

        public void beginTask(String name, int totalWork) {
            if (this.log != null) {
                this.log.debug(name);
            } else {
                this.out.println(name);
            }
        }

        public void done() {
        }

        public void internalWorked(double work) {
        }

        public boolean isCanceled() {
            return false;
        }

        public void setCanceled(boolean value) {
        }

        public void setTaskName(String name) {
        }

        public void subTask(String name) {
            if (this.log != null) {
                this.log.debug("\t" + name);
            } else {
                this.out.println("\t" + name);
            }
        }

        public void worked(int work) {
        }
    }
}

