/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceInfo;
import org.jkiss.utils.CommonUtils;

public class GenericDataSourceInfo
extends JDBCDataSourceInfo {
    private final boolean supportsLimits;
    public boolean supportsCatalogSelection;
    public boolean supportsSchemaSelection;
    private boolean supportsMultipleResults;
    private boolean supportsNullableUniqueConstraints;
    private final boolean supportsTransactionsForDDL;
    private final boolean supportsConstraints;

    public GenericDataSourceInfo(DBPDriver driver, JDBCDatabaseMetaData metaData) {
        super(metaData);
        Object supportSchemaSelection;
        Object supportsCatalogSelection;
        Object supportsStoredCode;
        Object supportsViews;
        Object supportsIndexes;
        this.supportsLimits = CommonUtils.getBoolean((Object)driver.getDriverParameter("supports-limits"), (boolean)true);
        this.setSupportsResultSetScroll(CommonUtils.getBoolean((Object)driver.getDriverParameter("supports-scroll"), (boolean)false));
        this.supportsMultipleResults = CommonUtils.getBoolean((Object)driver.getDriverParameter("supports-multiple-results"), (boolean)false);
        this.supportsTransactionsForDDL = CommonUtils.getBoolean((Object)driver.getDriverParameter("supports-ddl-transactions"), (boolean)true);
        this.setReadOnlyData(CommonUtils.getBoolean((Object)driver.getDriverParameter("read-only-data"), (boolean)false));
        this.setReadOnlyMetaData(CommonUtils.getBoolean((Object)driver.getDriverParameter("read-only-meta-data"), (boolean)false));
        this.supportsCatalogSelection = CommonUtils.getBoolean((Object)driver.getDriverParameter("supports-catalog-selection"), (boolean)true);
        this.supportsSchemaSelection = CommonUtils.getBoolean((Object)driver.getDriverParameter("supports-catalog-selection"), (boolean)true);
        this.supportsNullableUniqueConstraints = false;
        this.supportsConstraints = CommonUtils.getBoolean((Object)driver.getDriverParameter("supports-table-constraints"), (boolean)true);
        Object supportsReferences = driver.getDriverParameter("supports-references");
        if (supportsReferences != null) {
            this.setSupportsReferences(CommonUtils.toBoolean((Object)supportsReferences));
        }
        if ((supportsIndexes = driver.getDriverParameter("supports-indexes")) != null) {
            this.setSupportsIndexes(CommonUtils.toBoolean((Object)supportsIndexes));
        }
        if ((supportsViews = driver.getDriverParameter("supports-views")) != null) {
            this.setSupportsViews(CommonUtils.toBoolean((Object)supportsViews));
        }
        if ((supportsStoredCode = driver.getDriverParameter("supports-stored-code")) != null) {
            this.setSupportsStoredCode(CommonUtils.toBoolean((Object)supportsStoredCode));
        }
        if ((supportsCatalogSelection = driver.getDriverParameter("supports-catalog-selection")) != null) {
            this.supportsCatalogSelection = CommonUtils.toBoolean((Object)supportsCatalogSelection);
        }
        if ((supportSchemaSelection = driver.getDriverParameter("supports-schema-selection")) != null) {
            this.supportsSchemaSelection = CommonUtils.toBoolean((Object)supportSchemaSelection);
        }
    }

    public boolean supportsResultSetLimit() {
        return this.supportsLimits;
    }

    public boolean supportsNullableUniqueConstraints() {
        return this.supportsNullableUniqueConstraints;
    }

    public void setSupportsNullableUniqueConstraints(boolean supportsNullableUniqueConstraints) {
        this.supportsNullableUniqueConstraints = supportsNullableUniqueConstraints;
    }

    public boolean supportsCatalogSelection() {
        return this.supportsCatalogSelection;
    }

    public boolean supportsSchemaSelection() {
        return this.supportsSchemaSelection;
    }

    public boolean supportsMultipleResults() {
        return this.supportsMultipleResults;
    }

    public boolean supportsTransactionsForDDL() {
        return super.supportsTransactionsForDDL() && this.supportsTransactionsForDDL;
    }

    public boolean supportsTableConstraints() {
        return this.supportsConstraints;
    }
}

