/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Color;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.erd.ui.editor.ERDHighlightingHandle;
import org.jkiss.dbeaver.erd.ui.part.AssociationPart;
import org.jkiss.dbeaver.erd.ui.part.AttributePart;
import org.jkiss.dbeaver.erd.ui.part.EntityPart;
import org.jkiss.dbeaver.utils.ListNode;

public class ERDHighlightingManager {
    private static final Log log = Log.getLog(ERDHighlightingManager.class);
    @NotNull
    private final Map<IFigure, PartHighlighter> highlightedParts = new HashMap<IFigure, PartHighlighter>();

    @NotNull
    public ERDHighlightingHandle highlight(@NotNull IFigure part, @NotNull Color color) {
        return this.highlightedParts.computeIfAbsent(part, iFigure -> new PartHighlighter((IFigure)iFigure)).highlight(color);
    }

    @Nullable
    private ERDHighlightingHandle makeHighlightingGroupHandle(@Nullable ListNode<ERDHighlightingHandle> highlightings) {
        if (highlightings == null) {
            return null;
        }
        return () -> {
            for (ERDHighlightingHandle highlighting : highlightings) {
                highlighting.release();
            }
        };
    }

    @Nullable
    public ERDHighlightingHandle highlightAttributeAssociations(@NotNull AttributePart attributePart, @NotNull Color color) {
        if (!(attributePart.getParent() instanceof EntityPart)) {
            return null;
        }
        ListNode<ERDHighlightingHandle> highlightings = null;
        for (Object connection : attributePart.getSourceConnections()) {
            if (!(connection instanceof AssociationPart)) continue;
            highlightings = this.highlightAttributeAssociation(attributePart, (AssociationPart)connection, color, highlightings);
        }
        for (Object connection : attributePart.getTargetConnections()) {
            if (!(connection instanceof AssociationPart)) continue;
            highlightings = this.highlightAttributeAssociation(attributePart, (AssociationPart)connection, color, highlightings);
        }
        EntityPart entityPart = (EntityPart)attributePart.getParent();
        for (Object connection : entityPart.getSourceConnections()) {
            if (!(connection instanceof AssociationPart)) continue;
            highlightings = this.highlightAttributeAssociation(attributePart, (AssociationPart)connection, color, highlightings);
        }
        for (Object connection : entityPart.getTargetConnections()) {
            if (!(connection instanceof AssociationPart)) continue;
            highlightings = this.highlightAttributeAssociation(attributePart, (AssociationPart)connection, color, highlightings);
        }
        return this.makeHighlightingGroupHandle(highlightings);
    }

    @NotNull
    private ListNode<ERDHighlightingHandle> highlightAttributeAssociation(@NotNull AttributePart attributePart, @NotNull AssociationPart associationPart, @Nullable Color color, @Nullable ListNode<ERDHighlightingHandle> highlightings) {
        if (associationPart.getAssociation().getSourceAttributes().contains(attributePart.getAttribute()) || associationPart.getAssociation().getTargetAttributes().contains(attributePart.getAttribute())) {
            highlightings = ListNode.push(highlightings, (Object)this.highlight(associationPart.getFigure(), color));
            return this.highlightAssociationRelatedAttributes(associationPart, color, (ListNode<ERDHighlightingHandle>)highlightings);
        }
        return highlightings;
    }

    @Nullable
    public ERDHighlightingHandle highlightAssociationAndRelatedAttributes(@NotNull AssociationPart associationPart, @NotNull Color color) {
        return this.makeHighlightingGroupHandle(this.highlightAssociationRelatedAttributes(associationPart, color, null));
    }

    @NotNull
    private ListNode<ERDHighlightingHandle> highlightAssociationRelatedAttributes(@NotNull AssociationPart associationPart, @NotNull Color color, @Nullable ListNode<ERDHighlightingHandle> highlightings) {
        if (associationPart.getSource() instanceof EntityPart) {
            for (AttributePart attrPart : this.getEntityAttributes((EntityPart)associationPart.getSource(), associationPart.getAssociation().getSourceAttributes())) {
                highlightings = ListNode.push((ListNode)highlightings, (Object)this.highlight((IFigure)attrPart.getFigure(), color));
            }
        }
        if (associationPart.getTarget() instanceof EntityPart) {
            for (AttributePart attrPart : this.getEntityAttributes((EntityPart)associationPart.getTarget(), associationPart.getAssociation().getTargetAttributes())) {
                highlightings = ListNode.push((ListNode)highlightings, (Object)this.highlight((IFigure)attrPart.getFigure(), color));
            }
        }
        if (associationPart.getSource() instanceof AttributePart) {
            highlightings = ListNode.push(highlightings, (Object)this.highlight((IFigure)((AttributePart)associationPart.getSource()).getFigure(), color));
        }
        if (associationPart.getTarget() instanceof AttributePart) {
            highlightings = ListNode.push((ListNode)highlightings, (Object)this.highlight((IFigure)((AttributePart)associationPart.getTarget()).getFigure(), color));
        }
        return highlightings;
    }

    @NotNull
    private List<AttributePart> getEntityAttributes(@NotNull EntityPart source, @NotNull List<ERDEntityAttribute> columns) {
        ArrayList<AttributePart> result = new ArrayList<AttributePart>(columns.size());
        for (Object attrPart : source.getChildren()) {
            if (!(attrPart instanceof AttributePart) || !columns.contains(((AttributePart)attrPart).getAttribute())) continue;
            result.add((AttributePart)attrPart);
        }
        return result;
    }

    private static final class HighlightingEntry {
        public final Color color;

        public HighlightingEntry(@NotNull Color color) {
            this.color = color;
        }
    }

    private final class PartHighlighter {
        @NotNull
        private final IFigure part;
        @NotNull
        private final Color originalColor;
        private final boolean originalOpaque;
        @NotNull
        private final LinkedList<HighlightingEntry> highlightings = new LinkedList();

        public PartHighlighter(IFigure part) {
            this.originalColor = part instanceof Connection ? part.getForegroundColor() : part.getBackgroundColor();
            this.originalOpaque = part.isOpaque();
            this.part = part;
        }

        private void refresh() {
            try {
                if (this.highlightings.isEmpty()) {
                    if (this.part instanceof Connection) {
                        this.part.setForegroundColor(this.originalColor);
                    } else {
                        this.part.setBackgroundColor(this.originalColor);
                    }
                    this.part.setOpaque(this.originalOpaque);
                } else {
                    if (this.part instanceof Connection) {
                        this.part.setForegroundColor(this.highlightings.getLast().color);
                    } else {
                        this.part.setBackgroundColor(this.highlightings.getLast().color);
                    }
                    this.part.setOpaque(true);
                }
                this.part.repaint();
            }
            catch (Throwable ex) {
                log.warn((Object)"Inconsistent highlighting management detected during figure props refresh.", ex);
            }
        }

        @NotNull
        public ERDHighlightingHandle highlight(@NotNull Color color) {
            HighlightingEntry entry = new HighlightingEntry(color);
            this.highlightings.addLast(entry);
            this.refresh();
            return () -> {
                this.highlightings.remove(entry);
                if (this.highlightings.isEmpty()) {
                    ERDHighlightingManager.this.highlightedParts.remove(this.part);
                }
                this.refresh();
            };
        }
    }
}

