/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils.rest;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.rest.RequestMapping;
import org.jkiss.utils.rest.RequestParameter;
import org.jkiss.utils.rest.RestConstants;
import org.jkiss.utils.rest.RestException;
import org.jkiss.utils.rest.RestProxy;

public class RestClient {
    private static final Pattern ST_LINE_PATTERN = Pattern.compile("\\s*at\\s+([\\w/.$]+)\\((.+)\\)");

    private RestClient() {
    }

    @NotNull
    public static <T> T create(@NotNull URI uri, @NotNull Class<T> cls, @NotNull Gson gson) {
        Object proxy = Proxy.newProxyInstance(cls.getClassLoader(), new Class[]{cls, RestProxy.class}, (InvocationHandler)new ClientInvocationHandler(cls, uri, gson));
        return cls.cast(proxy);
    }

    @NotNull
    public static <T> Builder<T> builder(@NotNull URI uri, @NotNull Class<T> cls) {
        return new Builder<T>(uri, cls);
    }

    private static void handleError(String contents) throws RestException {
        String[] stackTraceRows = contents.split("\n");
        String errorLine = stackTraceRows[0];
        ArrayList<StackTraceElement> stackTraceElements = new ArrayList<StackTraceElement>();
        int i = 1;
        while (i < stackTraceRows.length) {
            Matcher matcher = ST_LINE_PATTERN.matcher(stackTraceRows[i]);
            if (matcher.find()) {
                int fileLine;
                String fileName;
                String methodRef = matcher.group(1);
                int divPos = methodRef.lastIndexOf(46);
                String className = methodRef.substring(0, divPos);
                String methodName = methodRef.substring(divPos + 1);
                String classRef = matcher.group(2);
                divPos = classRef.indexOf(58);
                if (divPos == -1) {
                    fileName = classRef;
                    fileLine = -1;
                } else {
                    fileName = classRef.substring(0, divPos).trim();
                    fileLine = CommonUtils.toInt(classRef.substring(divPos + 1).trim());
                }
                stackTraceElements.add(new StackTraceElement(className, methodName, fileName, fileLine));
            }
            ++i;
        }
        RestException runtimeException = new RestException(errorLine);
        Collections.addAll(stackTraceElements, runtimeException.getStackTrace());
        runtimeException.setStackTrace(stackTraceElements.toArray(new StackTraceElement[0]));
        throw runtimeException;
    }

    public static final class Builder<T> {
        private final URI uri;
        private final Class<T> cls;
        private Gson gson;

        private Builder(@NotNull URI uri, @NotNull Class<T> cls) {
            this.uri = uri;
            this.cls = cls;
            this.gson = RestConstants.DEFAULT_GSON;
        }

        @NotNull
        public Builder<T> setGson(@NotNull Gson gson) {
            this.gson = gson;
            return this;
        }

        @NotNull
        public T create() {
            return RestClient.create(this.uri, this.cls, this.gson);
        }
    }

    private static class ClientInvocationHandler
    implements InvocationHandler,
    RestProxy {
        @NotNull
        private final Class<?> clientClass;
        private final URI uri;
        private final Gson gson;
        private final ExecutorService httpExecutor;
        private final HttpClient client;
        private final ThreadLocal<Type> resultType = new ThreadLocal();

        private ClientInvocationHandler(@NotNull Class<?> clientClass, @NotNull URI uri, @NotNull Gson gson) {
            this.clientClass = clientClass;
            this.uri = uri;
            this.gson = gson;
            this.httpExecutor = Executors.newSingleThreadExecutor();
            this.client = HttpClient.newBuilder().executor(this.httpExecutor).build();
        }

        @Override
        public synchronized Object invoke(Object proxy, Method method, Object[] args) throws RestException {
            Type returnType;
            String contents;
            block19: {
                Class<?> declaringClass = method.getDeclaringClass();
                if (declaringClass == Object.class) {
                    return BeanUtils.handleObjectMethod(proxy, method, args);
                }
                if (declaringClass == RestProxy.class) {
                    this.setNextCallResultType((Type)args[0]);
                    return null;
                }
                if (method.getName().equals("close") && (declaringClass == AutoCloseable.class || declaringClass == this.clientClass)) {
                    this.closeClient();
                    return null;
                }
                if (this.httpExecutor.isShutdown() || this.httpExecutor.isTerminated()) {
                    throw new RestException("Rest client has been terminated");
                }
                RequestMapping mapping = method.getDeclaredAnnotation(RequestMapping.class);
                if (mapping == null) {
                    throw ClientInvocationHandler.createException(method, "it's not annotated with @RequestMapping");
                }
                Parameter[] parameters = method.getParameters();
                LinkedHashMap<String, JsonElement> values = new LinkedHashMap<String, JsonElement>(parameters.length);
                int i = 0;
                while (i < parameters.length) {
                    Parameter p = parameters[i];
                    RequestParameter param = p.getDeclaredAnnotation(RequestParameter.class);
                    if (param == null) {
                        throw ClientInvocationHandler.createException(method, "one or more of its parameters are not annotated with @RequestParameter");
                    }
                    if (CommonUtils.isEmptyTrimmed(param.value())) {
                        throw ClientInvocationHandler.createException(method, "one or more of its parameters has empty name specified in @RequestParameter");
                    }
                    if (values.put(param.value(), this.gson.toJsonTree(args[i])) != null) {
                        throw ClientInvocationHandler.createException(method, "one or more of its parameters share the same name specified in @RequestParameter");
                    }
                    ++i;
                }
                String endpoint = mapping.value();
                if (CommonUtils.isEmpty(endpoint)) {
                    endpoint = method.getName();
                }
                StringBuilder url = new StringBuilder();
                url.append(this.uri);
                if (url.charAt(url.length() - 1) != '/') {
                    url.append('/');
                }
                url.append(endpoint);
                HttpResponse.BodyHandler readerBodyHandler = info -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8);
                String requestString = this.gson.toJson(values);
                System.out.println("REQUEST: " + requestString);
                HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(url.toString())).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(requestString)).build();
                HttpResponse response = this.client.send(httpRequest, readerBodyHandler);
                contents = (String)response.body();
                if (response.statusCode() != 200) {
                    RestClient.handleError(contents);
                }
                if ((returnType = this.resultType.get()) == null) {
                    returnType = method.getReturnType();
                } else {
                    this.resultType.remove();
                }
                if (returnType != Void.TYPE) break block19;
                return null;
            }
            try {
                Type[] bounds;
                if (returnType instanceof TypeVariable && (bounds = ((TypeVariable)returnType).getBounds()).length > 0) {
                    returnType = bounds[0];
                }
                System.out.println("RESPONSE: " + contents);
                return this.gson.fromJson(contents, returnType);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RestException(e);
            }
        }

        private void closeClient() {
            if (!this.httpExecutor.isShutdown()) {
                this.httpExecutor.shutdown();
            }
        }

        @NotNull
        private static RestException createException(@NotNull Method method, @NotNull String reason) {
            return new RestException("Unable to invoke the method " + method + " because " + reason);
        }

        @Override
        public void setNextCallResultType(Type type) {
            this.resultType.set(type);
        }
    }
}

