/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.nativetool;

import java.io.File;
import java.util.Collection;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.nativetool.AbstractImportExportSettings;
import org.jkiss.dbeaver.tasks.nativetool.ExportSettingsExtension;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractNativeImportExportWizard;
import org.jkiss.dbeaver.tasks.ui.nativetool.internal.TaskNativeUIMessages;
import org.jkiss.dbeaver.ui.UIUtils;

public abstract class AbstractNativeExportWizard<SETTINGS extends AbstractImportExportSettings<DBSObject>, INFO>
extends AbstractNativeImportExportWizard<SETTINGS, DBSObject> {
    protected AbstractNativeExportWizard(Collection<DBSObject> objects, String title) {
        super(objects, title);
    }

    protected AbstractNativeExportWizard(DBTTask task) {
        super(task);
    }

    @Override
    public boolean performFinish() {
        AbstractImportExportSettings settings = (AbstractImportExportSettings)this.getSettings();
        for (Object info : ((ExportSettingsExtension)settings).getExportObjects()) {
            File dir = ((ExportSettingsExtension)this.getSettings()).getOutputFolder(info);
            if (!dir.exists() && !dir.mkdirs()) {
                this.logPage.setMessage("Can't create directory '" + dir.getAbsolutePath() + "'", 3);
                this.getContainer().updateMessage();
                continue;
            }
            File file = ((ExportSettingsExtension)settings).getOutputFile(info);
            if (!file.exists() || file.isDirectory()) continue;
            boolean deleteFile = UIUtils.confirmAction((String)TaskNativeUIMessages.tools_db_export_wizard_file_already_exists_title, (String)TaskNativeUIMessages.tools_db_export_wizard_file_already_exists_message);
            if (!deleteFile) {
                return false;
            }
            boolean fileDeleted = file.delete();
            if (fileDeleted) continue;
            DBWorkbench.getPlatformUI().showError(TaskNativeUIMessages.tools_db_export_wizard_file_have_not_been_deleted_title, TaskNativeUIMessages.tools_db_export_wizard_file_have_not_been_deleted_message);
            return false;
        }
        return super.performFinish();
    }
}

