/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.preferences;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;

public class PrefPageSQLCodeEditing
extends TargetPrefPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.sql.codeeditor";
    private Button csFoldingEnabled;
    private Button csSmartWordsIterator;
    private Button csMarkOccurrencesUnderCursor;
    private Button csMarkOccurrencesForSelection;
    private Button csProblemMarkersEnabled;
    private Button acSingleQuotesCheck;
    private Button acDoubleQuotesCheck;
    private Button acBracketsCheck;
    private Button afKeywordCase;
    private Button afExtractFromSource;

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        Group foldingGroup = UIUtils.createControlGroup((Composite)composite, (String)SQLEditorMessages.pref_page_sql_completion_group_misc, (int)2, (int)34, (int)0);
        this.csFoldingEnabled = UIUtils.createCheckbox((Composite)foldingGroup, (String)SQLEditorMessages.pref_page_sql_completion_label_folding_enabled, (String)SQLEditorMessages.pref_page_sql_completion_label_folding_enabled_tip, (boolean)false, (int)2);
        this.csSmartWordsIterator = UIUtils.createCheckbox((Composite)foldingGroup, (String)SQLEditorMessages.pref_page_sql_completion_label_smart_word_iterator, (String)SQLEditorMessages.pref_page_sql_completion_label_smart_word_iterator_tip, (boolean)false, (int)2);
        this.csMarkOccurrencesUnderCursor = UIUtils.createCheckbox((Composite)foldingGroup, (String)SQLEditorMessages.pref_page_sql_completion_label_mark_occurrences, (String)SQLEditorMessages.pref_page_sql_completion_label_mark_occurrences_tip, (boolean)false, (int)2);
        this.csMarkOccurrencesForSelection = UIUtils.createCheckbox((Composite)foldingGroup, (String)SQLEditorMessages.pref_page_sql_completion_label_mark_occurrences_for_selections, (String)SQLEditorMessages.pref_page_sql_completion_label_mark_occurrences_for_selections_tip, (boolean)false, (int)2);
        this.csProblemMarkersEnabled = UIUtils.createCheckbox((Composite)foldingGroup, (String)SQLEditorMessages.pref_page_sql_completion_label_problem_markers_enabled, (String)SQLEditorMessages.pref_page_sql_completion_label_problem_markers_enabled_tip, (boolean)false, (int)2);
        Group acGroup = UIUtils.createControlGroup((Composite)composite, (String)SQLEditorMessages.pref_page_sql_format_group_auto_close, (int)1, (int)34, (int)0);
        this.acSingleQuotesCheck = UIUtils.createCheckbox((Composite)acGroup, (String)SQLEditorMessages.pref_page_sql_format_label_single_quotes, (boolean)false);
        this.acDoubleQuotesCheck = UIUtils.createCheckbox((Composite)acGroup, (String)SQLEditorMessages.pref_page_sql_format_label_double_quotes, (boolean)false);
        this.acBracketsCheck = UIUtils.createCheckbox((Composite)acGroup, (String)SQLEditorMessages.pref_page_sql_format_label_brackets, (boolean)false);
        Group afGroup = UIUtils.createControlGroup((Composite)composite, (String)SQLEditorMessages.pref_page_sql_format_group_auto_format, (int)1, (int)34, (int)0);
        this.afKeywordCase = UIUtils.createCheckbox((Composite)afGroup, (String)SQLEditorMessages.pref_page_sql_format_label_convert_keyword_case, (String)SQLEditorMessages.pref_page_sql_format_label_convert_keyword_case_tip, (boolean)false, (int)1);
        this.afExtractFromSource = UIUtils.createCheckbox((Composite)afGroup, (String)SQLEditorMessages.pref_page_sql_format_label_extract_sql_from_source_code, (String)SQLEditorMessages.pref_page_sql_format_label_extract_sql_from_source_code_tip, (boolean)false, (int)1);
        this.performDefaults();
        return composite;
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        this.csFoldingEnabled.setSelection(store.getBoolean("SQLEditor.Folding.enabled"));
        this.csSmartWordsIterator.setSelection(store.getBoolean("SQLEditor.smartWordIterator"));
        this.csMarkOccurrencesUnderCursor.setSelection(store.getBoolean("SQLEditor.markOccurrences"));
        this.csMarkOccurrencesForSelection.setSelection(store.getBoolean("SQLEditor.markOccurrences.forSelection"));
        this.csProblemMarkersEnabled.setSelection(store.getBoolean("SQLEditor.problemMarkers.enabled"));
        this.acSingleQuotesCheck.setSelection(store.getBoolean("SQLEditor.closeSingleQuotes"));
        this.acDoubleQuotesCheck.setSelection(store.getBoolean("SQLEditor.closeDoubleQuotes"));
        this.acBracketsCheck.setSelection(store.getBoolean("SQLEditor.closeBrackets"));
        this.afKeywordCase.setSelection(store.getBoolean("SQLEditor.format.keywordCaseAuto"));
        this.afExtractFromSource.setSelection(store.getBoolean("SQLEditor.format.extractFromSource"));
    }

    protected void savePreferences(DBPPreferenceStore store) {
        store.setValue("SQLEditor.Folding.enabled", this.csFoldingEnabled.getSelection());
        store.setValue("SQLEditor.smartWordIterator", this.csSmartWordsIterator.getSelection());
        store.setValue("SQLEditor.markOccurrences", this.csMarkOccurrencesUnderCursor.getSelection());
        store.setValue("SQLEditor.markOccurrences.forSelection", this.csMarkOccurrencesForSelection.getSelection());
        store.setValue("SQLEditor.problemMarkers.enabled", this.csProblemMarkersEnabled.getSelection());
        store.setValue("SQLEditor.closeSingleQuotes", this.acSingleQuotesCheck.getSelection());
        store.setValue("SQLEditor.closeDoubleQuotes", this.acDoubleQuotesCheck.getSelection());
        store.setValue("SQLEditor.closeBrackets", this.acBracketsCheck.getSelection());
        store.setValue("SQLEditor.format.keywordCaseAuto", this.afKeywordCase.getSelection());
        store.setValue("SQLEditor.format.extractFromSource", this.afExtractFromSource.getSelection());
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("SQLEditor.Folding.enabled");
        store.setToDefault("SQLEditor.smartWordIterator");
        store.setToDefault("SQLEditor.markOccurrences");
        store.setToDefault("SQLEditor.markOccurrences.forSelection");
        store.setToDefault("SQLEditor.problemMarkers.enabled");
        store.setToDefault("SQLEditor.closeSingleQuotes");
        store.setToDefault("SQLEditor.closeDoubleQuotes");
        store.setToDefault("SQLEditor.closeBrackets");
        store.setToDefault("SQLEditor.format.keywordCaseAuto");
        store.setToDefault("SQLEditor.format.extractFromSource");
    }

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer container) {
        DBPPreferenceStore store = container.getPreferenceStore();
        return store.contains("SQLEditor.Folding.enabled") || store.contains("SQLEditor.smartWordIterator") || store.contains("SQLEditor.markOccurrences") || store.contains("SQLEditor.markOccurrences.forSelection") || store.contains("SQLEditor.problemMarkers.enabled") || store.contains("SQLEditor.closeSingleQuotes") || store.contains("SQLEditor.closeDoubleQuotes") || store.contains("SQLEditor.closeBrackets") || store.contains("SQLEditor.format.keywordCaseAuto") || store.contains("SQLEditor.format.extractFromSource");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

