from dojo.models import Finding

DESCRIPTION_TEMPLATE = """{title}
**Fixed version:** {fixed_version}
"""

TRIVY_SEVERITIES = {
    "CRITICAL": "Critical",
    "HIGH": "High",
    "MEDIUM": "Medium",
    "LOW": "Low",
    "UNKNOWN": "Info",
}


class TrivyVulnerabilityHandler:
    def handle_vulns(self, service, vulnerabilities, test):
        findings = []
        for vulnerability in vulnerabilities:
            vuln_id = vulnerability.get("vulnerabilityID", "0")
            severity = TRIVY_SEVERITIES[vulnerability.get("severity")]
            references = vulnerability.get("primaryLink")
            mitigation = vulnerability.get("fixedVersion")
            package_name = vulnerability.get("resource")
            package_version = vulnerability.get("installedVersion")
            cvssv3_score = vulnerability.get("score")

            finding_tags = []
            target_target = None
            target_class = None
            package_path = None

            if vulnerability.get("packageType"):
                package_type = vulnerability.get("packageType")
                finding_tags.append(package_type)

            if vulnerability.get("class"):
                target_class = vulnerability.get("class")
                finding_tags.append(target_class)

            if vulnerability.get("packagePath"):
                package_path = vulnerability.get("packagePath")

            if vulnerability.get("target"):
                target_target = vulnerability.get("target")

            if target_class == "os-pkgs" or target_class == "lang-pkgs":
                if package_path:
                    file_path = package_path
                elif target_target:
                    file_path = target_target
                else:
                    file_path = None
            else:
                file_path = None

            description = DESCRIPTION_TEMPLATE.format(
                title=vulnerability.get("title"), fixed_version=mitigation,
            )

            title = f"{vuln_id} {package_name} {package_version}"
            finding = Finding(
                test=test,
                title=title,
                severity=severity,
                references=references,
                mitigation=mitigation,
                component_name=package_name,
                component_version=package_version,
                cvssv3_score=cvssv3_score,
                description=description,
                static_finding=True,
                dynamic_finding=False,
                service=service,
                file_path=file_path,
                tags=finding_tags,
            )
            if vuln_id:
                finding.unsaved_vulnerability_ids = [vuln_id]
            findings.append(finding)
        return findings
