/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.GraphLine;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ResidueColourScheme;
import jalview.util.Comparison;
import java.awt.Color;

public class AnnotationColourGradient
extends ResidueColourScheme {
    public static int NO_THRESHOLD = -1;
    public static int BELOW_THRESHOLD = 0;
    public static int ABOVE_THRESHOLD = 1;
    public AlignmentAnnotation annotation;
    int aboveAnnotationThreshold = -1;
    public boolean thresholdIsMinMax = false;
    GraphLine annotationThreshold;
    float r1;
    float g1;
    float b1;
    float rr;
    float gg;
    float bb;
    float dr;
    float dg;
    float db;
    ColourSchemeI colourScheme;
    public boolean predefinedColours = false;

    public AnnotationColourGradient(AlignmentAnnotation annotation, ColourSchemeI originalColour, int aboveThreshold) {
        this.colourScheme = originalColour instanceof AnnotationColourGradient ? ((AnnotationColourGradient)originalColour).colourScheme : originalColour;
        this.annotation = annotation;
        this.aboveAnnotationThreshold = aboveThreshold;
        if (aboveThreshold != NO_THRESHOLD && annotation.threshold != null) {
            this.annotationThreshold = annotation.threshold;
        }
    }

    public AnnotationColourGradient(AlignmentAnnotation annotation, Color minColour, Color maxColour, int aboveThreshold) {
        this.annotation = annotation;
        this.aboveAnnotationThreshold = aboveThreshold;
        if (aboveThreshold != NO_THRESHOLD && annotation.threshold != null) {
            this.annotationThreshold = annotation.threshold;
        }
        this.r1 = minColour.getRed();
        this.g1 = minColour.getGreen();
        this.b1 = minColour.getBlue();
        this.rr = (float)maxColour.getRed() - this.r1;
        this.gg = (float)maxColour.getGreen() - this.g1;
        this.bb = (float)maxColour.getBlue() - this.b1;
    }

    public String getAnnotation() {
        return this.annotation.label;
    }

    public int getAboveThreshold() {
        return this.aboveAnnotationThreshold;
    }

    public float getAnnotationThreshold() {
        if (this.annotationThreshold == null) {
            return 0.0f;
        }
        return this.annotationThreshold.value;
    }

    public ColourSchemeI getBaseColour() {
        return this.colourScheme;
    }

    public Color getMinColour() {
        return new Color((int)this.r1, (int)this.g1, (int)this.b1);
    }

    public Color getMaxColour() {
        return new Color((int)(this.r1 + this.rr), (int)(this.g1 + this.gg), (int)(this.b1 + this.bb));
    }

    public Color findColour(char c) {
        return Color.red;
    }

    public Color findColour(char c, int j) {
        Color currentColour = Color.white;
        if ((this.threshold == 0 || this.aboveThreshold(c, j)) && j < this.annotation.annotations.length && this.annotation.annotations[j] != null && !Comparison.isGap(c)) {
            if (this.predefinedColours) {
                if (this.annotation.annotations[j].colour != null) {
                    return this.annotation.annotations[j].colour;
                }
                return currentColour;
            }
            if (this.aboveAnnotationThreshold == NO_THRESHOLD || this.annotationThreshold != null && this.aboveAnnotationThreshold == ABOVE_THRESHOLD && this.annotation.annotations[j].value >= this.annotationThreshold.value || this.annotationThreshold != null && this.aboveAnnotationThreshold == BELOW_THRESHOLD && this.annotation.annotations[j].value <= this.annotationThreshold.value) {
                float range = 1.0f;
                range = this.thresholdIsMinMax && this.annotation.threshold != null && this.aboveAnnotationThreshold == ABOVE_THRESHOLD && this.annotation.annotations[j].value > this.annotation.threshold.value ? (this.annotation.annotations[j].value - this.annotation.threshold.value) / (this.annotation.graphMax - this.annotation.threshold.value) : (this.thresholdIsMinMax && this.annotation.threshold != null && this.aboveAnnotationThreshold == BELOW_THRESHOLD && this.annotation.annotations[j].value > this.annotation.graphMin ? (this.annotation.annotations[j].value - this.annotation.graphMin) / (this.annotation.threshold.value - this.annotation.graphMin) : (this.annotation.annotations[j].value - this.annotation.graphMin) / (this.annotation.graphMax - this.annotation.graphMin));
                if (this.colourScheme != null) {
                    currentColour = this.colourScheme.findColour(c, j);
                } else if (range != 0.0f) {
                    this.dr = this.rr * range + this.r1;
                    this.dg = this.gg * range + this.g1;
                    this.db = this.bb * range + this.b1;
                    currentColour = new Color((int)this.dr, (int)this.dg, (int)this.db);
                }
            }
        }
        if (this.conservationColouring) {
            currentColour = this.applyConservation(currentColour, j);
        }
        return currentColour;
    }
}

