/*
 * Decompiled with CFR 0.152.
 */
package xades4j.utils;

import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.transforms.Transforms;
import xades4j.UnsupportedAlgorithmException;
import xades4j.algorithms.Algorithm;

public final class CanonicalizerUtils {
    public static void checkC14NAlgorithm(Algorithm c14n) throws UnsupportedAlgorithmException {
        try {
            Canonicalizer.getInstance((String)c14n.getUri());
        }
        catch (InvalidCanonicalizerException ex) {
            throw new UnsupportedAlgorithmException("Unsupported canonicalization method", c14n.getUri(), ex);
        }
    }

    public static boolean allTransformsAreC14N(Reference r) throws XMLSecurityException {
        Transforms transforms = r.getTransforms();
        try {
            for (int i = 0; i < transforms.getLength(); ++i) {
                Canonicalizer.getInstance((String)transforms.item(i).getURI());
            }
            return true;
        }
        catch (InvalidCanonicalizerException ex) {
            return false;
        }
    }
}

