/*
 * Decompiled with CFR 0.152.
 */
package xades4j.utils;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509CRL;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.x509.extension.X509ExtensionUtil;

public class CrlExtensionsUtils {
    private CrlExtensionsUtils() {
    }

    public static BigInteger getCrlNumber(X509CRL crl) throws IOException {
        byte[] crlNumEnc = crl.getExtensionValue(X509Extension.cRLNumber.getId());
        BigInteger crlNum = null;
        if (crlNumEnc != null) {
            ASN1Primitive derCrlNum = X509ExtensionUtil.fromExtensionValue((byte[])crlNumEnc);
            crlNum = CRLNumber.getInstance((Object)derCrlNum).getCRLNumber();
        }
        return crlNum;
    }
}

